import React, { useState } from 'react'
import { t } from 'ttag'
import { StyledModalHeader, StyledInput, CloseModalButton } from '../StyledComponents/Components'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { Box, Text, Flex } from 'rebass'

function DecoctionTool (props) {
  const decoctionCalc = (decoction) => {
    let fraction = ((decoction.targetTemp - decoction.startTemp) / (decoction.boilTemp - decoction.startTemp))
    fraction += fraction * decoction.correction / 100
    const vol = fraction * decoction.mashVol
    return { fraction, vol }
  }

  const [decoction, setDecoction] = useState({ mashVol: 10, targetTemp: 65, startTemp: 50, boilTemp: 100, correction: 15 })

  return (
    <DialogOverlay
      style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
      isOpen={props.dialogShowDecoction}
    >
      <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
        <StyledModalHeader>{t`Decoction`}</StyledModalHeader>

        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Mash Volume (L)`}</label></Box>
          <Box><StyledInput type='number' value={decoction.mashVol} onChange={e => setDecoction({ ...decoction, mashVol: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Target Temperature (°C)`}</label></Box>
          <Box><StyledInput type='number' value={decoction.targetTemp} onChange={e => setDecoction({ ...decoction, targetTemp: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Starting Temperature (°C)`}</label></Box>
          <Box><StyledInput type='number' value={decoction.startTemp} onChange={e => setDecoction({ ...decoction, startTemp: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Boiling Temperature (°C)`}</label></Box>
          <Box><StyledInput type='number' value={decoction.boilTemp} onChange={e => setDecoction({ ...decoction, boilTemp: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Correction Factor`}</label></Box>
          <Box><StyledInput type='number' value={decoction.correction} onChange={e => setDecoction({ ...decoction, correction: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mt={4}>
          <Text fontWeight='bold' width='175px'>{t`Decoction Volume`}</Text>
          <Text>{Math.round(decoctionCalc(decoction).vol * 100) / 100} L</Text>
        </Flex>
        <Flex>
          <Text fontWeight='bold' width='175px'>{t`Volume Fraction`}</Text>
          <Text>{(decoctionCalc(decoction).fraction * 100).toFixed(2)} %</Text>
        </Flex>

        <div className='row-reverse-wrapper'>
          <CloseModalButton onClick={() => props.closeDialogDecoction()}>{t`Close`}</CloseModalButton>
        </div>
      </DialogContent>
    </DialogOverlay>

  )
}

export default DecoctionTool
