import React, { useState } from 'react'
import { t } from 'ttag'
import { StyledModalHeader, StyledInput, CloseModalButton } from '../StyledComponents/Components'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { Box, Text, Flex } from 'rebass'

function HydrometerTool (props) {
  const correctionFactor = (hydrometer) => ((hydrometer.measuredGravity - (hydrometer.calibTemp + 288.9414) / (508929.2 * (hydrometer.calibTemp + 68.12963)) * Math.pow((hydrometer.calibTemp - 3.9863), 2)) / (1 - (hydrometer.sampleTemp + 288.9414) / (508929.2 * (hydrometer.sampleTemp + 68.12963)) * Math.pow((hydrometer.sampleTemp - 3.9863), 2))) - hydrometer.measuredGravity

  const [hydrometer, setHydrometer] = useState({ measuredGravity: 1.035, calibTemp: 20, sampleTemp: 70 })
  return (
    <DialogOverlay
      style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
      isOpen={props.dialogShowHydrometer}
    >
      <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
        <StyledModalHeader>{t`Hydrometer`}</StyledModalHeader>

        <Flex mb={2}>
          <Box pr={4} width='175px' ><label>{t`Measured Gravity`}</label> </Box>
          <Box><StyledInput type='number' min='0.800' max='100' step='0.001' value={hydrometer.measuredGravity} onChange={e => setHydrometer({ ...hydrometer, measuredGravity: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px' ><label>{t`Calibration Temperature (°C)`}</label> </Box>
          <Box><StyledInput type='number' min='1' max='100' step='1' value={hydrometer.calibTemp} onChange={e => setHydrometer({ ...hydrometer, calibTemp: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px' ><label>{t`Measured Temperature (°C)`}</label> </Box>
          <Box><StyledInput type='number' min='1' max='100' step='1' value={hydrometer.sampleTemp} onChange={e => setHydrometer({ ...hydrometer, sampleTemp: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mt={4}>
          <Text fontWeight='bold' width='175px'>{t`Calculated Gravity`}</Text>
          <Text>{Math.round((correctionFactor(hydrometer) + hydrometer.measuredGravity) * 1000) / 1000 }</Text>
        </Flex>

        <div className='row-reverse-wrapper'>
          <CloseModalButton onClick={() => props.closeDialogHydrometer()}>{t`Close`}</CloseModalButton>
        </div>
      </DialogContent>
    </DialogOverlay>
  )
}

export default HydrometerTool
