const generateString = recipe =>
  `<?xml version="1.0" encoding="UTF-8"?>
  <RECIPES>
    <RECIPE>
      <NAME>${recipe.name}</NAME>
      <VERSION>1</VERSION>
      <TYPE></TYPE>
      <BREWER>${recipe.brewer}</BREWER>
      <STYLE>
        <NAME>${recipe.style.name}</NAME>
        <VERSION>1</VERSION>
        <CATEGORY /><CATEGORY_NUMBER />
        <STYLE_LETTER /><STYLE_GUIDE />
        <TYPE />
        <OG_MIN />
        <OG_MAX />
        <FG_MIN />
        <FG_MAX />
        <IBU_MIN />
        <IBU_MAX />
        <COLOR_MIN />
        <COLOR_MAX />
      </STYLE>
      <BATCH_SIZE>${recipe.batch_size}</BATCH_SIZE>
      <BOIL_SIZE>${recipe.preboilVolume}</BOIL_SIZE>
      <BOIL_TIME>${recipe.boil_time}</BOIL_TIME>
      <EFFICIENCY>${recipe.efficiency}</EFFICIENCY>
      <EST_OG>${recipe.og}</EST_OG><EST_FG>${recipe.fg}</EST_FG>
      <IBU>${recipe.ibu}</IBU>
      <EST_ABV>${recipe.alc}</EST_ABV>
      <FERMENTABLES>
        ${recipe.fermentables.map(fermentable => `
        <FERMENTABLE>
          <NAME>${fermentable.name}</NAME>
          <VERSION>1</VERSION>
          <AMOUNT>${fermentable.amount / 1000}</AMOUNT>
          <TYPE>${fermentable.type}</TYPE>
          <YIELD>${fermentable.yield}</YIELD>
          ${(fermentable.use === 'add_to_flameout' || fermentable.use === 'add_to_fermentation' || fermentable.use === 'add_to_package') ? '<ADD_AFTER_BOIL>TRUE</ADD_AFTER_BOIL>'
    : '<ADD_AFTER_BOIL>FALSE</ADD_AFTER_BOIL>'}
          <COLOR>${fermentable.color / 1.97}</COLOR>
          <DISPLAY_COLOR>${fermentable.color} EBC</DISPLAY_COLOR>
        </FERMENTABLE>`).join('')}
      </FERMENTABLES>
      <HOPS>
        ${recipe.hops.map(hop => `
          <HOP>
            <NAME>${hop.name}</NAME>
            <VERSION>1</VERSION>
            <AMOUNT>${hop.amount / 1000}</AMOUNT>
            ${(hop.form === 0 || hop.form === 'Pellet') ? '<FORM>Pellet</FORM>'
    : (hop.form === 1 || hop.form === 'Leaf') ? '<FORM>Leaf</FORM>'
      : '<FORM>Plug</FORM>'}
            <TIME> ${hop.time || 0} </TIME>
            <ALPHA> ${hop.alpha} </ALPHA>
            ${(hop.use === 'Flame Out') ? '<USE>Aroma</USE>' : `<USE>${hop.use}</USE>`}
          </HOP>`).join('')}
      </HOPS>
      <MISCS>
        ${recipe.miscs.map(misc => `
          <MISC>
            <NAME>${misc.name}</NAME>
            <VERSION>1</VERSION>
            <AMOUNT>${misc.amount / 1000}</AMOUNT>
            <TYPE>${misc.type}</TYPE>
            <USE>${misc.use}</USE>
            <AMOUNT_IS_WEIGHT>TRUE</AMOUNT_IS_WEIGHT>
            <TIME>${misc.time}</TIME>
          </MISC>`).join('')}
      </MISCS>
      <YEASTS>
      ${recipe.yeasts.map(yeast => `
          <YEAST>
            <NAME>${yeast.name}</NAME>
            <VERSION>1</VERSION>
             <TYPE />
             <FORM> ${yeast.form} </FORM>
             <LABORATORY>${yeast.laboratory}</LABORATORY>
             <PRODUCT_ID>${yeast.product_id}</PRODUCT_ID>
             <ATTENUATION>${yeast.attenuation}</ATTENUATION>
          </YEAST>`).join('')}
      </YEASTS>

      <WATERS/>

      <MASH>
        <NAME></NAME>
        <VERSION>1</VERSION>
        <GRAIN_TEMP></GRAIN_TEMP>
        <TUN_TEMP></TUN_TEMP>
        <SPARGE_TEMP></SPARGE_TEMP>
        <PH></PH>
        <MASH_STEPS>
        ${recipe.mash.mash_steps.map(step => `
            <MASH_STEP>
              <NAME>${step.name}</NAME>
              <VERSION>1</VERSION>
              <TYPE>${step.type}</TYPE>
              <STEP_TIME>${step.step_time}</STEP_TIME>
              <STEP_TEMP>${step.step_temp}</STEP_TEMP>
              <INFUSE_AMOUNT>0</INFUSE_AMOUNT>
            </MASH_STEP>`).join('')}
        </MASH_STEPS>
      </MASH>
      <NOTES>${recipe.notes}</NOTES>
    </RECIPE>
  </RECIPES>
  `

export { generateString as default }
