/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.inventory.InventoryRange;
import codechicken.lib.vec.Vector3;
import com.google.common.base.Objects;
import net.minecraftforge.common.ForgeDirection;

public class InventoryUtils {
    public static final ForgeDirection[] chestSides = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    public static ye decrStackSize(mo inv, int slot, int size) {
        ye item = inv.a(slot);
        if (item != null) {
            if (item.b <= size) {
                ye itemstack = item;
                inv.a(slot, null);
                inv.e();
                return itemstack;
            }
            ye itemstack1 = item.a(size);
            if (item.b == 0) {
                inv.a(slot, null);
            }
            inv.e();
            return itemstack1;
        }
        return null;
    }

    public static ye getStackInSlotOnClosing(mo inv, int slot) {
        ye stack = inv.a(slot);
        inv.a(slot, null);
        return stack;
    }

    public static int incrStackSize(ye base, ye addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.b);
        }
        return 0;
    }

    public static int incrStackSize(ye base, int addition) {
        int totalSize = base.b + addition;
        if (totalSize <= base.e()) {
            return addition;
        }
        if (base.b < base.e()) {
            return base.e() - base.b;
        }
        return 0;
    }

    public static cg writeItemStacksToTag(ye[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static cg writeItemStacksToTag(ye[] items, int maxQuantity) {
        cg tagList = new cg();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                by tag = new by();
                tag.a("Slot", (short)i);
                items[i].b(tag);
                if (maxQuantity > Short.MAX_VALUE) {
                    tag.a("Quantity", items[i].b);
                } else if (maxQuantity > 127) {
                    tag.a("Quantity", (short)items[i].b);
                }
                tagList.a((cl)tag);
            }
            ++i;
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ye[] items, cg tagList) {
        int i = 0;
        while (i < tagList.c()) {
            by tag = (by)tagList.b(i);
            short b = tag.d("Slot");
            items[b] = ye.a((by)tag);
            if (tag.b("Quantity")) {
                cl qtag = tag.a("Quantity");
                if (qtag instanceof cf) {
                    items[b].b = ((cf)qtag).a;
                } else if (qtag instanceof cj) {
                    items[b].b = ((cj)qtag).a;
                }
            }
            ++i;
        }
    }

    public static void dropItem(ye stack, abw world, Vector3 dropLocation) {
        ss item = new ss(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.x = world.s.nextGaussian() * 0.05;
        item.y = world.s.nextGaussian() * 0.05 + (double)0.2f;
        item.z = world.s.nextGaussian() * 0.05;
        world.d((nn)item);
    }

    public static ye copyStack(ye stack, int quantity) {
        if (stack == null) {
            return null;
        }
        stack = stack.m();
        stack.b = quantity;
        return stack;
    }

    public static int getInsertableQuantity(InventoryRange inv, ye stack) {
        int quantity = 0;
        stack = InventoryUtils.copyStack(stack, Integer.MAX_VALUE);
        int[] nArray = inv.slots;
        int n = inv.slots.length;
        int n2 = 0;
        while (n2 < n) {
            int slot = nArray[n2];
            quantity += InventoryUtils.fitStackInSlot(inv, slot, stack);
            ++n2;
        }
        return quantity;
    }

    public static int fitStackInSlot(InventoryRange inv, int slot, ye stack) {
        ye base = inv.inv.a(slot);
        if (!InventoryUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = base != null ? InventoryUtils.incrStackSize(base, inv.inv.d() - base.b) : inv.inv.d();
        return Math.min(fit, stack.b);
    }

    public static boolean mergeItemStack(InventoryRange inv, ye stack, boolean doMerge) {
        if (doMerge && !InventoryUtils.mergeItemStack(inv, stack, false)) {
            return false;
        }
        stack = stack.m();
        int pass = 0;
        while (pass < 2) {
            int[] nArray = inv.slots;
            int n = inv.slots.length;
            int n2 = 0;
            while (n2 < n) {
                int slot = nArray[n2];
                ye base = inv.inv.a(slot);
                int fit = InventoryUtils.fitStackInSlot(inv, slot, stack);
                if (fit != 0) {
                    if (base != null) {
                        stack.b -= fit;
                        if (doMerge) {
                            base.b += fit;
                            inv.inv.a(slot, base);
                        }
                    } else if (pass == 1) {
                        if (doMerge) {
                            inv.inv.a(slot, InventoryUtils.copyStack(stack, fit));
                        }
                        stack.b -= fit;
                    }
                    if (stack.b == 0) {
                        return true;
                    }
                }
                ++n2;
            }
            ++pass;
        }
        return false;
    }

    public static boolean areStacksIdentical(ye stack1, ye stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.d == stack2.d && stack1.k() == stack2.k() && stack1.b == stack2.b && Objects.equal((Object)stack1.q(), (Object)stack2.q());
    }

    public static mo getInventory(abw world, int x, int y, int z) {
        asp tile = world.r(x, y, z);
        if (!(tile instanceof mo)) {
            return null;
        }
        if (tile instanceof ary) {
            return InventoryUtils.getChest((ary)tile);
        }
        return (mo)tile;
    }

    public static mo getChest(ary chest) {
        ForgeDirection[] forgeDirectionArray = chestSides;
        int n = chestSides.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeDirection fside = forgeDirectionArray[n2];
            if (chest.k.a(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ) == chest.q().cF) {
                return new mn("container.chestDouble", (mo)((ary)chest.k.r(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ)), (mo)chest);
            }
            ++n2;
        }
        return chest;
    }

    public static boolean canStack(ye stack1, ye stack2) {
        return stack1 == null || stack2 == null || stack1.d == stack2.d && (!stack2.h() || stack2.k() == stack1.k()) && ye.a((ye)stack2, (ye)stack1) && stack1.f();
    }

    public static void consumeItem(mo inv, int slot) {
        ye stack = inv.a(slot);
        yc item = stack.b();
        if (item.u()) {
            ye container = item.getContainerItemStack(stack);
            inv.a(slot, container);
        } else {
            inv.a(slot, 1);
        }
    }

    public static int stackSize(mo inv, int slot) {
        ye stack = inv.a(slot);
        return stack == null ? 0 : stack.b;
    }

    public static ye getRemovableStack(InventoryRange inv, int slot) {
        ye stack = inv.inv.a(slot);
        if (stack == null || !inv.canExtractItem(slot, stack)) {
            return null;
        }
        return stack;
    }

    public static void dropOnClose(uf player, mo inv) {
        int i = 0;
        while (i < inv.j_()) {
            ye stack = inv.a_(i);
            if (stack != null) {
                player.b(stack);
            }
            ++i;
        }
    }

    public static int actualDamage(ye stack) {
        return yc.p.getDamage(stack);
    }
}

