/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import net.minecraft.launchwrapper.IClassTransformer;
import openmods.OpenModsCorePlugin;
import openmods.asm.VisitorHelper;
import openmods.include.IncludingClassVisitor;
import openmods.movement.MovementPatcher;
import org.objectweb.asm.ClassVisitor;

public class OpenModsClassTransformer
implements IClassTransformer {
    private static boolean applyMovementTransformer = System.getProperty("openmods.legacy_movement") == null;
    private static final VisitorHelper.TransformProvider INCLUDING_CV = new VisitorHelper.TransformProvider(){

        @Override
        public ClassVisitor createVisitor(ClassVisitor cv) {
            return new IncludingClassVisitor(cv);
        }
    };

    public byte[] transform(final String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        if (applyMovementTransformer && transformedName.equals("net.minecraft.client.entity.EntityPlayerSP")) {
            return VisitorHelper.apply(bytes, 2, new VisitorHelper.TransformProvider(){

                @Override
                public ClassVisitor createVisitor(ClassVisitor cv) {
                    OpenModsCorePlugin.log.info(String.format("Trying to apply movement callback (class: %s)", name));
                    return new MovementPatcher(name, cv);
                }
            });
        }
        if (name.startsWith("net.minecraft.")) {
            return bytes;
        }
        return VisitorHelper.apply(bytes, 0, INCLUDING_CV);
    }
}

