/*
 * Decompiled with CFR 0.152.
 */
package openmods.container;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.InventoryUtils;

public abstract class ContainerBase<T>
extends Container {
    protected final int inventorySize;
    protected final IInventory playerInventory;
    protected final T owner;
    protected final IInventory inventory;

    public ContainerBase(IInventory playerInventory, IInventory ownerInventory, T owner) {
        this.owner = owner;
        this.inventory = ownerInventory;
        this.inventorySize = this.inventory.func_70302_i_();
        this.playerInventory = playerInventory;
    }

    protected void addInventoryGrid(int xOffset, int yOffset, int width) {
        int height = (int)Math.ceil((double)this.inventorySize / (double)width);
        int slotId = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                this.func_75146_a(new RestrictedSlot(this.inventory, slotId, xOffset + x * 18, yOffset + y * 18));
                ++x;
                ++slotId;
            }
        }
    }

    protected void addInventoryLine(int xOffset, int yOffset, int start, int count) {
        this.addInventoryLine(xOffset, yOffset, start, count, 0);
    }

    protected void addInventoryLine(int xOffset, int yOffset, int start, int count, int margin) {
        int x = 0;
        int slotId = start;
        while (x < count) {
            this.func_75146_a(new RestrictedSlot(this.inventory, slotId, xOffset + x * (18 + margin), yOffset));
            ++x;
            ++slotId;
        }
    }

    protected void addPlayerInventorySlots(int offsetY) {
        this.addPlayerInventorySlots(8, offsetY);
    }

    protected void addPlayerInventorySlots(int offsetX, int offsetY) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot(this.playerInventory, column + row * 9 + 9, offsetX + column * 18, offsetY + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.func_75146_a(new Slot(this.playerInventory, slot, offsetX + slot * 18, offsetY + 58));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public T getOwner() {
        return this.owner;
    }

    protected boolean mergeItemStackSafe(ItemStack stackToMerge, int start, int stop, boolean reverse) {
        ItemStack stackInSlot;
        Slot slot;
        int slotId;
        boolean inventoryChanged = false;
        int delta = reverse ? -1 : 1;
        List<Slot> slots = this.getSlots();
        if (stackToMerge.func_77985_e()) {
            int n = slotId = reverse ? stop - 1 : start;
            while (stackToMerge.field_77994_a > 0 && (!reverse && slotId < stop || reverse && slotId >= start)) {
                slot = slots.get(slotId);
                stackInSlot = slot.func_75211_c();
                if (InventoryUtils.tryMergeStacks(stackToMerge, stackInSlot)) {
                    slot.func_75218_e();
                    inventoryChanged = true;
                }
                slotId += delta;
            }
        }
        if (stackToMerge.field_77994_a > 0) {
            int n = slotId = reverse ? stop - 1 : start;
            while (!reverse && slotId < stop || reverse && slotId >= start) {
                slot = slots.get(slotId);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null && slot.func_75214_a(stackToMerge)) {
                    slot.func_75215_d(stackToMerge.func_77946_l());
                    slot.func_75218_e();
                    stackToMerge.field_77994_a = 0;
                    return true;
                }
                slotId += delta;
            }
        }
        return inventoryChanged;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemToTransfer = slot.func_75211_c();
            ItemStack copy = itemToTransfer.func_77946_l();
            if (slotId < this.inventorySize ? !this.mergeItemStackSafe(itemToTransfer, this.inventorySize, this.field_75151_b.size(), true) : !this.mergeItemStackSafe(itemToTransfer, 0, this.inventorySize, false)) {
                return null;
            }
            if (itemToTransfer.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemToTransfer.field_77994_a != copy.field_77994_a) {
                return copy;
            }
        }
        return null;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    protected List<Slot> getSlots() {
        return this.field_75151_b;
    }

    public Set<EntityPlayer> getPlayers() {
        HashSet<EntityPlayer> players = new HashSet<EntityPlayer>();
        for (ICrafting crafter : this.field_75149_d) {
            if (!(crafter instanceof EntityPlayerMP)) continue;
            players.add((EntityPlayer)((EntityPlayerMP)crafter));
        }
        return players;
    }

    public void func_75142_b() {
        super.func_75142_b();
        T te = this.getOwner();
        if (te instanceof SyncedTileEntity) {
            ((SyncedTileEntity)te).sync();
        }
    }

    public void onButtonClicked(EntityPlayer player, int buttonId) {
    }

    public boolean func_75140_a(EntityPlayer player, int buttonId) {
        this.onButtonClicked(player, buttonId);
        return false;
    }

    protected static class RestrictedSlot
    extends Slot {
        private final int inventoryIndex;

        public RestrictedSlot(IInventory inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
            this.inventoryIndex = slot;
        }

        public boolean func_75214_a(ItemStack itemstack) {
            return this.field_75224_c.func_94041_b(this.inventoryIndex, itemstack);
        }
    }
}

