/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import openmods.gui.component.BaseComponent;
import openmods.gui.misc.SidePicker;
import openmods.gui.misc.Trackball;
import openmods.sync.SyncableFlags;
import openmods.utils.MathUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiComponentSideSelector
extends BaseComponent {
    RenderBlocks blockRender = new RenderBlocks();
    private Trackball.TrackballWrapper trackball = new Trackball.TrackballWrapper(1, 40);
    public double scale;
    private ForgeDirection lastSideHovered;
    private int movedTicks = 0;
    public SyncableFlags enabledDirections;
    private Block block;
    private boolean isInitialized;
    private int meta = 0;
    private TileEntity te;
    private boolean highlightSelectedSides = false;

    public GuiComponentSideSelector(int x, int y, double scale, TileEntity te, int meta, Block block, SyncableFlags directions, boolean highlightSelectedSides) {
        super(x, y);
        this.scale = scale;
        this.enabledDirections = directions;
        this.block = block;
        this.meta = meta;
        this.te = te;
        this.highlightSelectedSides = highlightSelectedSides;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (!this.isInitialized || Mouse.isButtonDown((int)2)) {
            this.trackball.setTransform(MathUtils.createEntityRotateMatrix((Entity)minecraft.field_71451_h));
            this.isInitialized = true;
        }
        GL11.glPushMatrix();
        Tessellator t = Tessellator.field_78398_a;
        GL11.glTranslated((double)((double)(offsetX + this.x) + this.scale / 2.0), (double)((double)(offsetY + this.y) + this.scale / 2.0), (double)this.scale);
        GL11.glScaled((double)this.scale, (double)(-this.scale), (double)this.scale);
        this.trackball.update(mouseX - this.getWidth(), -(mouseY - this.getHeight()));
        if (this.te != null) {
            TileEntityRenderer.field_76963_a.func_76949_a(this.te, -0.5, -0.5, -0.5, 0.0f);
        } else {
            this.drawBlock(minecraft.field_71446_o, t);
        }
        SidePicker picker = new SidePicker(0.5);
        SidePicker.HitCoord coord = picker.getNearestHit();
        if (coord != null) {
            GuiComponentSideSelector.drawHighlight(t, coord.side, 0x444444);
        }
        if (this.highlightSelectedSides) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.enabledDirections.get(dir.ordinal())) continue;
                GuiComponentSideSelector.drawHighlight(t, SidePicker.Side.fromForgeDirection(dir), 0xCC0000);
            }
        }
        this.lastSideHovered = coord == null ? ForgeDirection.UNKNOWN : coord.side.toForgeDirection();
        GL11.glPopMatrix();
    }

    private static void drawHighlight(Tessellator t, SidePicker.Side side, int color) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        t.func_78382_b();
        t.func_78384_a(color, 64);
        switch (side) {
            case XPos: {
                t.func_78377_a(0.5, -0.5, -0.5);
                t.func_78377_a(0.5, 0.5, -0.5);
                t.func_78377_a(0.5, 0.5, 0.5);
                t.func_78377_a(0.5, -0.5, 0.5);
                break;
            }
            case YPos: {
                t.func_78377_a(-0.5, 0.5, -0.5);
                t.func_78377_a(-0.5, 0.5, 0.5);
                t.func_78377_a(0.5, 0.5, 0.5);
                t.func_78377_a(0.5, 0.5, -0.5);
                break;
            }
            case ZPos: {
                t.func_78377_a(-0.5, -0.5, 0.5);
                t.func_78377_a(0.5, -0.5, 0.5);
                t.func_78377_a(0.5, 0.5, 0.5);
                t.func_78377_a(-0.5, 0.5, 0.5);
                break;
            }
            case XNeg: {
                t.func_78377_a(-0.5, -0.5, -0.5);
                t.func_78377_a(-0.5, -0.5, 0.5);
                t.func_78377_a(-0.5, 0.5, 0.5);
                t.func_78377_a(-0.5, 0.5, -0.5);
                break;
            }
            case YNeg: {
                t.func_78377_a(-0.5, -0.5, -0.5);
                t.func_78377_a(0.5, -0.5, -0.5);
                t.func_78377_a(0.5, -0.5, 0.5);
                t.func_78377_a(-0.5, -0.5, 0.5);
                break;
            }
            case ZNeg: {
                t.func_78377_a(-0.5, -0.5, -0.5);
                t.func_78377_a(-0.5, 0.5, -0.5);
                t.func_78377_a(0.5, 0.5, -0.5);
                t.func_78377_a(0.5, -0.5, -0.5);
                break;
            }
        }
        t.func_78381_a();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void drawBlock(TextureManager manager, Tessellator t) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        manager.func_110577_a(TextureMap.field_110575_b);
        this.blockRender.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        t.func_78382_b();
        this.blockRender.func_78573_e(Block.field_71981_t, -0.5, -0.5, -0.5, this.block.func_71858_a(4, this.meta));
        this.blockRender.func_78605_f(Block.field_71981_t, -0.5, -0.5, -0.5, this.block.func_71858_a(5, this.meta));
        this.blockRender.func_78617_b(Block.field_71981_t, -0.5, -0.5, -0.5, this.block.func_71858_a(1, this.meta));
        this.blockRender.func_78613_a(Block.field_71981_t, -0.5, -0.5, -0.5, this.block.func_71858_a(0, this.meta));
        this.blockRender.func_78611_c(Block.field_71981_t, -0.5, -0.5, -0.5, this.block.func_71858_a(2, this.meta));
        this.blockRender.func_78622_d(Block.field_71981_t, -0.5, -0.5, -0.5, this.block.func_71858_a(3, this.meta));
        t.func_78381_a();
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int button, long time) {
        super.mouseClickMove(mouseX, mouseY, button, time);
        ++this.movedTicks;
    }

    @Override
    public void mouseMovedOrUp(int mouseX, int mouseY, int button) {
        super.mouseMovedOrUp(mouseX, mouseY, button);
        if (button == 0 && this.movedTicks < 5 && this.lastSideHovered != null && this.lastSideHovered != ForgeDirection.UNKNOWN) {
            this.enabledDirections.toggle(this.lastSideHovered.ordinal());
            this.movedTicks = 5;
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        this.movedTicks = 0;
        this.lastSideHovered = null;
    }

    @Override
    public int getWidth() {
        return 50;
    }

    @Override
    public int getHeight() {
        return 50;
    }
}

