/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentCraftingGrid;
import openmods.gui.component.GuiComponentItemStackSpinner;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.GuiComponentYouTube;
import openmods.utils.render.FakeIcon;

public class GuiComponentStandardRecipePage
extends BaseComponent {
    private static final ResourceLocation texture = new ResourceLocation("openmodslib:textures/gui/book.png");
    public static Icon iconCraftingGrid = FakeIcon.createSheetIcon(0, 180, 56, 56);
    public static Icon iconArrow = FakeIcon.createSheetIcon(60, 198, 48, 15);
    private GuiComponentCraftingGrid craftingGrid;
    private GuiComponentSprite arrow;
    private GuiComponentLabel lblDescription;
    private GuiComponentLabel lblTitle;
    private GuiComponentItemStackSpinner outputSpinner;

    public GuiComponentStandardRecipePage(String title, String description, String videoLink, ItemStack resultingItem) {
        super(0, 0);
        String translatedTitle = StatCollector.func_74838_a((String)title);
        String translatedDescription = StatCollector.func_74838_a((String)description).replaceAll("\\\\n", "\n");
        String translatedLink = StatCollector.func_74838_a((String)videoLink);
        if (videoLink != "" && !videoLink.equals(translatedLink)) {
            this.addComponent(new GuiComponentYouTube(25, 146, translatedLink));
        }
        this.lblTitle = new GuiComponentLabel((this.getWidth() - Minecraft.func_71410_x().field_71466_p.func_78256_a(translatedTitle)) / 2, 12, translatedTitle);
        this.lblDescription = new GuiComponentLabel(27, 95, 340, 51, translatedDescription);
        this.arrow = new GuiComponentSprite(90, 50, iconArrow, texture);
        this.craftingGrid = new GuiComponentCraftingGrid(25, 30, GuiComponentStandardRecipePage.getFirstRecipeForItem(resultingItem), iconCraftingGrid, texture);
        this.lblDescription.setScale(0.5f);
        this.lblDescription.setAdditionalLineHeight(4);
        this.outputSpinner = new GuiComponentItemStackSpinner(150, 40, resultingItem);
        this.addComponent(this.lblDescription);
        this.addComponent(this.lblTitle);
        this.addComponent(this.arrow);
        this.addComponent(this.outputSpinner);
        this.addComponent(this.craftingGrid);
    }

    private static ItemStack[] getFirstRecipeForItem(ItemStack resultingItem) {
        ItemStack[] recipeItems = new ItemStack[9];
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            Object[] input;
            ItemStack result;
            if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(resultingItem) || (input = GuiComponentStandardRecipePage.getRecipeInput(recipe)) == null) continue;
            for (int i = 0; i < input.length; ++i) {
                recipeItems[i] = GuiComponentStandardRecipePage.convertToStack(input[i]);
            }
        }
        return recipeItems;
    }

    protected static ItemStack convertToStack(Object obj) {
        List list;
        ItemStack entry = null;
        if (obj instanceof ItemStack) {
            entry = (ItemStack)obj;
        } else if (obj instanceof List && (list = (List)obj).size() > 0) {
            entry = (ItemStack)list.get(0);
        }
        if (entry == null) {
            return null;
        }
        if ((entry = entry.func_77946_l()).func_77960_j() == Short.MAX_VALUE) {
            entry.func_77964_b(0);
        }
        return entry;
    }

    private static Object[] getRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)recipe).getInput().toArray();
        }
        if (recipe instanceof ShapedOreRecipe) {
            return GuiComponentStandardRecipePage.getShapedOreRecipe((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77574_d;
        }
        if (recipe instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)recipe).field_77579_b.toArray(new ItemStack[0]);
        }
        return null;
    }

    private static Object[] getShapedOreRecipe(ShapedOreRecipe recipe) {
        try {
            Field field = ShapedOreRecipe.class.getDeclaredField("width");
            if (field != null) {
                field.setAccessible(true);
                int width = field.getInt(recipe);
                Object[] input = recipe.getInput();
                Object[] grid = new Object[9];
                int i = 0;
                int offset = 0;
                for (int y = 0; y < 3; ++y) {
                    int x = 0;
                    while (x < 3) {
                        if (x < width && offset < input.length) {
                            grid[i] = input[offset];
                            ++offset;
                        } else {
                            grid[i] = null;
                        }
                        ++x;
                        ++i;
                    }
                }
                return grid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int getWidth() {
        return 220;
    }

    @Override
    public int getHeight() {
        return 200;
    }
}

