/*
 * Decompiled with CFR 0.152.
 */
package openmods.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.block.OpenBlock;
import openmods.network.events.TileEntityMessageEventPacket;

public abstract class OpenTileEntity
extends TileEntity {
    private boolean initialized = false;
    private boolean isActive = false;
    private boolean isUsedForClientInventoryRendering = false;

    public void setup() {
    }

    public ForgeDirection getRotation() {
        if (this.isUsedForClientInventoryRendering) {
            return this.getBlock().getInventoryRenderRotation();
        }
        return ForgeDirection.getOrientation((int)this.getMetadata());
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        if (this.field_70331_k != null) {
            System.out.println("SEVERE PROGRAMMER ERROR! Inventory Render on World TileEntity. Expect hell!");
        }
        this.isUsedForClientInventoryRendering = true;
        this.field_70324_q = block;
        this.field_70325_p = metadata;
    }

    public void func_70316_g() {
        this.isActive = true;
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    protected void initialize() {
    }

    public boolean isLoaded() {
        return this.initialized;
    }

    public boolean isAddedToWorld() {
        return this.field_70331_k != null;
    }

    protected boolean isActive() {
        return this.isActive;
    }

    public void onChunkUnload() {
        this.isActive = false;
    }

    public TileEntity getTileInDirection(ForgeDirection direction) {
        int x = this.field_70329_l + direction.offsetX;
        int y = this.field_70330_m + direction.offsetY;
        int z = this.field_70327_n + direction.offsetZ;
        if (this.field_70331_k != null && this.field_70331_k.func_72899_e(x, y, z)) {
            return this.field_70331_k.func_72796_p(x, y, z);
        }
        return null;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isAirBlock(ForgeDirection direction) {
        return this.field_70331_k != null && this.field_70331_k.func_72799_c(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ);
    }

    public void sendBlockEvent(int key, int value) {
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n), key, value);
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldID != newID;
    }

    public OpenBlock getBlock() {
        if (this.field_70324_q instanceof OpenBlock) {
            return (OpenBlock)this.field_70324_q;
        }
        return OpenBlock.getOpenBlock((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int getMetadata() {
        if (this.field_70325_p > -1) {
            return this.field_70325_p;
        }
        this.field_70325_p = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return this.field_70325_p;
    }

    public void openGui(Object instance, EntityPlayer player) {
        player.openGui(instance, -1, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public AxisAlignedBB getBB() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }

    public boolean isRenderedInInventory() {
        return this.isUsedForClientInventoryRendering;
    }

    public void onEvent(TileEntityMessageEventPacket event) {
    }
}

