/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import openmods.utils.BlockUtils;

public class Coord {
    public int x;
    public int y;
    public int z;

    public Coord() {
    }

    public Coord(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
    }

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void offset(ForgeDirection direction) {
        this.x += direction.offsetX;
        this.y += direction.offsetY;
        this.z += direction.offsetZ;
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int hashCode() {
        return this.x + 128 << 16 | this.y + 128 << 8 | this.z + 128;
    }

    public boolean equals(Object that) {
        if (!(that instanceof Coord)) {
            return false;
        }
        Coord otherCoord = (Coord)that;
        return otherCoord.x == this.x && otherCoord.y == this.y && otherCoord.z == this.z;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.x, this.y, this.z);
    }

    public void offset(int ox, int oy, int oz) {
        this.x += ox;
        this.y += oy;
        this.z += oz;
    }

    public void setFrom(Coord copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Coord clone() {
        return new Coord(this.x, this.y, this.z);
    }

    public Coord add(Coord pos) {
        return new Coord(this.x + pos.x, this.y + pos.y, this.z + pos.z);
    }

    public Coord add(int[] ai) {
        return new Coord(this.x + ai[0], this.y + ai[1], this.z + ai[2]);
    }

    public Coord substract(Coord pos) {
        return new Coord(this.x - pos.x, this.y - pos.y, this.z - pos.z);
    }

    public Coord substract(int[] ai) {
        return new Coord(this.x - ai[0], this.y - ai[1], this.z - ai[2]);
    }

    public Coord getAdjacentCoord(ForgeDirection fd) {
        return this.getOffsetCoord(fd, 1);
    }

    public Coord getOffsetCoord(ForgeDirection fd, int distance) {
        return new Coord(this.x + fd.offsetX * distance, this.y + fd.offsetY * distance, this.z + fd.offsetZ * distance);
    }

    public Coord[] getDirectlyAdjacentCoords() {
        return this.getDirectlyAdjacentCoords(true);
    }

    public Coord[] getDirectlyAdjacentCoords(boolean includeBelow) {
        Coord[] adjacents = includeBelow ? new Coord[6] : new Coord[]{this.getAdjacentCoord(ForgeDirection.UP), this.getAdjacentCoord(ForgeDirection.NORTH), this.getAdjacentCoord(ForgeDirection.EAST), this.getAdjacentCoord(ForgeDirection.SOUTH), this.getAdjacentCoord(ForgeDirection.WEST)};
        if (includeBelow) {
            adjacents[5] = this.getAdjacentCoord(ForgeDirection.DOWN);
        }
        return adjacents;
    }

    public Coord[] getAdjacentCoords() {
        return this.getAdjacentCoords(true, true);
    }

    public Coord[] getAdjacentCoords(boolean includeBelow, boolean includeDiagonal) {
        if (!includeDiagonal) {
            return this.getDirectlyAdjacentCoords(includeBelow);
        }
        Coord[] adjacents = new Coord[includeBelow ? 26 : 17];
        int index = 0;
        for (int xl = -1; xl < 1; ++xl) {
            for (int zl = -1; zl < 1; ++zl) {
                int yl;
                int n = yl = includeBelow ? -1 : 0;
                while (yl < 1) {
                    if (xl != 0 || zl != 0 || yl != 0) {
                        adjacents[index++] = new Coord(this.x + xl, this.y + yl, this.z + zl);
                    }
                    ++yl;
                }
            }
        }
        return adjacents;
    }

    public boolean isAbove(Coord pos) {
        return pos != null ? this.y > pos.y : false;
    }

    public boolean isBelow(Coord pos) {
        return pos != null ? this.y < pos.y : false;
    }

    public boolean isNorthOf(Coord pos) {
        return pos != null ? this.z < pos.z : false;
    }

    public boolean isSouthOf(Coord pos) {
        return pos != null ? this.z > pos.z : false;
    }

    public boolean isEastOf(Coord pos) {
        return pos != null ? this.x > pos.x : false;
    }

    public boolean isWestOf(Coord pos) {
        return pos != null ? this.x < pos.x : false;
    }

    public boolean isXAligned(Coord pos) {
        return pos != null ? this.x == pos.x : false;
    }

    public boolean isYAligned(Coord pos) {
        return pos != null ? this.y == pos.y : false;
    }

    public boolean isZAligned(Coord pos) {
        return pos != null ? this.z == pos.z : false;
    }

    public boolean isAirBlock(World world) {
        return world.func_72799_c(this.x, this.y, this.z);
    }

    public boolean isBlockNormalCube(World world) {
        return world.func_72809_s(this.x, this.y, this.z);
    }

    public boolean isBlockOpaqueCube(World world) {
        return world.func_72804_r(this.x, this.y, this.z);
    }

    public boolean isWood(World world) {
        Block block = Block.field_71973_m[this.getBlockID(world)];
        return block != null && block.isWood(world, this.x, this.y, this.z);
    }

    public boolean isLeaves(World world) {
        Block block = Block.field_71973_m[this.getBlockID(world)];
        return block != null && block.isLeaves(world, this.x, this.y, this.z);
    }

    public int getBlockID(World world) {
        return world.func_72798_a(this.x, this.y, this.z);
    }

    public int getBlockMetadata(World world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public BiomeGenBase getBiomeGenBase(World world) {
        return world.func_72807_a(this.x, this.z);
    }

    public boolean moveBlockToHereFrom(World world, Coord src, boolean allowBlockReplacement) {
        return BlockUtils.moveBlock(world, src, this, allowBlockReplacement);
    }

    public boolean moveBlockFromHereTo(World world, Coord tgt, boolean allowBlockReplacement) {
        return BlockUtils.moveBlock(world, this, tgt, allowBlockReplacement);
    }
}

