/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.GenericInventory;
import openmods.integration.Integration;
import openmods.sync.SyncableFlags;
import openmods.utils.BlockUtils;

public class InventoryUtils {
    public static void tryInsertStack(IInventory targetInventory, int slot, ItemStack stack, boolean canMerge) {
        if (targetInventory.func_94041_b(slot, stack)) {
            ItemStack targetStack = targetInventory.func_70301_a(slot);
            if (targetStack == null) {
                targetInventory.func_70299_a(slot, stack.func_77946_l());
                stack.field_77994_a = 0;
            } else if (canMerge && targetInventory.func_94041_b(slot, stack) && InventoryUtils.areMergeCandidates(stack, targetStack)) {
                int space = targetStack.func_77976_d() - targetStack.field_77994_a;
                int mergeAmount = Math.min(space, stack.field_77994_a);
                ItemStack copy = targetStack.func_77946_l();
                copy.field_77994_a += mergeAmount;
                targetInventory.func_70299_a(slot, copy);
                stack.field_77994_a -= mergeAmount;
            }
        }
    }

    protected static boolean areMergeCandidates(ItemStack source, ItemStack target) {
        return source.func_77969_a(target) && ItemStack.func_77970_a((ItemStack)source, (ItemStack)target) && target.field_77994_a < target.func_77976_d();
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack) {
        InventoryUtils.insertItemIntoInventory(inventory, stack, ForgeDirection.UNKNOWN, -1);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot) {
        InventoryUtils.insertItemIntoInventory(inventory, stack, side, intoSlot, true);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot, boolean doMove) {
        InventoryUtils.insertItemIntoInventory(inventory, stack, side, intoSlot, doMove, true);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot, boolean doMove, boolean canStack) {
        if (stack == null) {
            return;
        }
        IInventory targetInventory = inventory;
        if (!doMove) {
            targetInventory = new GenericInventory("temporary.inventory", false, targetInventory.func_70302_i_());
            ((GenericInventory)targetInventory).copyFrom(inventory);
        }
        int i = 0;
        int[] attemptSlots = new int[]{};
        if (inventory instanceof ISidedInventory && side != ForgeDirection.UNKNOWN) {
            attemptSlots = ((ISidedInventory)inventory).func_94128_d(side.ordinal());
            if (attemptSlots == null) {
                attemptSlots = new int[]{};
            }
        } else {
            attemptSlots = new int[inventory.func_70302_i_()];
            for (int a = 0; a < inventory.func_70302_i_(); ++a) {
                attemptSlots[a] = a;
            }
        }
        if (intoSlot > -1) {
            HashSet<Integer> x = new HashSet<Integer>();
            for (int attemptedSlot : attemptSlots) {
                x.add(attemptedSlot);
            }
            attemptSlots = x.contains(intoSlot) ? new int[]{intoSlot} : new int[]{};
        }
        while (stack.field_77994_a > 0 && i < attemptSlots.length) {
            if (side != ForgeDirection.UNKNOWN && inventory instanceof ISidedInventory && !((ISidedInventory)inventory).func_102007_a(intoSlot, stack, side.ordinal())) {
                ++i;
                continue;
            }
            InventoryUtils.tryInsertStack(targetInventory, attemptSlots[i], stack, canStack);
            ++i;
        }
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, Object target, int intoSlot, int maxAmount, ForgeDirection direction, boolean doMove) {
        return InventoryUtils.moveItemInto(fromInventory, fromSlot, target, intoSlot, maxAmount, direction, doMove, true);
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, Object target, int intoSlot, int maxAmount, ForgeDirection direction, boolean doMove, boolean canStack) {
        ItemStack sourceStack = (fromInventory = InventoryUtils.getInventory(fromInventory)).func_70301_a(fromSlot);
        if (sourceStack == null) {
            return 0;
        }
        if (fromInventory instanceof ISidedInventory && !((ISidedInventory)fromInventory).func_102008_b(fromSlot, sourceStack, direction.ordinal())) {
            return 0;
        }
        ItemStack clonedSourceStack = sourceStack.func_77946_l();
        int amountToMove = clonedSourceStack.field_77994_a = Math.min(clonedSourceStack.field_77994_a, maxAmount);
        int inserted = 0;
        if (target instanceof TileEntity && Integration.modBuildCraft().isPipe((TileEntity)target)) {
            inserted = Integration.modBuildCraft().tryAcceptIntoPipe((TileEntity)target, clonedSourceStack, doMove, direction);
            clonedSourceStack.field_77994_a -= inserted;
        } else if (target instanceof IInventory) {
            IInventory targetInventory = InventoryUtils.getInventory((IInventory)target);
            ForgeDirection side = direction.getOpposite();
            InventoryUtils.insertItemIntoInventory(targetInventory, clonedSourceStack, side, intoSlot, doMove, canStack);
            inserted = amountToMove - clonedSourceStack.field_77994_a;
        }
        if (doMove) {
            ItemStack newSourcestack = sourceStack.func_77946_l();
            newSourcestack.field_77994_a -= inserted;
            if (newSourcestack.field_77994_a == 0) {
                fromInventory.func_70299_a(fromSlot, null);
            } else {
                fromInventory.func_70299_a(fromSlot, newSourcestack);
            }
        }
        return inserted;
    }

    public static IInventory getInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileEntityChest) {
            int chestId = world.func_72798_a(x, y, z);
            if (world.func_72798_a(x - 1, y, z) == chestId) {
                return new InventoryLargeChest("Large chest", (IInventory)world.func_72796_p(x - 1, y, z), (IInventory)tileEntity);
            }
            if (world.func_72798_a(x + 1, y, z) == chestId) {
                return new InventoryLargeChest("Large chest", (IInventory)tileEntity, (IInventory)world.func_72796_p(x + 1, y, z));
            }
            if (world.func_72798_a(x, y, z - 1) == chestId) {
                return new InventoryLargeChest("Large chest", (IInventory)world.func_72796_p(x, y, z - 1), (IInventory)tileEntity);
            }
            if (world.func_72798_a(x, y, z + 1) == chestId) {
                return new InventoryLargeChest("Large chest", (IInventory)tileEntity, (IInventory)world.func_72796_p(x, y, z + 1));
            }
        }
        return tileEntity instanceof IInventory ? (IInventory)tileEntity : null;
    }

    public static IInventory getInventory(World world, int x, int y, int z, ForgeDirection direction) {
        if (direction != null && direction != ForgeDirection.UNKNOWN) {
            x += direction.offsetX;
            y += direction.offsetY;
            z += direction.offsetZ;
        }
        return InventoryUtils.getInventory(world, x, y, z);
    }

    public static IInventory getInventory(IInventory inventory) {
        if (inventory instanceof TileEntityChest) {
            TileEntity te = (TileEntity)inventory;
            return InventoryUtils.getInventory(te.field_70331_k, te.field_70329_l, te.field_70330_m, te.field_70327_n);
        }
        return inventory;
    }

    public static List<ItemStack> getInventoryContents(IInventory inventory) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            result.add(slot);
        }
        return result;
    }

    public static Set<Integer> getSlotsWithStack(IInventory inventory, ItemStack stack) {
        inventory = InventoryUtils.getInventory(inventory);
        HashSet<Integer> slots = new HashSet<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static int getFirstSlotWithStack(IInventory inventory, ItemStack stack) {
        inventory = InventoryUtils.getInventory(inventory);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean consumeInventoryItem(IInventory inventory, ItemStack stack) {
        int slotWithStack = InventoryUtils.getFirstSlotWithStack(inventory, stack);
        if (slotWithStack > -1) {
            ItemStack stackInSlot = inventory.func_70301_a(slotWithStack);
            --stackInSlot.field_77994_a;
            if (stackInSlot.field_77994_a == 0) {
                inventory.func_70299_a(slotWithStack, null);
            }
            return true;
        }
        return false;
    }

    public static int getSlotIndexOfNextStack(IInventory invent) {
        for (int i = 0; i < invent.func_70302_i_(); ++i) {
            ItemStack stack = invent.func_70301_a(i);
            if (stack == null) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack removeNextItemStack(IInventory invent) {
        int nextFilledSlot = InventoryUtils.getSlotIndexOfNextStack(invent);
        if (nextFilledSlot > -1) {
            ItemStack copy = invent.func_70301_a(nextFilledSlot).func_77946_l();
            invent.func_70299_a(nextFilledSlot, null);
            return copy;
        }
        return null;
    }

    public static int moveItemsFromOneOfSides(TileEntity currentTile, int maxAmount, int intoSlot, SyncableFlags sideFlags) {
        return InventoryUtils.moveItemsFromOneOfSides(currentTile, null, maxAmount, intoSlot, sideFlags);
    }

    public static int moveItemsFromOneOfSides(TileEntity intoInventory, ItemStack stack, int maxAmount, Enum<?> intoSlot, SyncableFlags sideFlags) {
        return InventoryUtils.moveItemsFromOneOfSides(intoInventory, stack, maxAmount, intoSlot.ordinal(), sideFlags);
    }

    public static int moveItemsFromOneOfSides(TileEntity intoInventory, ItemStack stack, int maxAmount, int intoSlot, SyncableFlags sideFlags) {
        ArrayList<Integer> sides = new ArrayList<Integer>();
        sides.addAll(sideFlags.getActiveSlots());
        Collections.shuffle(sides);
        if (!(intoInventory instanceof IInventory)) {
            return 0;
        }
        for (Integer dir : sides) {
            ForgeDirection directionToExtractItem = ForgeDirection.getOrientation((int)dir);
            TileEntity tileOnSurface = BlockUtils.getTileInDirection(intoInventory, directionToExtractItem);
            if (!(tileOnSurface instanceof IInventory)) continue;
            Set<Integer> slots = null;
            slots = stack == null ? InventoryUtils.getAllSlots((IInventory)tileOnSurface) : InventoryUtils.getSlotsWithStack((IInventory)tileOnSurface, stack);
            for (Integer slot : slots) {
                int moved = InventoryUtils.moveItemInto((IInventory)tileOnSurface, slot, InventoryUtils.getInventory((IInventory)intoInventory), intoSlot, maxAmount, directionToExtractItem.getOpposite(), true);
                if (moved <= 0) continue;
                return moved;
            }
        }
        return 0;
    }

    public static int testInventoryInsertion(IInventory inventory, ItemStack item) {
        if (item == null || item.field_77994_a == 0) {
            return 0;
        }
        if (inventory == null) {
            return 0;
        }
        int slotCount = inventory.func_70302_i_();
        int itemSizeCounter = item.field_77994_a;
        for (int i = 0; i < slotCount && itemSizeCounter > 0; ++i) {
            if (!inventory.func_94041_b(i, item)) continue;
            ItemStack inventorySlot = inventory.func_70301_a(i);
            if (inventorySlot == null) {
                itemSizeCounter -= Math.min(Math.min(itemSizeCounter, inventory.func_70297_j_()), item.func_77976_d());
                continue;
            }
            if (!InventoryUtils.areMergeCandidates(item, inventorySlot)) continue;
            int space = inventorySlot.func_77976_d() - inventorySlot.field_77994_a;
            itemSizeCounter -= Math.min(itemSizeCounter, space);
        }
        if (itemSizeCounter != item.field_77994_a) {
            itemSizeCounter = Math.max(itemSizeCounter, 0);
            return item.field_77994_a - itemSizeCounter;
        }
        return 0;
    }

    public static Set<Integer> getAllSlots(IInventory inventory) {
        inventory = InventoryUtils.getInventory(inventory);
        HashSet<Integer> slots = new HashSet<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            slots.add(i);
        }
        return slots;
    }

    public static int moveItemsToOneOfSides(TileEntity currentTile, Enum<?> fromSlot, int maxAmount, SyncableFlags sideFlags) {
        return InventoryUtils.moveItemsToOneOfSides(currentTile, fromSlot.ordinal(), maxAmount, sideFlags);
    }

    public static int moveItemsToOneOfSides(TileEntity currentTile, int fromSlot, int maxAmount, SyncableFlags sideFlags) {
        if (!(currentTile instanceof IInventory)) {
            return 0;
        }
        IInventory inventory = InventoryUtils.getInventory((IInventory)currentTile);
        if (inventory.func_70301_a(fromSlot) == null) {
            return 0;
        }
        ArrayList<Integer> sides = new ArrayList<Integer>();
        sides.addAll(sideFlags.getActiveSlots());
        Collections.shuffle(sides);
        for (Integer dir : sides) {
            ForgeDirection directionToOutputItem = ForgeDirection.getOrientation((int)dir);
            TileEntity tileOnSurface = currentTile.field_70331_k.func_72796_p(currentTile.field_70329_l + directionToOutputItem.offsetX, currentTile.field_70330_m + directionToOutputItem.offsetY, currentTile.field_70327_n + directionToOutputItem.offsetZ);
            if (tileOnSurface == null) {
                return 0;
            }
            int moved = InventoryUtils.moveItemInto(inventory, fromSlot, tileOnSurface, -1, maxAmount, directionToOutputItem, true);
            if (moved <= 0) continue;
            return moved;
        }
        return 0;
    }

    public static boolean inventoryIsEmpty(IInventory inventory) {
        int l = inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean tryMergeStacks(ItemStack stackToMerge, ItemStack stackInSlot) {
        if (stackInSlot == null || !stackInSlot.func_77969_a(stackToMerge) || !ItemStack.func_77970_a((ItemStack)stackToMerge, (ItemStack)stackInSlot)) {
            return false;
        }
        int newStackSize = stackInSlot.field_77994_a + stackToMerge.field_77994_a;
        int maxStackSize = stackToMerge.func_77976_d();
        if (newStackSize <= maxStackSize) {
            stackToMerge.field_77994_a = 0;
            stackInSlot.field_77994_a = newStackSize;
            return true;
        }
        if (stackInSlot.field_77994_a < maxStackSize) {
            stackToMerge.field_77994_a -= maxStackSize - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = maxStackSize;
            return true;
        }
        return false;
    }

    static ItemStack returnItem(ItemStack stack) {
        return stack == null || stack.field_77994_a <= 0 ? null : stack.func_77946_l();
    }
}

