/*
 * Decompiled with CFR 0.152.
 */
package openblocks.asm;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import openmods.asm.MethodMatcher;
import openmods.asm.VisitorHelper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MapGenStructureVisitor
extends ClassVisitor {
    private final MethodMatcher modifiedMethod;
    private final MethodMatcher markerMethod;
    private String structureStartCls = "net/minecraft/world/gen/structure/StructureStart";

    public MapGenStructureVisitor(String obfClassName, ClassVisitor cv) {
        super(262144, cv);
        String chunkPositionCls = "net/minecraft/world/ChunkPosition";
        String worldCls = "net/minecraft/world/World";
        if (VisitorHelper.useSrgNames()) {
            this.structureStartCls = FMLDeobfuscatingRemapper.INSTANCE.unmap(this.structureStartCls);
            chunkPositionCls = FMLDeobfuscatingRemapper.INSTANCE.unmap(chunkPositionCls);
            worldCls = FMLDeobfuscatingRemapper.INSTANCE.unmap(worldCls);
        }
        String descriptor = Type.getMethodDescriptor((Type)Type.getObjectType((String)chunkPositionCls), (Type[])new Type[]{Type.getObjectType((String)worldCls), Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE});
        this.modifiedMethod = new MethodMatcher(obfClassName, descriptor, "getNearestInstance", "func_75050_a");
        this.markerMethod = new MethodMatcher(this.structureStartCls, "()Z", "isSizeableStructure", "func_75069_d");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.modifiedMethod.match(name, desc) ? new FixerMethodVisitor(parent) : parent;
    }

    private class FixerMethodVisitor
    extends MethodVisitor {
        private boolean checkcastFound;
        private Integer localVarId;
        private boolean markerMethodFound;

        public FixerMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            super.visitTypeInsn(opcode, type);
            if (opcode == 192 && type.equals(MapGenStructureVisitor.this.structureStartCls)) {
                this.checkcastFound = true;
                FMLRelaunchLog.info((String)"[OpenBlocks] MapGenFix: Found checkcast to '%s'", (Object[])new Object[]{type});
            }
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            if (this.checkcastFound && opcode == 58) {
                this.localVarId = var;
                this.checkcastFound = false;
                FMLRelaunchLog.info((String)"[OpenBlocks] MapGenFix: Found var: %d", (Object[])new Object[]{this.localVarId});
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (opcode == 182 && owner.equals(MapGenStructureVisitor.this.structureStartCls) && MapGenStructureVisitor.this.markerMethod.match(name, desc)) {
                this.markerMethodFound = true;
                FMLRelaunchLog.info((String)"[OpenBlocks] MapGenFix: Found 'StructureStart.isSizeableStructure' (%s.%s) call", (Object[])new Object[]{owner, name});
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (this.markerMethodFound && this.localVarId != null && opcode == 153) {
                FMLRelaunchLog.info((String)"[OpenBlocks] MapGenFix: All conditions matched, inserting extra condition", (Object[])new Object[0]);
                super.visitVarInsn(25, this.localVarId.intValue());
                String getComponentsMethodName = VisitorHelper.useSrgNames() ? "func_75073_b" : "getComponents";
                super.visitMethodInsn(182, MapGenStructureVisitor.this.structureStartCls, getComponentsMethodName, "()Ljava/util/LinkedList;");
                super.visitMethodInsn(182, "java/util/LinkedList", "isEmpty", "()Z");
                super.visitJumpInsn(154, label);
                this.markerMethodFound = false;
            }
        }
    }
}

