/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.radio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import openmods.Log;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;

public class CodecMp3
implements ICodec {
    private boolean initalized;
    private boolean streamClosed;
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioFormat audioFormat;
    private SampleBuffer buffer;

    public void reverseByteOrder(boolean b) {
    }

    public boolean initialize(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            this.bitstream = new Bitstream(conn.getInputStream());
            this.decoder = new Decoder();
            this.initalized = true;
            this.updateBuffer();
            this.audioFormat = new AudioFormat(this.decoder.getOutputFrequency(), 16, this.decoder.getOutputChannels(), true, false);
            return true;
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to initalize codec for url '%s'", (Object[])new Object[]{url});
            return false;
        }
    }

    private boolean updateBuffer() throws Exception {
        Header h = this.bitstream.readFrame();
        if (h == null) {
            return false;
        }
        this.buffer = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
        this.bitstream.closeFrame();
        return true;
    }

    public boolean initialized() {
        return this.initalized;
    }

    public SoundBuffer read() {
        if (!this.initalized || this.streamClosed) {
            return null;
        }
        int limit = SoundSystemConfig.getStreamingBufferSize();
        ByteArrayOutputStream output = new ByteArrayOutputStream(limit);
        try {
            do {
                this.readBytes(output);
            } while (this.updateBuffer() && !this.streamClosed && output.size() < limit);
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Error in stream decoding, aborting", (Object[])new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.audioFormat);
    }

    public SoundBuffer readAll() {
        if (!this.initalized || this.streamClosed) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            do {
                this.readBytes(output);
            } while (this.updateBuffer() && !this.streamClosed);
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Error in stream decoding, aborting", (Object[])new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.audioFormat);
    }

    private void readBytes(OutputStream output) throws IOException {
        short[] samples = this.buffer.getBuffer();
        int len = this.buffer.getBufferLength();
        int idx = 0;
        while (len-- > 0) {
            short s = samples[idx++];
            output.write(s);
            output.write(s >>> 8);
        }
    }

    public boolean endOfStream() {
        return this.streamClosed;
    }

    public void cleanup() {
        this.streamClosed = true;
        this.initalized = false;
        this.decoder = null;
        try {
            this.bitstream.close();
        }
        catch (BitstreamException e) {
            Log.warn((Throwable)e, (String)"Failed to close bitstream", (Object[])new Object[0]);
        }
        this.bitstream = null;
        this.buffer = null;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }
}

