/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.radio;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.radio.AutoConnectingStreamHandler;
import openblocks.client.radio.CodecMp3;
import openblocks.common.item.ItemTunedCrystal;
import openmods.Log;
import openmods.config.ConfigurationChange;
import org.apache.commons.lang3.StringUtils;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

public class RadioManager
implements VillagerRegistry.IVillageTradeHandler {
    private static final String OGG_EXT = "ogg";
    private static final String MP3_EXT = "mp3";
    private static final String ERROR_EXT = "!error!";
    private static final String RESOLVING_EXT = "!resolving!";
    private static final String SOUND_ID = "openblocks.radio.";
    private static final Map<String, String> PROTOCOLS = ImmutableMap.builder().put((Object)"audio/mpeg", (Object)"mp3").put((Object)"audio/x-mpeg", (Object)"mp3").put((Object)"audio/mpeg3", (Object)"mp3").put((Object)"audio/x-mpeg3", (Object)"mp3").put((Object)"audio/ogg", (Object)"ogg").put((Object)"application/ogg", (Object)"ogg").put((Object)"audio/vorbis", (Object)"ogg").build();
    private final Map<String, String> streamFormats = Maps.newConcurrentMap();
    private final Set<String> usedSounds = Sets.newHashSet();
    private final Set<String> freeSounds = Sets.newHashSet();
    private int soundCounter;
    public static final RadioManager instance = new RadioManager();
    private List<RadioStation> stations;

    public static RadioException error(String userMsg, String logMsg, Object ... args) {
        Log.warn((String)logMsg, (Object[])args);
        throw new RadioException(userMsg);
    }

    private RadioManager() {
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            SoundSystemConfig.setCodec((String)MP3_EXT, CodecMp3.class);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
        this.getRadioStations();
    }

    @ForgeSubscribe
    public void onReconfiguration(ConfigurationChange.Post evt) {
        if (evt.check("radio", "radioStations")) {
            this.stations = null;
        }
    }

    public List<RadioStation> getRadioStations() {
        if (this.stations == null) {
            ImmutableList.Builder stations = ImmutableList.builder();
            ArrayList urls = Lists.newArrayList();
            for (String stationDesc : Config.radioStations) {
                if (stationDesc.startsWith("\"") && stationDesc.endsWith("\"")) {
                    stationDesc = stationDesc.substring(1, stationDesc.length() - 1);
                }
                stationDesc = StringUtils.strip((String)stationDesc);
                ImmutableList fields = ImmutableList.copyOf((Iterable)Splitter.on((char)';').split((CharSequence)stationDesc));
                Preconditions.checkState((fields.size() > 0 && fields.size() <= 3 ? 1 : 0) != 0, (String)"Invalid radio station descripion: %s", (Object[])new Object[]{stationDesc});
                String url = (String)fields.get(0);
                String name = fields.size() > 1 ? (String)fields.get(1) : "";
                ImmutableList attributes = fields.size() > 2 ? Splitter.on((String)",").split((CharSequence)fields.get(2)) : ImmutableList.of();
                stations.add((Object)new RadioStation(url, name, (Iterable<String>)attributes));
                urls.add(url);
            }
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                instance.preloadStreams(urls);
            }
            this.stations = stations.build();
        }
        return this.stations;
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload evt) {
        if (evt.world.field_72995_K) {
            for (String soundId : ImmutableList.copyOf(this.usedSounds)) {
                this.stopPlaying(soundId);
            }
            AutoConnectingStreamHandler.disconnectAll();
        }
    }

    private synchronized String allocateNewName() {
        String name = null;
        if (this.freeSounds.isEmpty()) {
            if (this.usedSounds.size() < Config.maxRadioSources) {
                name = SOUND_ID + this.soundCounter++;
            }
        } else {
            Iterator<String> it = this.freeSounds.iterator();
            name = it.next();
            it.remove();
        }
        if (name != null) {
            this.usedSounds.add(name);
        }
        return name;
    }

    private synchronized void releaseName(String name) {
        if (this.usedSounds.remove(name)) {
            this.freeSounds.add(name);
        }
    }

    public String startPlaying(String soundId, String url, float x, float y, float z, float volume) {
        if (soundId == null) {
            soundId = this.allocateNewName();
        }
        if (soundId == null) {
            throw RadioManager.error("openblocks.misc.radio.too_many", "No resources to play %s, aborting", url);
        }
        try {
            String ext;
            SoundSystem sndSystem = RadioManager.getSoundSystem();
            Minecraft mc = Minecraft.func_71410_x();
            if (sndSystem == null || mc.field_71474_y.field_74340_b == 0.0f) {
                throw new RadioException("openblocks.misc.radio.muted");
            }
            if (sndSystem.playing(soundId)) {
                sndSystem.stop(soundId);
                sndSystem.removeSource(soundId);
            }
            if (ERROR_EXT.equals(ext = this.resolveStreamExt(url))) {
                throw RadioManager.error("openblocks.misc.radio.invalid_stream", "Invalid data in stream %s (soundId : %s), aborting", url, soundId);
            }
            if (RESOLVING_EXT.equals(ext)) {
                throw RadioManager.error("openblocks.misc.radio.not_ready", "Stream %s (soundId : %s) not yet resolved, aborting", url, soundId);
            }
            try {
                URL realUrl = new URL(null, url, AutoConnectingStreamHandler.createManaged(soundId));
                String dummyFilename = "radio_dummy." + ext;
                sndSystem.newStreamingSource(false, soundId, realUrl, dummyFilename, false, x, y, z, 2, 32.0f);
                sndSystem.setVolume(soundId, volume);
                sndSystem.play(soundId);
            }
            catch (Throwable t) {
                Log.warn((Throwable)t, (String)"Exception during opening url %s (soundId: %s)", (Object[])new Object[]{url, soundId});
                throw new RadioException("openblocks.misc.radio.unknown_error");
            }
            Log.info((String)"Started playing %s (id: %s)", (Object[])new Object[]{url, soundId});
            return soundId;
        }
        catch (RadioException e) {
            this.releaseName(soundId);
            throw e;
        }
    }

    public void stopPlaying(String soundId) {
        SoundSystem sndSystem = RadioManager.getSoundSystem();
        if (sndSystem != null) {
            sndSystem.stop(soundId);
        }
        AutoConnectingStreamHandler.disconnectManaged(soundId);
        this.releaseName(soundId);
    }

    public void setVolume(String soundId, float value) {
        SoundSystem sndSystem = RadioManager.getSoundSystem();
        sndSystem.setVolume(soundId, value);
    }

    private static SoundSystem getSoundSystem() {
        Minecraft mc = Minecraft.func_71410_x();
        SoundManager sndManager = mc.field_71416_A;
        SoundSystem sndSystem = sndManager.field_77381_a;
        return sndSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveStreamType(String url) {
        HttpURLConnection connection;
        this.streamFormats.put(url, RESOLVING_EXT);
        try {
            URL realUrl = new URL(null, url, new AutoConnectingStreamHandler());
            connection = (HttpURLConnection)realUrl.openConnection();
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Exception during opening url %s", (Object[])new Object[]{url});
            this.streamFormats.put(url, ERROR_EXT);
            return;
        }
        try {
            String contentType = connection.getContentType();
            String ext = PROTOCOLS.get(contentType);
            if (ext == null) {
                ext = ERROR_EXT;
                Log.warn((String)"Unknown content type '%s' in url '%s', aborting", (Object[])new Object[]{contentType, url});
            }
            this.streamFormats.put(url, ext);
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Exception during opening url %s", (Object[])new Object[]{url});
        }
        finally {
            connection.disconnect();
        }
    }

    public void preloadStreams(final Collection<String> urls) {
        if (urls.isEmpty()) {
            return;
        }
        Thread th = new Thread(){

            @Override
            public void run() {
                for (String url : urls) {
                    Log.info((String)"Preloading stream: %s", (Object[])new Object[]{url});
                    RadioManager.this.resolveStreamType(url);
                    Log.info((String)"Finished preloading stream: %s", (Object[])new Object[]{url});
                }
            }
        };
        th.setDaemon(true);
        th.start();
    }

    private String resolveStreamExt(final String url) {
        String ext = this.streamFormats.get(url);
        if (ext != null) {
            return ext;
        }
        Thread th = new Thread(){

            @Override
            public void run() {
                RadioManager.this.resolveStreamType(url);
            }
        };
        th.setDaemon(true);
        th.start();
        try {
            th.join(750L);
            return this.streamFormats.get(url);
        }
        catch (InterruptedException e) {
            Log.warn((Throwable)e, (String)"Thread interrupted!", (Object[])new Object[0]);
            this.streamFormats.put(url, ERROR_EXT);
            return ERROR_EXT;
        }
    }

    private static ItemStack randomItemAmount(Random random, Item item, int min, int max) {
        int amount = random.nextInt(max - min) + min;
        return new ItemStack(item, amount);
    }

    private static ItemStack randomEmeralds(Random random, int min, int max) {
        return RadioManager.randomItemAmount(random, Item.field_77817_bH, min, max);
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        if (Config.radioVillagerRecords) {
            for (ItemStack record : OreDictionary.getOres((String)"record")) {
                if (!((double)random.nextFloat() < 0.01)) continue;
                recipeList.func_77205_a(new MerchantRecipe(RadioManager.randomEmeralds(random, 7, 15), record));
            }
        }
        for (RadioStation st : this.getRadioStations()) {
            if (!((double)random.nextFloat() < 0.2)) continue;
            recipeList.func_77205_a(new MerchantRecipe(RadioManager.randomEmeralds(random, 3, 7), RadioManager.randomItemAmount(random, Item.field_77767_aC, 4, 20), st.getStack().func_77946_l()));
        }
        if ((double)random.nextFloat() > 0.5) {
            recipeList.func_77205_a(new MerchantRecipe(RadioManager.randomEmeralds(random, 1, 2), new ItemStack(Block.field_71960_R)));
        }
        if ((double)random.nextFloat() > 0.25 || recipeList.isEmpty()) {
            recipeList.func_77205_a(new MerchantRecipe(RadioManager.randomEmeralds(random, 3, 7), new ItemStack(Block.field_72032_aY)));
        }
    }

    public static class RadioStation {
        public final String url;
        public final String name;
        public final Iterable<String> attributes;
        private ItemStack stack;

        public RadioStation(String url, String name, Iterable<String> attributes) {
            this.url = url;
            this.name = name;
            this.attributes = attributes;
        }

        public ItemStack getStack() {
            ItemTunedCrystal tunedCrystal = OpenBlocks.Items.tunedCrystal;
            if (this.stack == null && tunedCrystal != null) {
                this.stack = tunedCrystal.createStack(this);
            }
            return this.stack;
        }
    }

    public static class RadioException
    extends RuntimeException {
        private static final long serialVersionUID = 1026197667827191392L;

        public RadioException(String message) {
            super(message);
        }
    }
}

