/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityRopeLadder;
import openmods.block.OpenBlock;
import openmods.utils.BlockUtils;

public class BlockRopeLadder
extends OpenBlock {
    public BlockRopeLadder() {
        super(Config.blockRopeLadderId, Material.field_76265_p);
        this.func_71848_c(0.4f);
        this.func_71884_a(field_82507_n);
        this.setRotationMode(OpenBlock.BlockRotationMode.FOUR_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return side != ForgeDirection.UP && side != ForgeDirection.DOWN;
    }

    public boolean isLadder(World world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public boolean shouldRenderBlock() {
        return false;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB bb, List list, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            ForgeDirection playerRotation;
            int meta = world.func_72805_g(x, y, z);
            ForgeDirection rotation = ForgeDirection.getOrientation((int)meta);
            if (rotation == (playerRotation = BlockUtils.get2dOrientation((EntityLivingBase)((EntityLivingBase)entity)))) {
                super.func_71871_a(world, x, y, z, bb, list, entity);
            }
        } else {
            super.func_71871_a(world, x, y, z, bb, list, entity);
        }
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        this.func_71902_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_71872_e(par1World, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_71911_a_(World par1World, int par2, int par3, int par4) {
        this.func_71902_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_71911_a_(par1World, par2, par3, par4);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileEntityRopeLadder tile = (TileEntityRopeLadder)((Object)BlockRopeLadder.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityRopeLadder.class));
        if (tile != null) {
            ForgeDirection direction = tile.getRotation();
            switch (direction) {
                case EAST: {
                    this.func_71905_a(0.9375f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case WEST: {
                    this.func_71905_a(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                    break;
                }
                case NORTH: {
                    this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                    break;
                }
                case SOUTH: {
                    this.func_71905_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                default: {
                    this.func_71905_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }
}

