/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityTank;
import openmods.utils.ItemUtils;

public class BlockTank
extends OpenBlock {
    public BlockTank() {
        super(Config.blockTankId, Material.field_76248_c);
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean shouldRenderBlock() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    protected void getCustomTileEntityDrops(TileEntity te, List<ItemStack> result) {
        ItemStack stack = new ItemStack((Block)OpenBlocks.Blocks.tank);
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank tank = (TileEntityTank)te;
        if (tank.getTank().getFluidAmount() > 10) {
            NBTTagCompound tankTag = tank.getItemNBT();
            NBTTagCompound itemTag = ItemUtils.getItemTag((ItemStack)stack);
            itemTag.func_74766_a("tank", tankTag);
        }
        result.add(stack);
    }

    protected boolean hasNormalDrops() {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (!Config.tanksEmitLight) {
            return 0;
        }
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityTank.class));
        if (tile != null) {
            return tile.getFluidLightLevel();
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack result = new ItemStack((Block)this);
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityTank.class));
        if (tile != null) {
            NBTTagCompound tankTag = tile.getItemNBT();
            if (tankTag.func_74764_b("Amount")) {
                tankTag.func_74768_a("Amount", TileEntityTank.getTankCapacity());
            }
            NBTTagCompound nbt = ItemUtils.getItemTag((ItemStack)result);
            nbt.func_74766_a("tank", tankTag);
        }
        return result;
    }
}

