/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.client.model;

import co.uk.flansmods.client.model.ModelDriveable;
import co.uk.flansmods.client.tmt.ModelRendererTurbo;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntityPlane;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.driveables.Propeller;

public class ModelPlane
extends ModelDriveable {
    public ModelRendererTurbo[] noseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] topWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bayModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[][] propellerModels = new ModelRendererTurbo[0][0];
    public ModelRendererTurbo[] yawFlapModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapLeftModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapRightModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapLeftWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] pitchFlapRightWingModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailDoorOpenModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] tailDoorCloseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingPos1Model = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightWingPos2Model = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingPos1Model = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftWingPos2Model = new ModelRendererTurbo[0];

    @Override
    public void render(EntityDriveable driveable, float f1) {
        this.render(0.0625f, (EntityPlane)driveable, f1);
    }

    @Override
    public void render(DriveableType type) {
        super.render(type);
        this.renderPart(this.noseModel);
        this.renderPart(this.leftWingModel);
        this.renderPart(this.rightWingModel);
        this.renderPart(this.topWingModel);
        this.renderPart(this.bayModel);
        this.renderPart(this.tailModel);
        for (ModelRendererTurbo[] prop : this.propellerModels) {
            for (int j = 0; j < prop.length; ++j) {
                prop[j].f = (float)j * 2.0f * (float)Math.PI / (float)prop.length;
                prop[j].a(0.0625f);
            }
        }
        this.renderPart(this.yawFlapModel);
        this.renderPart(this.pitchFlapLeftModel);
        this.renderPart(this.pitchFlapRightModel);
        this.renderPart(this.pitchFlapLeftWingModel);
        this.renderPart(this.pitchFlapRightWingModel);
        this.renderPart(this.bodyWheelModel);
        this.renderPart(this.tailWheelModel);
        this.renderPart(this.leftWingWheelModel);
        this.renderPart(this.rightWingWheelModel);
        this.renderPart(this.tailDoorCloseModel);
        this.renderPart(this.rightWingPos1Model);
        this.renderPart(this.leftWingPos1Model);
    }

    public void render(float f5, EntityPlane plane, float f) {
        float angle = plane.propAngle;
        for (Propeller propeller : plane.getPlaneType().propellers) {
            if (!plane.isPartIntact(propeller.planePart)) continue;
            int numParts = this.propellerModels[propeller.ID].length;
            for (int j = 0; j < numParts; ++j) {
                this.propellerModels[propeller.ID][j].f = angle + (float)j * 2.0f * (float)Math.PI / (float)numParts;
                this.propellerModels[propeller.ID][j].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.nose)) {
            for (int i = 0; i < this.noseModel.length; ++i) {
                this.noseModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.bay)) {
            for (int i = 0; i < this.bayModel.length; ++i) {
                this.bayModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.tail)) {
            int i;
            for (i = 0; i < this.tailModel.length; ++i) {
                this.tailModel[i].a(f5);
            }
            for (i = 0; i < this.tailDoorOpenModel.length; ++i) {
                if (!plane.varDoor) continue;
                this.tailDoorOpenModel[i].a(f5);
            }
            for (i = 0; i < this.tailDoorCloseModel.length; ++i) {
                if (plane.varDoor) continue;
                this.tailDoorCloseModel[i].a(f5);
            }
            for (i = 0; i < this.yawFlapModel.length; ++i) {
                this.yawFlapModel[i].g = plane.flapsYaw * (float)Math.PI / 180.0f;
                this.yawFlapModel[i].a(f5);
            }
            for (i = 0; i < this.pitchFlapLeftModel.length; ++i) {
                this.pitchFlapLeftModel[i].h = plane.flapsPitchLeft * (float)Math.PI / 180.0f;
                this.pitchFlapLeftModel[i].a(f5);
            }
            for (i = 0; i < this.pitchFlapRightModel.length; ++i) {
                this.pitchFlapRightModel[i].h = plane.flapsPitchRight * (float)Math.PI / 180.0f;
                this.pitchFlapRightModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.tailWheel)) {
            for (int i = 0; i < this.tailWheelModel.length; ++i) {
                if (!plane.varGear) continue;
                this.tailWheelModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.leftWing)) {
            int i;
            for (i = 0; i < this.leftWingModel.length; ++i) {
                this.leftWingModel[i].a(f5);
            }
            for (i = 0; i < this.leftWingPos1Model.length; ++i) {
                if (!plane.varWing) continue;
                this.leftWingPos1Model[i].a(f5);
            }
            for (i = 0; i < this.leftWingPos2Model.length; ++i) {
                if (plane.varWing) continue;
                this.leftWingPos2Model[i].a(f5);
            }
            for (i = 0; i < this.pitchFlapLeftWingModel.length; ++i) {
                this.pitchFlapLeftWingModel[i].h = plane.flapsPitchLeft * (float)Math.PI / 180.0f;
                this.pitchFlapLeftWingModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.rightWing)) {
            int i;
            for (i = 0; i < this.rightWingModel.length; ++i) {
                this.rightWingModel[i].a(f5);
            }
            for (i = 0; i < this.rightWingPos1Model.length; ++i) {
                if (!plane.varWing) continue;
                this.rightWingPos1Model[i].a(f5);
            }
            for (i = 0; i < this.rightWingPos2Model.length; ++i) {
                if (plane.varWing) continue;
                this.rightWingPos2Model[i].a(f5);
            }
            for (i = 0; i < this.pitchFlapRightWingModel.length; ++i) {
                this.pitchFlapRightWingModel[i].h = plane.flapsPitchRight * (float)Math.PI / 180.0f;
                this.pitchFlapRightWingModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.leftWingWheel)) {
            for (int i = 0; i < this.leftWingWheelModel.length; ++i) {
                if (!plane.varGear) continue;
                this.leftWingWheelModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.rightWingWheel)) {
            for (int i = 0; i < this.rightWingWheelModel.length; ++i) {
                if (!plane.varGear) continue;
                this.rightWingWheelModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.core)) {
            int i;
            for (i = 0; i < this.bodyModel.length; ++i) {
                this.bodyModel[i].a(f5);
            }
            for (i = 0; i < this.bodyDoorOpenModel.length; ++i) {
                if (!plane.varDoor) continue;
                this.bodyDoorOpenModel[i].a(f5);
            }
            for (i = 0; i < this.bodyDoorCloseModel.length; ++i) {
                if (plane.varDoor) continue;
                this.bodyDoorCloseModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.coreWheel)) {
            for (int i = 0; i < this.bodyWheelModel.length; ++i) {
                if (!plane.varGear) continue;
                this.bodyWheelModel[i].a(f5);
            }
        }
        if (plane.isPartIntact(EnumDriveablePart.topWing)) {
            for (int i = 0; i < this.topWingModel.length; ++i) {
                this.topWingModel[i].a(f5);
            }
        }
        for (EntitySeat seat : plane.seats) {
            if (seat == null || seat.seatInfo == null || seat.seatInfo.gunName == null || this.gunModels.get(seat.seatInfo.gunName) == null || !plane.isPartIntact(seat.seatInfo.part)) continue;
            float yaw = seat.prevLooking.getYaw() + (seat.looking.getYaw() - seat.prevLooking.getYaw()) * f;
            float pitch = seat.prevLooking.getPitch() + (seat.looking.getPitch() - seat.prevLooking.getPitch()) * f;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(seat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.g = (180.0f - yaw) * (float)Math.PI / 180.0f;
                gunModelPart.a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.g = (180.0f - yaw) * (float)Math.PI / 180.0f;
                gunModelPart.h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.g = (180.0f - yaw) * (float)Math.PI / 180.0f;
                gunModelPart.h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.a(f5);
            }
        }
    }

    @Override
    public void flipAll() {
        super.flipAll();
        this.flip(this.noseModel);
        this.flip(this.leftWingModel);
        this.flip(this.rightWingModel);
        this.flip(this.topWingModel);
        this.flip(this.bayModel);
        this.flip(this.tailModel);
        this.flip(this.yawFlapModel);
        this.flip(this.pitchFlapLeftModel);
        this.flip(this.pitchFlapRightModel);
        this.flip(this.pitchFlapLeftWingModel);
        this.flip(this.pitchFlapRightWingModel);
        this.flip(this.bodyWheelModel);
        this.flip(this.tailWheelModel);
        this.flip(this.leftWingWheelModel);
        this.flip(this.rightWingWheelModel);
        this.flip(this.tailDoorOpenModel);
        this.flip(this.tailDoorCloseModel);
        this.flip(this.rightWingPos1Model);
        this.flip(this.rightWingPos2Model);
        this.flip(this.leftWingPos1Model);
        this.flip(this.leftWingPos2Model);
        for (ModelRendererTurbo[] propellerModel : this.propellerModels) {
            this.flip(propellerModel);
        }
    }

    @Override
    public void translateAll(float x, float y, float z) {
        super.translateAll(x, y, z);
        this.translate(this.noseModel, x, y, z);
        this.translate(this.leftWingModel, x, y, z);
        this.translate(this.rightWingModel, x, y, z);
        this.translate(this.topWingModel, x, y, z);
        this.translate(this.bayModel, x, y, z);
        this.translate(this.tailModel, x, y, z);
        this.translate(this.yawFlapModel, x, y, z);
        this.translate(this.pitchFlapLeftModel, x, y, z);
        this.translate(this.pitchFlapRightModel, x, y, z);
        this.translate(this.pitchFlapLeftWingModel, x, y, z);
        this.translate(this.pitchFlapRightWingModel, x, y, z);
        this.translate(this.bodyWheelModel, x, y, z);
        this.translate(this.tailWheelModel, x, y, z);
        this.translate(this.leftWingWheelModel, x, y, z);
        this.translate(this.rightWingWheelModel, x, y, z);
        this.translate(this.tailDoorOpenModel, x, y, z);
        this.translate(this.tailDoorCloseModel, x, y, z);
        this.translate(this.rightWingPos1Model, x, y, z);
        this.translate(this.rightWingPos2Model, x, y, z);
        this.translate(this.leftWingPos1Model, x, y, z);
        this.translate(this.leftWingPos2Model, x, y, z);
        for (ModelRendererTurbo[] mods : this.propellerModels) {
            this.translate(mods, x, y, z);
        }
    }
}

