/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.client.model;

import co.uk.flansmods.client.model.ModelDriveable;
import co.uk.flansmods.client.tmt.ModelRendererTurbo;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EntityVehicle;
import co.uk.flansmods.common.driveables.EnumDriveablePart;

public class ModelVehicle
extends ModelDriveable {
    public ModelRendererTurbo[] turretModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] barrelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] frontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] backWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightFrontWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightBackWheelModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] rightTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] leftTrackWheelModels = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyDoorOpenModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] bodyDoorCloseModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] trailerModel = new ModelRendererTurbo[0];
    public ModelRendererTurbo[] steeringWheelModel = new ModelRendererTurbo[0];

    @Override
    public void render(EntityDriveable driveable, float f1) {
        this.render(0.0625f, (EntityVehicle)driveable, f1);
    }

    @Override
    public void render(DriveableType type) {
        super.render(type);
        this.renderPart(this.leftBackWheelModel);
        this.renderPart(this.rightBackWheelModel);
        this.renderPart(this.leftFrontWheelModel);
        this.renderPart(this.rightFrontWheelModel);
        this.renderPart(this.rightTrackModel);
        this.renderPart(this.leftTrackModel);
        this.renderPart(this.rightTrackWheelModels);
        this.renderPart(this.leftTrackWheelModels);
        this.renderPart(this.bodyDoorCloseModel);
        this.renderPart(this.trailerModel);
        this.renderPart(this.turretModel);
        this.renderPart(this.barrelModel);
        this.renderPart(this.steeringWheelModel);
    }

    public void render(float f5, EntityVehicle vehicle, float f) {
        int i;
        boolean rotateWheels = vehicle.getVehicleType().rotateWheels;
        if (vehicle.isPartIntact(EnumDriveablePart.core)) {
            for (i = 0; i < this.bodyModel.length; ++i) {
                this.bodyModel[i].a(f5);
            }
            for (i = 0; i < this.bodyDoorOpenModel.length; ++i) {
                if (!vehicle.varDoor) continue;
                this.bodyDoorOpenModel[i].a(f5);
            }
            for (i = 0; i < this.bodyDoorCloseModel.length; ++i) {
                if (vehicle.varDoor) continue;
                this.bodyDoorCloseModel[i].a(f5);
            }
            for (i = 0; i < this.steeringWheelModel.length; ++i) {
                this.steeringWheelModel[i].f = vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                this.steeringWheelModel[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backLeftWheel)) {
            for (i = 0; i < this.leftBackWheelModel.length; ++i) {
                this.leftBackWheelModel[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.leftBackWheelModel[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backRightWheel)) {
            for (i = 0; i < this.rightBackWheelModel.length; ++i) {
                this.rightBackWheelModel[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.rightBackWheelModel[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontLeftWheel)) {
            for (i = 0; i < this.leftFrontWheelModel.length; ++i) {
                this.leftFrontWheelModel[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.leftFrontWheelModel[i].g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                this.leftFrontWheelModel[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontRightWheel)) {
            for (i = 0; i < this.rightFrontWheelModel.length; ++i) {
                this.rightFrontWheelModel[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.rightFrontWheelModel[i].g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                this.rightFrontWheelModel[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.frontWheel)) {
            for (i = 0; i < this.frontWheelModel.length; ++i) {
                this.frontWheelModel[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.frontWheelModel[i].g = -vehicle.wheelsYaw * (float)Math.PI / 180.0f * 3.0f;
                this.frontWheelModel[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.backWheel)) {
            for (i = 0; i < this.backWheelModel.length; ++i) {
                this.backWheelModel[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.backWheelModel[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.leftTrack)) {
            for (i = 0; i < this.leftTrackModel.length; ++i) {
                this.leftTrackModel[i].a(f5);
            }
            for (i = 0; i < this.leftTrackWheelModels.length; ++i) {
                this.leftTrackWheelModels[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.leftTrackWheelModels[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.rightTrack)) {
            for (i = 0; i < this.rightTrackModel.length; ++i) {
                this.rightTrackModel[i].a(f5);
            }
            for (i = 0; i < this.rightTrackWheelModels.length; ++i) {
                this.rightTrackWheelModels[i].h = rotateWheels ? -vehicle.wheelsAngle : 0.0f;
                this.rightTrackWheelModels[i].a(f5);
            }
        }
        if (vehicle.isPartIntact(EnumDriveablePart.trailer)) {
            for (i = 0; i < this.trailerModel.length; ++i) {
                this.trailerModel[i].a(f5);
            }
        }
        for (EntitySeat seat : vehicle.seats) {
            if (seat == null || seat.seatInfo == null || seat.seatInfo.gunName == null || this.gunModels.get(seat.seatInfo.gunName) == null || !vehicle.isPartIntact(seat.seatInfo.part)) continue;
            float yaw = seat.prevLooking.getYaw() + (seat.looking.getYaw() - seat.prevLooking.getYaw()) * f;
            float pitch = seat.prevLooking.getPitch() + (seat.looking.getPitch() - seat.prevLooking.getPitch()) * f;
            ModelRendererTurbo[][] gunModel = (ModelRendererTurbo[][])this.gunModels.get(seat.seatInfo.gunName);
            for (ModelRendererTurbo gunModelPart : gunModel[0]) {
                gunModelPart.g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[1]) {
                gunModelPart.g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.a(f5);
            }
            for (ModelRendererTurbo gunModelPart : gunModel[2]) {
                gunModelPart.g = -yaw * (float)Math.PI / 180.0f;
                gunModelPart.h = -pitch * (float)Math.PI / 180.0f;
                gunModelPart.a(f5);
            }
        }
    }

    public void renderTurret(float f, float f1, float f2, float f3, float f4, float f5, EntityVehicle vehicle) {
        int i;
        float yaw = vehicle.seats[0].looking.getYaw();
        float pitch = vehicle.seats[0].looking.getPitch();
        for (i = 0; i < this.turretModel.length; ++i) {
            this.turretModel[i].a(f5);
        }
        for (i = 0; i < this.barrelModel.length; ++i) {
            this.barrelModel[i].h = -pitch * (float)Math.PI / 180.0f;
            this.barrelModel[i].a(f5);
        }
    }

    @Override
    public void flipAll() {
        super.flipAll();
        this.flip(this.bodyDoorOpenModel);
        this.flip(this.bodyDoorCloseModel);
        this.flip(this.turretModel);
        this.flip(this.barrelModel);
        this.flip(this.leftFrontWheelModel);
        this.flip(this.rightFrontWheelModel);
        this.flip(this.leftBackWheelModel);
        this.flip(this.rightBackWheelModel);
        this.flip(this.rightTrackModel);
        this.flip(this.leftTrackModel);
        this.flip(this.rightTrackWheelModels);
        this.flip(this.leftTrackWheelModels);
        this.flip(this.trailerModel);
        this.flip(this.steeringWheelModel);
        this.flip(this.frontWheelModel);
        this.flip(this.backWheelModel);
    }

    @Override
    public void translateAll(float x, float y, float z) {
        super.translateAll(x, y, z);
        this.translate(this.bodyDoorOpenModel, x, y, z);
        this.translate(this.bodyDoorCloseModel, x, y, z);
        this.translate(this.turretModel, x, y, z);
        this.translate(this.barrelModel, x, y, z);
        this.translate(this.leftFrontWheelModel, x, y, z);
        this.translate(this.rightFrontWheelModel, x, y, z);
        this.translate(this.leftBackWheelModel, x, y, z);
        this.translate(this.rightBackWheelModel, x, y, z);
        this.translate(this.rightTrackModel, x, y, z);
        this.translate(this.leftTrackModel, x, y, z);
        this.translate(this.rightTrackWheelModels, x, y, z);
        this.translate(this.leftTrackWheelModels, x, y, z);
        this.translate(this.trailerModel, x, y, z);
        this.translate(this.steeringWheelModel, x, y, z);
        this.translate(this.frontWheelModel, x, y, z);
        this.translate(this.backWheelModel, x, y, z);
    }
}

