/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.client.model;

import co.uk.flansmods.client.FlansModClient;
import co.uk.flansmods.client.FlansModResourceHandler;
import co.uk.flansmods.client.model.GunAnimations;
import co.uk.flansmods.client.model.ModelAttachment;
import co.uk.flansmods.client.model.ModelGun;
import co.uk.flansmods.common.guns.AttachmentType;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.guns.ItemGun;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderGun
implements IItemRenderer {
    private static bim renderEngine = atv.w().N;
    public static float smoothing;

    public boolean handleRenderType(ye item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                if (!atv.w().u.j) {
                    return false;
                }
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return item != null && item.b() instanceof ItemGun && ((ItemGun)item.b()).type.model != null;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ye item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ye item, Object ... data) {
        if (!(item.b() instanceof ItemGun)) {
            return;
        }
        GunType gunType = ((ItemGun)item.b()).type;
        if (gunType == null) {
            return;
        }
        ModelGun model = gunType.model;
        if (model == null) {
            return;
        }
        float f = 0.0625f;
        GunAnimations animations = FlansModClient.gunAnimations.get(data[1]);
        if (animations == null) {
            animations = new GunAnimations();
            if (type != IItemRenderer.ItemRenderType.ENTITY) {
                FlansModClient.gunAnimations.put((of)data[1], animations);
            }
        }
        GL11.glPushMatrix();
        float reloadRotate = 0.0f;
        switch (type) {
            case ENTITY: {
                ss entity = (ss)data[1];
                GL11.glRotatef((float)((float)entity.a + (entity.a == 0 ? 0.0f : smoothing)), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EQUIPPED: {
                GL11.glRotatef((float)35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.75f, (float)-0.22f, (float)-0.08f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                float adsSwitch = FlansModClient.lastZoomProgress + (FlansModClient.zoomProgress - FlansModClient.lastZoomProgress) * smoothing;
                GL11.glRotatef((float)(25.0f - 5.0f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.15f, (float)(0.2f + 0.175f * adsSwitch), (float)(-0.6f - 0.405f * adsSwitch));
                GL11.glRotatef((float)(4.5f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-0.03f * adsSwitch), (float)0.0f);
                if (!animations.reloading) break;
                float effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
                reloadRotate = 1.0f;
                if (effectiveReloadAnimationProgress < model.tiltGunTime) {
                    reloadRotate = effectiveReloadAnimationProgress / model.tiltGunTime;
                }
                if (effectiveReloadAnimationProgress > model.tiltGunTime + model.unloadClipTime + model.loadClipTime) {
                    reloadRotate = 1.0f - (effectiveReloadAnimationProgress - (model.tiltGunTime + model.unloadClipTime + model.loadClipTime)) / model.untiltGunTime;
                }
                switch (model.animationType) {
                    case BOTTOM_CLIP: 
                    case PISTOL_CLIP: 
                    case SHOTGUN: 
                    case END_LOADED: {
                        GL11.glRotatef((float)(60.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(30.0f * reloadRotate), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.25f * reloadRotate), (float)0.0f, (float)0.0f);
                        break;
                    }
                    case RIFLE: {
                        GL11.glRotatef((float)(30.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(-30.0f * reloadRotate), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(0.5f * reloadRotate), (float)0.0f, (float)(-0.5f * reloadRotate));
                    }
                }
                break;
            }
        }
        this.renderGun(item, gunType, f, model, animations, reloadRotate);
        GL11.glPopMatrix();
    }

    public void renderGun(ye item, GunType type, float f, ModelGun model, GunAnimations animations, float reloadRotate) {
        if (animations == null) {
            animations = GunAnimations.defaults;
        }
        AttachmentType scopeAttachment = type.getScope(item);
        AttachmentType barrelAttachment = type.getBarrel(item);
        AttachmentType stockAttachment = type.getStock(item);
        AttachmentType gripAttachment = type.getGrip(item);
        ye[] bulletStacks = new ye[type.numAmmoItemsInGun];
        boolean empty = true;
        for (int i = 0; i < type.numAmmoItemsInGun; ++i) {
            bulletStacks[i] = ((ItemGun)item.b()).getBulletItemStack(item, i);
            if (bulletStacks[i] == null || !(bulletStacks[i].b() instanceof ItemBullet) || bulletStacks[i].k() >= bulletStacks[i].l()) continue;
            empty = false;
        }
        renderEngine.a(FlansModResourceHandler.getTexture(type));
        if (scopeAttachment != null) {
            GL11.glTranslatef((float)0.0f, (float)(-scopeAttachment.model.renderOffset / 16.0f), (float)0.0f);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)type.modelScale, (float)type.modelScale, (float)type.modelScale);
        model.renderGun(f);
        if (scopeAttachment == null && !model.scopeIsOnSlide) {
            model.renderDefaultScope(f);
        }
        if (barrelAttachment == null) {
            model.renderDefaultBarrel(f);
        }
        if (stockAttachment == null) {
            model.renderDefaultStock(f);
        }
        if (gripAttachment == null) {
            model.renderDefaultGrip(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
        model.renderSlide(f);
        if (scopeAttachment == null && model.scopeIsOnSlide) {
            model.renderDefaultScope(f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
        model.renderPump(f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        boolean shouldRender = true;
        switch (model.animationType) {
            case END_LOADED: {
                if (!empty) break;
                shouldRender = false;
            }
        }
        if (shouldRender && animations.reloading && atv.w().u.aa == 0) {
            float effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
            float clipPosition = 0.0f;
            if (effectiveReloadAnimationProgress > model.tiltGunTime && effectiveReloadAnimationProgress < model.tiltGunTime + model.unloadClipTime) {
                clipPosition = (effectiveReloadAnimationProgress - model.tiltGunTime) / model.unloadClipTime;
            }
            if (effectiveReloadAnimationProgress >= model.tiltGunTime + model.unloadClipTime && effectiveReloadAnimationProgress < model.tiltGunTime + model.unloadClipTime + model.loadClipTime) {
                clipPosition = 1.0f - (effectiveReloadAnimationProgress - (model.tiltGunTime + model.unloadClipTime)) / model.loadClipTime;
            }
            switch (model.animationType) {
                case BOTTOM_CLIP: {
                    GL11.glRotatef((float)(-180.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(60.0f * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(0.5f * clipPosition), (float)0.0f, (float)0.0f);
                    break;
                }
                case PISTOL_CLIP: {
                    GL11.glRotatef((float)(-90.0f * clipPosition * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-1.0f * clipPosition), (float)0.0f);
                    break;
                }
                case P90: {
                    GL11.glRotatef((float)(-15.0f * reloadRotate * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(0.075f * reloadRotate), (float)0.0f);
                    GL11.glTranslatef((float)(-2.0f * clipPosition), (float)(-0.3f * clipPosition), (float)(0.5f * clipPosition));
                    break;
                }
                case RIFLE: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = ls.d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GL11.glRotatef((float)(bulletProgress * 15.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(bulletProgress * 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -1.0f), (float)0.0f, (float)(bulletProgress * 0.5f));
                    break;
                }
                case SHOTGUN: {
                    float thing = clipPosition * model.numBulletsInReloadAnimation;
                    int bulletNum = ls.d((float)thing);
                    float bulletProgress = thing - (float)bulletNum;
                    GL11.glRotatef((float)(bulletProgress * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -0.5f), (float)(bulletProgress * -1.0f), (float)0.0f);
                    break;
                }
                case END_LOADED: {
                    float bulletProgress = 1.0f;
                    if (effectiveReloadAnimationProgress > model.tiltGunTime) {
                        bulletProgress = 1.0f - Math.min((effectiveReloadAnimationProgress - model.tiltGunTime) / (model.unloadClipTime + model.loadClipTime), 1.0f);
                    }
                    GL11.glTranslatef((float)bulletProgress, (float)0.0f, (float)0.0f);
                    if (!(bulletProgress > 0.5f)) break;
                    GL11.glTranslatef((float)(-3.0f * (bulletProgress - 0.5f)), (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(-180.0f * (bulletProgress - 0.5f)), (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
            }
        }
        if (shouldRender) {
            model.renderAmmo(f);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        if (scopeAttachment != null) {
            GL11.glPushMatrix();
            renderEngine.a(FlansModResourceHandler.getTexture(scopeAttachment));
            GL11.glTranslatef((float)(model.scopeAttachPoint.x * type.modelScale), (float)(model.scopeAttachPoint.y * type.modelScale), (float)(model.scopeAttachPoint.z * type.modelScale));
            if (model.scopeIsOnSlide) {
                GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
            }
            GL11.glScalef((float)scopeAttachment.modelScale, (float)scopeAttachment.modelScale, (float)scopeAttachment.modelScale);
            ModelAttachment scopeModel = scopeAttachment.model;
            if (scopeModel != null) {
                scopeModel.renderAttachment(f);
            }
            renderEngine.a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
        if (barrelAttachment != null) {
            GL11.glPushMatrix();
            renderEngine.a(FlansModResourceHandler.getTexture(barrelAttachment));
            GL11.glTranslatef((float)(model.barrelAttachPoint.x * type.modelScale), (float)(model.barrelAttachPoint.y * type.modelScale), (float)(model.barrelAttachPoint.z * type.modelScale));
            GL11.glScalef((float)barrelAttachment.modelScale, (float)barrelAttachment.modelScale, (float)barrelAttachment.modelScale);
            ModelAttachment barrelModel = barrelAttachment.model;
            if (barrelModel != null) {
                barrelModel.renderAttachment(f);
            }
            renderEngine.a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
        if (stockAttachment != null) {
            GL11.glPushMatrix();
            renderEngine.a(FlansModResourceHandler.getTexture(stockAttachment));
            GL11.glTranslatef((float)(model.stockAttachPoint.x * type.modelScale), (float)(model.stockAttachPoint.y * type.modelScale), (float)(model.stockAttachPoint.z * type.modelScale));
            GL11.glScalef((float)stockAttachment.modelScale, (float)stockAttachment.modelScale, (float)stockAttachment.modelScale);
            ModelAttachment stockModel = stockAttachment.model;
            if (stockModel != null) {
                stockModel.renderAttachment(f);
            }
            renderEngine.a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
        if (gripAttachment != null) {
            GL11.glPushMatrix();
            renderEngine.a(FlansModResourceHandler.getTexture(gripAttachment));
            GL11.glTranslatef((float)(model.gripAttachPoint.x * type.modelScale), (float)(model.gripAttachPoint.y * type.modelScale), (float)(model.gripAttachPoint.z * type.modelScale));
            GL11.glScalef((float)gripAttachment.modelScale, (float)gripAttachment.modelScale, (float)gripAttachment.modelScale);
            ModelAttachment gripModel = gripAttachment.model;
            if (gripModel != null) {
                gripModel.renderAttachment(f);
            }
            renderEngine.a(FlansModResourceHandler.getTexture(type));
            GL11.glPopMatrix();
        }
    }
}

