/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common;

import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.TeamsManager;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class FlansModPlayerHandler
implements IPlayerTracker {
    public static Map<String, FlansModPlayerData> serverSideData = new HashMap<String, FlansModPlayerData>();
    public static Map<String, FlansModPlayerData> clientSideData = new HashMap<String, FlansModPlayerData>();
    public static ArrayList<String> clientsToRemoveAfterThisRound = new ArrayList();

    public FlansModPlayerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerPlayerTracker((IPlayerTracker)this);
    }

    @ForgeSubscribe
    public void onEntityHurt(LivingHurtEvent event) {
        of entity = event.entityLiving;
        if (event instanceof LivingHurtEvent && (entity.o instanceof EntityDriveable || entity.o instanceof EntitySeat)) {
            event.ammount = 0.0f;
        }
    }

    @ForgeSubscribe
    public void onEntityKilled(LivingDeathEvent event) {
        of entity = event.entityLiving;
        if (entity instanceof uf) {
            FlansModPlayerHandler.getPlayerData((uf)((uf)entity)).isShooting = false;
        }
    }

    public void tick() {
        for (FlansModPlayerData d : serverSideData.values()) {
            d.tick();
        }
        for (FlansModPlayerData d : clientSideData.values()) {
            d.tick();
        }
    }

    public static FlansModPlayerData getPlayerData(uf player) {
        if (player == null) {
            return null;
        }
        return FlansModPlayerHandler.getPlayerData(player.bu, Side.SERVER);
    }

    public static FlansModPlayerData getPlayerData(String username) {
        return FlansModPlayerHandler.getPlayerData(username, Side.SERVER);
    }

    public static FlansModPlayerData getPlayerData(uf player, Side side) {
        if (player == null) {
            return null;
        }
        return FlansModPlayerHandler.getPlayerData(player.bu, side);
    }

    public static FlansModPlayerData getPlayerData(String username, Side side) {
        if (side.isClient() && !clientSideData.containsKey(username)) {
            clientSideData.put(username, new FlansModPlayerData(username));
        }
        return side.isClient() ? clientSideData.get(username) : serverSideData.get(username);
    }

    public void onPlayerLogin(uf player) {
        if (!serverSideData.containsKey(player.bu)) {
            serverSideData.put(player.bu, new FlansModPlayerData(player.bu));
        }
        if (TeamsManager.getInstance().currentGametype != null && TeamsManager.getInstance().areTeamsValid()) {
            Gametype.sendTeamsMenuToPlayer((jv)player);
        }
        if (clientsToRemoveAfterThisRound.contains(player.bu)) {
            clientsToRemoveAfterThisRound.remove(player.bu);
        }
    }

    public void onPlayerLogout(uf player) {
        if (TeamsManager.getInstance().currentGametype == null) {
            serverSideData.remove(player.bu);
        } else {
            clientsToRemoveAfterThisRound.add(player.bu);
        }
    }

    public void onPlayerChangedDimension(uf player) {
    }

    public void onPlayerRespawn(uf player) {
    }

    public static void roundEnded() {
        for (String username : clientsToRemoveAfterThisRound) {
            serverSideData.remove(username);
        }
    }
}

