/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.TypeFile;
import co.uk.flansmods.common.guns.BulletType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GunBoxType
extends InfoType {
    public int blockID;
    public akc material = akc.f;
    public String topTexturePath;
    public String sideTexturePath;
    public String bottomTexturePath;
    @SideOnly(value=Side.CLIENT)
    public ms top;
    @SideOnly(value=Side.CLIENT)
    public ms side;
    @SideOnly(value=Side.CLIENT)
    public ms bottom;
    public int gunBoxID;
    public int numGuns;
    public int nextGun = -1;
    public InfoType[] guns;
    public BulletType[] bullets;
    public BulletType[] altBullets;
    public List<ye>[] gunParts;
    public List<ye>[] bulletParts;
    public List<ye>[] altBulletParts;
    private static int lastIconIndex = 2;
    public static HashMap<String, GunBoxType> gunBoxMap = new HashMap();
    public static ArrayList<String> shortNameList = new ArrayList();
    public static int nextDefaultID;

    public GunBoxType(TypeFile file) {
        super(file);
        for (String line : file.lines) {
            String[] split;
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2 || !split[0].equals("NumGuns")) continue;
            this.numGuns = Integer.parseInt(split[1]);
            this.guns = new InfoType[this.numGuns];
            this.bullets = new BulletType[this.numGuns];
            this.altBullets = new BulletType[this.numGuns];
            this.gunParts = new List[this.numGuns];
            this.bulletParts = new List[this.numGuns];
            this.altBulletParts = new List[this.numGuns];
            for (int i = 0; i < this.numGuns; ++i) {
                this.gunParts[i] = new ArrayList<ye>();
                this.bulletParts[i] = new ArrayList<ye>();
                this.altBulletParts[i] = new ArrayList<ye>();
            }
        }
    }

    @Override
    protected void read(TypeFile file) {
        super.read(file);
        if (this.gunBoxID == 0) {
            this.gunBoxID = nextDefaultID++;
        }
        gunBoxMap.put(this.shortName, this);
        shortNameList.add(this.shortName);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            int i;
            if (split[0].equals("Material")) {
                this.material = GunBoxType.getMaterial(split[1]);
            }
            if (split[0].equals("TopTexture")) {
                this.topTexturePath = split[1];
            }
            if (split[0].equals("BottomTexture")) {
                this.bottomTexturePath = split[1];
            }
            if (split[0].equals("SideTexture")) {
                this.sideTexturePath = split[1];
            }
            if (split[0].equals("GunBoxID") || split[0].equals("BlockID")) {
                this.gunBoxID = Integer.parseInt(split[1]);
            }
            if (split[0].equals("AddGun")) {
                ++this.nextGun;
                if (this.gunParts[this.nextGun] == null) {
                    FlansMod.log("NumGuns was not found or was incorrect");
                }
                this.guns[this.nextGun] = InfoType.getType(split[1]);
                for (i = 0; i < (split.length - 2) / 2; ++i) {
                    if (split[i * 2 + 3].contains(".")) {
                        this.gunParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1])));
                        continue;
                    }
                    this.gunParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0));
                }
            }
            if (split[0].equals("AddAmmo")) {
                if (this.bulletParts[this.nextGun] == null) {
                    FlansMod.log("NumGuns was not found or was incorrect");
                }
                this.bullets[this.nextGun] = BulletType.getBullet(split[1]);
                for (i = 0; i < (split.length - 2) / 2; ++i) {
                    if (split[i * 2 + 3].contains(".")) {
                        this.bulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1])));
                        continue;
                    }
                    this.bulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0));
                }
            }
            if (split[0].equals("AddAltAmmo") || split[0].equals("AddAlternateAmmo")) {
                if (this.altBulletParts[this.nextGun] == null) {
                    FlansMod.log("NumGuns was not found or was incorrect");
                }
                this.altBullets[this.nextGun] = BulletType.getBullet(split[1]);
                for (i = 0; i < (split.length - 2) / 2; ++i) {
                    if (split[i * 2 + 3].contains(".")) {
                        this.altBulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1])));
                        continue;
                    }
                    this.altBulletParts[this.nextGun].add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Reading gun box file failed : " + this.shortName);
            e.printStackTrace();
        }
    }

    public static GunBoxType getBox(String s) {
        return gunBoxMap.get(s);
    }

    public static GunBoxType getBox(int ID) {
        for (GunBoxType type : gunBoxMap.values()) {
            if (type.gunBoxID != ID) continue;
            return type;
        }
        return null;
    }

    public static akc getMaterial(String mat) {
        if (mat.equals("wood")) {
            return akc.d;
        }
        if (mat.equals("rock") || mat.equals("stone")) {
            return akc.e;
        }
        if (mat.equals("iron")) {
            return akc.f;
        }
        if (mat.equals("cloth")) {
            return akc.n;
        }
        return akc.f;
    }

    public static ye getRecipeElement(String stringy, int amount, int damage) {
        ye stack = GunBoxType.getRecipeElement(stringy, damage);
        if (stack == null) {
            return stack;
        }
        stack.b = amount;
        return stack;
    }

    @Override
    public void addRecipe(yc par1Item) {
        if (this.smeltableFrom != null) {
            GameRegistry.addSmelting((int)GunBoxType.getRecipeElement((String)this.smeltableFrom, (int)0).d, (ye)new ye(this.item), (float)0.0f);
        }
        if (this.recipeLine == null) {
            return;
        }
        try {
            if (!this.shapeless) {
                Object[] newRecipe1;
                int last;
                int rows = 3;
                if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.recipe[i] = ((String)this.recipe[i]).substring(1);
                    }
                    if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(1);
                        }
                    }
                }
                if (((String)this.recipe[0]).charAt(last = ((String)this.recipe[0]).length() - 1) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.recipe[i] = ((String)this.recipe[i]).substring(0, last);
                    }
                    if (((String)this.recipe[0]).charAt(--last) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(0, 0);
                        }
                    }
                }
                if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                    Object[] newRecipe = new Object[this.recipe.length - 1];
                    newRecipe[0] = this.recipe[1];
                    newRecipe[1] = this.recipe[2];
                    this.recipe = newRecipe;
                    --rows;
                    if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                        newRecipe1 = new Object[this.recipe.length - 1];
                        newRecipe1[0] = this.recipe[1];
                        this.recipe = newRecipe1;
                        --rows;
                    }
                }
                if (this.recipe[rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                    Object[] newRecipe = new Object[this.recipe.length - 1];
                    newRecipe[0] = this.recipe[0];
                    newRecipe[1] = this.recipe[1];
                    this.recipe = newRecipe;
                    if (this.recipe[--rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                        newRecipe1 = new Object[this.recipe.length - 1];
                        newRecipe1[0] = this.recipe[0];
                        this.recipe = newRecipe1;
                        --rows;
                    }
                }
                for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                    this.recipe[i * 2 + rows] = Character.valueOf(this.recipeLine[i * 2 + 1].charAt(0));
                    this.recipe[i * 2 + rows + 1] = this.recipeLine[i * 2 + 2].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2].split("\\.")[0], Integer.valueOf(this.recipeLine[i * 2 + 2].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2], 0);
                }
                GameRegistry.addRecipe((ye)new ye((aqz)FlansMod.gunBoxBlock, this.recipeOutput, this.gunBoxID), (Object[])this.recipe);
            } else {
                this.recipe = new Object[this.recipeLine.length - 1];
                for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                    this.recipe[i] = this.recipeLine[i + 1].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i + 1].split("\\.")[0], Integer.valueOf(this.recipeLine[i + 1].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i + 1], 0);
                }
                GameRegistry.addShapelessRecipe((ye)new ye((aqz)FlansMod.gunBoxBlock, this.recipeOutput, this.gunBoxID), (Object[])this.recipe);
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to add recipe for : " + this.shortName);
            e.printStackTrace();
        }
    }
}

