/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables;

import co.uk.flansmods.common.ItemPart;
import co.uk.flansmods.common.PartType;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.guns.ItemBullet;
import java.util.HashMap;

public class DriveableData
implements mo {
    public int numGuns;
    public int numBombs;
    public int numCargo;
    public String type;
    public PartType engine;
    public ye[] ammo;
    public ye[] bombs;
    public ye[] cargo;
    public ye fuel;
    public float fuelInTank;
    public HashMap<EnumDriveablePart, DriveablePart> parts = new HashMap();

    public DriveableData(by tags) {
        this.readFromNBT(tags);
    }

    public void readFromNBT(by tag) {
        int i;
        if (tag == null) {
            return;
        }
        if (!tag.b("Type")) {
            return;
        }
        this.type = tag.i("Type");
        DriveableType dType = DriveableType.getDriveable(this.type);
        this.numBombs = dType.numBombSlots;
        this.numCargo = dType.numCargoSlots;
        this.numGuns = dType.numPassengerGunners + dType.guns.size();
        this.engine = PartType.getPart(tag.i("Engine"));
        this.ammo = new ye[this.numGuns];
        this.bombs = new ye[this.numBombs];
        this.cargo = new ye[this.numCargo];
        for (i = 0; i < this.numGuns; ++i) {
            this.ammo[i] = ye.a((by)tag.l("Ammo " + i));
        }
        for (i = 0; i < this.numBombs; ++i) {
            this.bombs[i] = ye.a((by)tag.l("Bombs " + i));
        }
        for (i = 0; i < this.numCargo; ++i) {
            this.cargo[i] = ye.a((by)tag.l("Cargo " + i));
        }
        this.fuel = ye.a((by)tag.l("Fuel"));
        this.fuelInTank = tag.e("FuelInTank");
        for (EnumDriveablePart part : EnumDriveablePart.values()) {
            this.parts.put(part, new DriveablePart(part, dType.health.get((Object)part)));
        }
        for (DriveablePart part : this.parts.values()) {
            part.readFromNBT(tag);
        }
    }

    public void writeToNBT(by tag) {
        int i;
        tag.a("Type", this.type);
        tag.a("Engine", this.engine.shortName);
        for (i = 0; i < this.ammo.length; ++i) {
            if (this.ammo[i] == null) continue;
            tag.a("Ammo " + i, this.ammo[i].b(new by()));
        }
        for (i = 0; i < this.bombs.length; ++i) {
            if (this.bombs[i] == null) continue;
            tag.a("Bombs " + i, this.bombs[i].b(new by()));
        }
        for (i = 0; i < this.cargo.length; ++i) {
            if (this.cargo[i] == null) continue;
            tag.a("Cargo " + i, this.cargo[i].b(new by()));
        }
        if (this.fuel != null) {
            tag.a("Fuel", this.fuel.b(new by()));
        }
        tag.a("FuelInTank", (int)this.fuelInTank);
        for (DriveablePart part : this.parts.values()) {
            part.writeToNBT(tag);
        }
    }

    public int j_() {
        return this.getFuelSlot() + 1;
    }

    public ye a(int i) {
        ye[] inv = this.ammo;
        if (i >= this.ammo.length) {
            inv = this.bombs;
            if ((i -= this.ammo.length) >= this.bombs.length) {
                inv = this.cargo;
                if ((i -= this.bombs.length) >= this.cargo.length) {
                    return this.fuel;
                }
            }
        }
        return inv[i];
    }

    public ye a(int i, int j) {
        ye[] inv = this.ammo;
        if (i >= this.ammo.length) {
            inv = this.bombs;
            if ((i -= this.ammo.length) >= this.bombs.length) {
                inv = this.cargo;
                if ((i -= this.bombs.length) >= this.cargo.length) {
                    i -= this.cargo.length;
                    inv = new ye[]{this.fuel};
                    this.a(this.getFuelSlot(), null);
                }
            }
        }
        if (inv[i] != null) {
            if (inv[i].b <= j) {
                ye itemstack = inv[i];
                inv[i] = null;
                return itemstack;
            }
            ye itemstack1 = inv[i].a(j);
            if (inv[i].b <= 0) {
                inv[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ye a_(int i) {
        return this.a(i);
    }

    public void a(int i, ye stack) {
        ye[] inv = this.ammo;
        if (i >= this.ammo.length) {
            inv = this.bombs;
            if ((i -= this.ammo.length) >= this.bombs.length) {
                inv = this.cargo;
                if ((i -= this.bombs.length) >= this.cargo.length) {
                    this.fuel = stack;
                    return;
                }
            }
        }
        inv[i] = stack;
    }

    public String b() {
        return "Flan's Secret Data";
    }

    public int d() {
        return 64;
    }

    public void e() {
    }

    public boolean a(uf player) {
        return true;
    }

    public void k_() {
    }

    public void g() {
    }

    public int getAmmoInventoryStart() {
        return 0;
    }

    public int getBombInventoryStart() {
        return this.ammo.length;
    }

    public int getCargoInventoryStart() {
        return this.ammo.length + this.bombs.length;
    }

    public int getFuelSlot() {
        return this.ammo.length + this.bombs.length + this.cargo.length;
    }

    public boolean c() {
        return false;
    }

    public boolean b(int i, ye itemstack) {
        if (i < this.getBombInventoryStart() && itemstack != null && itemstack.b() instanceof ItemBullet) {
            return true;
        }
        if (i >= this.getBombInventoryStart() && i < this.getCargoInventoryStart() && itemstack != null && itemstack.b() instanceof ItemBullet) {
            return true;
        }
        if (i >= this.getCargoInventoryStart() && i < this.getFuelSlot()) {
            return true;
        }
        return i == this.getFuelSlot() && itemstack != null && itemstack.b() instanceof ItemPart && ((ItemPart)itemstack.b()).type.category == 9;
    }
}

