/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables;

import co.uk.flansmods.api.IControllable;
import co.uk.flansmods.api.IExplodeable;
import co.uk.flansmods.client.FlansModClient;
import co.uk.flansmods.client.debug.EntityDebugVector;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.RotatedAxes;
import co.uk.flansmods.common.driveables.CollisionPoint;
import co.uk.flansmods.common.driveables.DriveableData;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.driveables.Seat;
import co.uk.flansmods.common.guns.EntityBullet;
import co.uk.flansmods.common.network.PacketDriveableDamage;
import co.uk.flansmods.common.network.PacketDriveableKeyHeld;
import co.uk.flansmods.common.vector.Vector3f;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.api.RadarRegistry;
import icbm.api.sentry.IAATarget;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public abstract class EntityDriveable
extends nn
implements IControllable,
IExplodeable,
IEntityAdditionalSpawnData,
IAATarget {
    public boolean syncFromServer = true;
    public int serverPositionTransitionTicker;
    public double bZ;
    public double ca;
    public double cb;
    public double serverYaw;
    public double serverPitch;
    public double serverRoll;
    public DriveableData driveableData;
    public String driveableType;
    public float throttle;
    public boolean fuelling;
    public float prevRotationRoll;
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean leftMouseHeld = false;
    public boolean rightMouseHeld = false;
    public RotatedAxes prevAxes;
    public RotatedAxes axes = new RotatedAxes();
    public EntitySeat[] seats;

    public EntityDriveable(abw world) {
        super(world);
        this.prevAxes = new RotatedAxes();
        this.m = true;
        this.a(1.0f, 1.0f);
        this.N = 0.375f;
        this.am = true;
        this.l = 200.0;
    }

    public EntityDriveable(abw world, DriveableType t, DriveableData d) {
        this(world);
        this.driveableType = t.shortName;
        this.driveableData = d;
    }

    protected void initType(DriveableType type, boolean clientSide) {
        this.seats = new EntitySeat[type.numPassengers + 1];
        for (int i = 0; i < type.numPassengers + 1; ++i) {
            if (clientSide) continue;
            this.seats[i] = new EntitySeat(this.q, this, i);
            this.q.d((nn)this.seats[i]);
        }
        this.N = type.yOffset;
        if (type.onRadar) {
            RadarRegistry.register(this);
        }
    }

    protected void b(by tag) {
        this.driveableData.writeToNBT(tag);
        tag.a("Type", this.driveableType);
        tag.a("RotationYaw", this.axes.getYaw());
        tag.a("RotationPitch", this.axes.getPitch());
        tag.a("RotationRoll", this.axes.getRoll());
    }

    protected void a(by tag) {
        this.driveableType = tag.i("Type");
        this.driveableData = new DriveableData(tag);
        this.initType(DriveableType.getDriveable(this.driveableType), false);
        this.C = tag.g("RotationYaw");
        this.D = tag.g("RotationPitch");
        this.prevRotationRoll = tag.g("RotationRoll");
        this.axes = new RotatedAxes(this.C, this.D, this.prevRotationRoll);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        try {
            data.writeUTF(this.driveableType);
            by tag = new by();
            this.driveableData.writeToNBT(tag);
            cl.a((cl)tag, (DataOutput)data);
            data.writeFloat(this.axes.getYaw());
            data.writeFloat(this.axes.getPitch());
            data.writeFloat(this.axes.getRoll());
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                data.writeShort((int)((short)part.health));
                data.writeBoolean(part.onFire);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteArrayDataInput inputData) {
        try {
            this.driveableType = inputData.readUTF();
            this.driveableData = new DriveableData((by)cl.a((DataInput)inputData));
            this.initType(this.getDriveableType(), true);
            this.axes.setAngles(inputData.readFloat(), inputData.readFloat(), inputData.readFloat());
            this.C = this.axes.getYaw();
            this.D = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                part.health = inputData.readShort();
                part.onFire = inputData.readBoolean();
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to retreive plane type from server.");
            super.x();
            e.printStackTrace();
        }
    }

    public abstract void writeUpdateData(DataOutputStream var1);

    public abstract void readUpdateData(DataInputStream var1);

    @Override
    public abstract void onMouseMoved(int var1, int var2);

    protected boolean canSit(int seat) {
        return this.getDriveableType().numPassengers >= seat && this.seats[seat].n == null;
    }

    protected boolean e_() {
        return false;
    }

    protected void a() {
    }

    public asx g(nn entity) {
        return entity.E;
    }

    public asx E() {
        return this.E;
    }

    public boolean M() {
        return false;
    }

    public double Y() {
        return -0.3;
    }

    public boolean a(nb damagesource, float i) {
        if (this.q.I || this.M) {
            return true;
        }
        return true;
    }

    public void x() {
        super.x();
        RadarRegistry.unregister(this);
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.x();
        }
    }

    public void b_(uf par1EntityPlayer) {
    }

    public boolean L() {
        return !this.M;
    }

    public void f(nn entity) {
        if (!this.isPartOfThis(entity)) {
            super.f(entity);
        }
    }

    public void a(double d, double d1, double d2, float f, float f1, int i) {
        if (this.ac > 1) {
            return;
        }
        if (!(this.n instanceof uf) || !FlansMod.proxy.isThePlayer((uf)this.n)) {
            if (this.syncFromServer) {
                this.serverPositionTransitionTicker = i + 5;
            } else {
                double var10 = d - this.u;
                double var12 = d1 - this.v;
                double var14 = d2 - this.w;
                double var16 = var10 * var10 + var12 * var12 + var14 * var14;
                if (var16 <= 1.0) {
                    return;
                }
                this.serverPositionTransitionTicker = 3;
            }
            this.bZ = d;
            this.ca = d1;
            this.cb = d2;
            this.serverYaw = f;
            this.serverPitch = f1;
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt) {
        if (this.q.I) {
            this.bZ = x;
            this.ca = y;
            this.cb = z;
            this.serverYaw = yaw;
            this.serverPitch = pitch;
            this.serverRoll = roll;
            this.serverPositionTransitionTicker = 5;
        } else {
            this.b(x, y, z);
            this.C = yaw;
            this.D = pitch;
            this.prevRotationRoll = roll;
            this.setRotation(yaw, pitch, roll);
        }
        this.x = motX;
        this.y = motY;
        this.z = motZ;
        this.angularVelocity = new Vector3f(velYaw, velPitch, velRoll);
        this.throttle = throt;
    }

    public void h(double d, double d1, double d2) {
        this.x = d;
        this.y = d1;
        this.z = d2;
    }

    @Override
    public abstract boolean pressKey(int var1, uf var2);

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if (this.q.I) {
            PacketDispatcher.sendPacketToServer((ey)PacketDriveableKeyHeld.buildKeyPacket(key, held));
        }
        switch (key) {
            case 9: {
                this.leftMouseHeld = held;
                break;
            }
            case 8: {
                this.rightMouseHeld = held;
            }
        }
    }

    public void l_() {
        super.l_();
        DriveableType type = this.getDriveableType();
        if (!this.q.I) {
            for (int i = 0; i < this.getDriveableType().numPassengers + 1; ++i) {
                if (this.seats[i] != null && this.seats[i].ai) continue;
                this.seats[i] = new EntitySeat(this.q, this, i);
                this.q.d((nn)this.seats[i]);
            }
        }
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            Vector3f pos;
            if (part.box == null) continue;
            part.update(this);
            if (this.q.I) {
                if (part.onFire) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + this.ab.nextFloat() * (float)part.box.w / 16.0f, (float)part.box.y / 16.0f + this.ab.nextFloat() * (float)part.box.h / 16.0f, (float)part.box.z / 16.0f + this.ab.nextFloat() * (float)part.box.d / 16.0f));
                    this.q.a("flame", this.u + (double)pos.x, this.v + (double)pos.y, this.w + (double)pos.z, 0.0, 0.0, 0.0);
                }
                if (part.health > 0 && part.health < part.maxHealth / 2) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + this.ab.nextFloat() * (float)part.box.w / 16.0f, (float)part.box.y / 16.0f + this.ab.nextFloat() * (float)part.box.h / 16.0f, (float)part.box.z / 16.0f + this.ab.nextFloat() * (float)part.box.d / 16.0f));
                    this.q.a(part.health < part.maxHealth / 4 ? "largesmoke" : "smoke", this.u + (double)pos.x, this.v + (double)pos.y, this.w + (double)pos.z, 0.0, 0.0, 0.0);
                }
            }
            if (part.onFire) {
                if (this.q.Q() && this.ab.nextInt(40) == 0) {
                    part.onFire = false;
                }
                pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
                if (this.q.g(ls.c((double)(this.u + (double)pos.x)), ls.c((double)(this.v + (double)pos.y)), ls.c((double)(this.w + (double)pos.z))) != akc.h) continue;
                part.onFire = false;
                continue;
            }
            pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
            if (this.q.g(ls.c((double)(this.u + (double)pos.x)), ls.c((double)(this.v + (double)pos.y)), ls.c((double)(this.w + (double)pos.z))) != akc.i) continue;
            part.onFire = true;
        }
        this.checkParts();
        this.C = this.axes.getYaw();
        this.D = this.axes.getPitch();
        this.prevRotationRoll = this.axes.getRoll();
        this.prevAxes = this.axes.clone();
        if (this.n != null && this.n.M) {
            this.n = null;
        }
        if (this.n != null && this.M) {
            this.n.a(null);
        }
        if (this.n != null) {
            this.n.T = 0.0f;
        }
        if (!this.q.I && this.seats[0].n == null) {
            this.throttle *= 0.9f;
        }
    }

    protected void b(float k) {
        if (k <= 0.0f) {
            return;
        }
        super.b(k);
        int i = ls.f((float)(k - 3.0f));
        if (i > 0) {
            if (i > 4) {
                this.a("damage.fallbig", 1.0f, 1.0f);
            } else {
                this.a("damage.fallsmall", 1.0f, 1.0f);
            }
            this.a(nb.h, i);
            int j = this.q.a(ls.c((double)this.u), ls.c((double)(this.v - (double)0.2f - (double)this.N)), ls.c((double)this.w));
            if (j > 0) {
                ard stepsound = aqz.s[j].cS;
                this.a(stepsound.e(), stepsound.c() * 0.5f, stepsound.d() * 0.75f);
            }
        }
    }

    public Vector3f rotate(Vector3f inVec) {
        return this.axes.findLocalVectorGlobally(inVec);
    }

    public Vector3f rotate(atc inVec) {
        return this.rotate(inVec.c, inVec.d, inVec.e);
    }

    public Vector3f rotate(double x, double y, double z) {
        return this.rotate(new Vector3f((float)x, (float)y, (float)z));
    }

    public void rotateYaw(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalYaw(rotateBy);
        this.updatePrevAngles();
    }

    public void rotatePitch(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalPitch(rotateBy);
        this.updatePrevAngles();
    }

    public void rotateRoll(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalRoll(rotateBy);
        this.updatePrevAngles();
    }

    public void updatePrevAngles() {
        double dRoll;
        double dPitch;
        double dYaw = this.axes.getYaw() - this.C;
        if (dYaw > 180.0) {
            this.C += 360.0f;
        }
        if (dYaw < -180.0) {
            this.C -= 360.0f;
        }
        if ((dPitch = (double)(this.axes.getPitch() - this.D)) > 180.0) {
            this.D += 360.0f;
        }
        if (dPitch < -180.0) {
            this.D -= 360.0f;
        }
        if ((dRoll = (double)(this.axes.getRoll() - this.prevRotationRoll)) > 180.0) {
            this.prevRotationRoll += 360.0f;
        }
        if (dRoll < -180.0) {
            this.prevRotationRoll -= 360.0f;
        }
    }

    public void setRotation(float rotYaw, float rotPitch, float rotRoll) {
        this.axes.setAngles(rotYaw, rotPitch, rotRoll);
    }

    public boolean isPartOfThis(nn ent) {
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            if (ent == seat) {
                return true;
            }
            if (seat.n != ent) continue;
            return true;
        }
        return ent == this;
    }

    public float S() {
        return 0.0f;
    }

    public DriveableType getDriveableType() {
        return DriveableType.getDriveable(this.driveableType);
    }

    public DriveableData getDriveableData() {
        return this.driveableData;
    }

    @Override
    public boolean isDead() {
        return this.M;
    }

    @Override
    public nn getControllingEntity() {
        return this.seats[0].getControllingEntity();
    }

    public ye getPickedResult(ata target) {
        ye stack = new ye(this.getDriveableType().itemID, 1, 0);
        stack.e = new by();
        this.driveableData.writeToNBT(stack.e);
        return stack;
    }

    public boolean hasFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].n == null) {
            return false;
        }
        if (this.seats[0].n instanceof uf && ((uf)this.seats[0].n).bG.d) {
            return true;
        }
        return this.driveableData.fuelInTank > 0.0f;
    }

    public boolean hasEnoughFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].n == null) {
            return false;
        }
        if (this.seats[0].n instanceof uf && ((uf)this.seats[0].n).bG.d) {
            return true;
        }
        return this.driveableData.fuelInTank > this.driveableData.engine.fuelConsumption * this.throttle;
    }

    public double getSpeedXYZ() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double getKineticEnergy() {
        return 0.5 * (double)this.getDriveableType().mass * this.getSpeedXYZ();
    }

    public void applyForce(Vector3f forceOrigin, Vector3f forceVector) {
        this.applyTranslationalForce(forceOrigin, forceVector);
        this.applyRotationalForce(forceOrigin, forceVector);
    }

    public void applyRotationalForce(Vector3f forceOrigin, Vector3f forceVector) {
        Vector3f torqueVector = Vector3f.cross((Vector3f)forceVector.scale(1.0f), forceOrigin, null);
        this.applyTorque(torqueVector);
    }

    public void applyTorque(Vector3f torqueVector) {
        float deltaTime = 0.05f;
        float momentOfInertia = this.getDriveableType().momentOfInertia / (float)(this.landVehicle() ? 250 : 100);
        Vector3f.add(this.angularVelocity, (Vector3f)torqueVector.scale(deltaTime * 1.0f / momentOfInertia), this.angularVelocity);
    }

    public void applyTranslationalForce(Vector3f forceOrigin, Vector3f forceVector) {
        float deltaTime = 0.05f;
        Vector3f accelerationVector = (Vector3f)forceVector.scale(1.0f / this.getDriveableType().mass);
        this.x += (double)(accelerationVector.x * deltaTime);
        this.y += (double)(accelerationVector.y * deltaTime);
        this.z += (double)(accelerationVector.z * deltaTime);
    }

    public void moveDriveable() {
        ArrayList aabbs;
        aqz block;
        Vector3f newOrigin;
        Vector3f origin;
        Vector3f newPointVec;
        Vector3f pointVec;
        float deltaTime = 0.05f;
        DriveableType type = this.getDriveableType();
        Vector3f position = new Vector3f((float)this.u, (float)this.v, (float)this.w);
        Vector3f motion = new Vector3f((float)this.x, (float)this.y, (float)this.z);
        if (this.q.I && FlansMod.DEBUG) {
            this.q.d((nn)new EntityDebugVector(this.q, position, motion, 2, 0.0f, 0.0f, 1.0f));
            this.q.d((nn)new EntityDebugVector(this.q, position, (Vector3f)new Vector3f(this.angularVelocity).scale(0.1f), 2, 1.0f, 0.0f, 1.0f));
        }
        RotatedAxes newAxes = this.axes.clone();
        if ((double)Math.abs(this.angularVelocity.lengthSquared()) > 1.0E-8) {
            newAxes.rotateLocal(this.angularVelocity.length() * deltaTime, (Vector3f)new Vector3f(this.angularVelocity).normalise());
        }
        int numHits = 0;
        for (CollisionPoint point : type.points) {
            ata hit;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            newPointVec = newAxes.findLocalVectorGlobally(point.getLocalVector());
            origin = Vector3f.add(position, pointVec, null);
            newOrigin = Vector3f.add(position, newPointVec, null);
            Vector3f rayOrigin = Vector3f.sub(newOrigin, motion, null);
            Vector3f ray = Vector3f.add(newOrigin, motion, null);
            if (this.q.I && FlansMod.DEBUG) {
                this.q.d((nn)new EntityDebugVector(this.q, origin, (Vector3f)Vector3f.sub(ray, origin, null).scale(1.0f), 2, 1.0f, 0.0f, 0.0f));
            }
            if ((hit = this.q.a(rayOrigin.toVec3(), ray.toVec3())) == null) continue;
            ++numHits;
        }
        if (numHits > 0) {
            for (CollisionPoint point : type.points) {
                if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
                pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
                newPointVec = newAxes.findLocalVectorGlobally(point.getLocalVector());
                origin = Vector3f.add(position, pointVec, null);
                newOrigin = Vector3f.add(position, newPointVec, null);
                Vector3f ray = Vector3f.add(newOrigin, motion, null);
                ata hit = this.q.a(newOrigin.toVec3(), ray.toVec3());
                if (hit == null || hit.a != atb.a) continue;
                Vector3f hitVec = new Vector3f(hit.f);
                Vector3f normal = null;
                int x = 0;
                int y = 0;
                int z = 0;
                switch (hit.e) {
                    case 0: {
                        normal = new Vector3f(0.0f, -1.0f, 0.0f);
                        y = -1;
                        break;
                    }
                    case 1: {
                        normal = new Vector3f(0.0f, 1.0f, 0.0f);
                        y = 1;
                        break;
                    }
                    case 2: {
                        normal = new Vector3f(0.0f, 0.0f, -1.0f);
                        z = 1;
                        break;
                    }
                    case 3: {
                        normal = new Vector3f(0.0f, 0.0f, 1.0f);
                        z = -1;
                        break;
                    }
                    case 4: {
                        normal = new Vector3f(-1.0f, 0.0f, 0.0f);
                        x = 1;
                        break;
                    }
                    case 5: {
                        normal = new Vector3f(1.0f, 0.0f, 0.0f);
                        x = -1;
                    }
                }
                if (this.q.isBlockSolidOnSide(hit.b + x, hit.c + y, hit.d + z, ForgeDirection.getOrientation((int)hit.e).getOpposite())) continue;
                if (this.q.I && FlansMod.DEBUG) {
                    this.q.d((nn)new EntityDebugVector(this.q, hitVec, normal, 2, 0.0f, 1.0f, 0.0f));
                }
                float normalReactionMagnitude = Vector3f.dot(normal.negate(null), Vector3f.sub(ray, hitVec, null));
                float forceMagnitude = type.mass * normalReactionMagnitude / ((float)numHits * deltaTime);
                boolean shouldApplyForce = true;
                float damagePoint = 1.0f;
                float damageModifier = 5.0f;
                float blockDamageModifier = 50.0f;
                if (forceMagnitude > damagePoint * type.mass) {
                    float smashyForce = forceMagnitude - damagePoint * type.mass;
                    DriveablePart part = this.getDriveableData().parts.get((Object)point.part);
                    float smashyForceVsBlock = blockDamageModifier * part.smashIntoGround(this, damageModifier * smashyForce);
                    int blockIDHit = this.q.a(hit.b, hit.c, hit.d);
                    aqz blockHit = aqz.s[blockIDHit];
                    float blockHardness = blockHit.l(this.q, hit.b, hit.c, hit.d);
                    if (FlansMod.driveablesBreakBlocks && smashyForceVsBlock > blockHardness && blockHardness >= 0.0f) {
                        blockHit.c(this.q, hit.b, hit.c, hit.d, this.q.h(hit.b, hit.c, hit.d), 1);
                        FlansMod.proxy.playBlockBreakSound(hit.b, hit.c, hit.d, blockIDHit);
                        this.q.i(hit.b, hit.c, hit.d);
                        shouldApplyForce = false;
                    }
                }
                if (!shouldApplyForce) continue;
                this.applyForce(pointVec, (Vector3f)normal.scale(forceMagnitude));
            }
        }
        this.u += this.x;
        this.v += this.y;
        this.w += this.z;
        if ((double)Math.abs(this.angularVelocity.lengthSquared()) > 1.0E-8) {
            this.axes.rotateGlobal(this.angularVelocity.length() * deltaTime, (Vector3f)new Vector3f(this.angularVelocity).normalise());
        }
        numHits = 0;
        for (CollisionPoint point : type.points) {
            int blockZ;
            int blockY;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            int blockX = ls.c((double)(this.u + (double)pointVec.x));
            int blockID = this.q.a(blockX, blockY = ls.c((double)(this.v + (double)pointVec.y)), blockZ = ls.c((double)(this.w + (double)pointVec.z)));
            if (blockID <= 0) continue;
            block = aqz.s[blockID];
            aabbs = new ArrayList();
            block.a(this.q, blockX, blockY, blockZ, asx.a((double)(this.u + (double)pointVec.x), (double)(this.v + (double)pointVec.y), (double)(this.w + (double)pointVec.z), (double)(this.u + (double)pointVec.x), (double)(this.v + (double)pointVec.y), (double)(this.w + (double)pointVec.z)), aabbs, (nn)this);
            if (aabbs.size() <= 0) continue;
            ++numHits;
        }
        for (CollisionPoint point : type.points) {
            int blockZ;
            int blockY;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            int blockX = ls.c((double)(this.u + (double)pointVec.x));
            int blockID = this.q.a(blockX, blockY = ls.c((double)(this.v + (double)pointVec.y)), blockZ = ls.c((double)(this.w + (double)pointVec.z)));
            if (blockID <= 0) continue;
            block = aqz.s[blockID];
            aabbs = new ArrayList();
            block.a(this.q, blockX, blockY, blockZ, asx.a((double)(this.u + (double)pointVec.x), (double)(this.v + (double)pointVec.y), (double)(this.w + (double)pointVec.z), (double)(this.u + (double)pointVec.x), (double)(this.v + (double)pointVec.y), (double)(this.w + (double)pointVec.z)), aabbs, (nn)this);
            if (aabbs.size() <= 0) continue;
            asx aabb = (asx)aabbs.get(0);
            double dminX = Math.abs(this.u + (double)pointVec.x - aabb.a);
            double dmaxX = Math.abs(this.u + (double)pointVec.x - aabb.d);
            double dminY = Math.abs(this.v + (double)pointVec.y - aabb.b);
            double dmaxY = Math.abs(this.v + (double)pointVec.y - aabb.e);
            double dminZ = Math.abs(this.w + (double)pointVec.z - aabb.c);
            double dmaxZ = Math.abs(this.w + (double)pointVec.z - aabb.f);
            double min = Math.min(Math.min(Math.min(dminX, dmaxX), Math.min(dminY, dmaxY)), Math.min(dminZ, dmaxZ));
            float pushiness = 1.0f;
            float bounciness = type.bounciness;
            this.applyForce(pointVec, new Vector3f(0.0f, (float)dmaxY * type.mass / (deltaTime * (float)numHits) * type.bounciness, 0.0f));
        }
        this.checkParts();
        this.b(this.u, this.v, this.w);
    }

    public boolean landVehicle() {
        return false;
    }

    public boolean gearDown() {
        return true;
    }

    public boolean onGround() {
        return this.F;
    }

    public boolean attackPoint(CollisionPoint point, nb damagesource, float i) {
        return false;
    }

    public boolean attackFromBullet(EntityBullet bullet, Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.u, (float)this.v, (float)this.w), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (!part.rayTrace(this, bullet, rotatedPosVector, rotatedMotVector)) continue;
            if (this.q.I) {
                return true;
            }
            this.checkParts();
            PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)100.0, (int)this.ar, (ey)PacketDriveableDamage.buildUpdatePacket(this));
            return true;
        }
        return false;
    }

    public DriveablePart raytraceParts(Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.u, (float)this.v, (float)this.w), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (!part.rayTrace(this, null, rotatedPosVector, rotatedMotVector)) continue;
            return part;
        }
        return null;
    }

    public boolean canHitPart(EnumDriveablePart part) {
        return true;
    }

    public void checkParts() {
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part == null || part.dead || part.health > 0 || part.maxHealth <= 0) continue;
            this.killPart(part);
        }
        for (EntitySeat seat : this.seats) {
        }
        if (this.getDriveableData().parts.get((Object)((Object)EnumDriveablePart.core)).dead) {
            this.x();
        }
    }

    private void killPart(DriveablePart part) {
        if (part.dead) {
            return;
        }
        part.health = 0;
        part.dead = true;
        DriveableType type = this.getDriveableType();
        if (!this.q.I) {
            ArrayList<ye> drops;
            Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
            if (part.box != null) {
                pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
            }
            if ((drops = type.getItemsRequired(part, this.getDriveableData().engine)) != null) {
                for (ye stack : drops) {
                    this.q.d((nn)new ss(this.q, this.u + (double)pos.x, this.v + (double)pos.y, this.w + (double)pos.z, stack.m()));
                }
            }
            this.dropItemsOnPartDeath(pos, part);
            if (part.type == EnumDriveablePart.core) {
                for (int i = 0; i < this.getDriveableData().j_(); ++i) {
                    ye stack;
                    stack = this.getDriveableData().a(i);
                    if (stack == null) continue;
                    this.q.d((nn)new ss(this.q, this.u + this.ab.nextGaussian(), this.v + this.ab.nextGaussian(), this.w + this.ab.nextGaussian(), stack));
                }
            }
        }
        for (EnumDriveablePart child : part.type.getChildren()) {
            this.killPart(this.getDriveableData().parts.get((Object)child));
        }
    }

    protected abstract void dropItemsOnPartDeath(Vector3f var1, DriveablePart var2);

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    public void explode() {
    }

    @Override
    public float getCameraDistance() {
        return this.getDriveableType().cameraDistance;
    }

    public boolean isPartIntact(EnumDriveablePart part) {
        return this.getDriveableData().parts.get((Object)((Object)part)).maxHealth == 0 || this.getDriveableData().parts.get((Object)((Object)part)).health > 0;
    }

    public abstract boolean hasMouseControlMode();

    public abstract String getBombInventoryName();

    public boolean rotateWithTurret(Seat seat) {
        return seat.part == EnumDriveablePart.turret;
    }

    public String an() {
        return this.getDriveableType().name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat == 0 ? !FlansModClient.controlModeMouse : true;
    }

    @Override
    public void destroyCraft() {
    }

    @Override
    public int doDamage(int damage) {
        DriveablePart core = this.getDriveableData().parts.get((Object)EnumDriveablePart.core);
        core.health -= damage;
        this.checkParts();
        return core.health;
    }

    @Override
    public boolean canBeTargeted(Object entity) {
        DriveableType type = this.getDriveableType();
        return type.onRadar;
    }
}

