/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.ItemPart;
import co.uk.flansmods.common.ItemTool;
import co.uk.flansmods.common.driveables.DriveableData;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.driveables.PilotGun;
import co.uk.flansmods.common.driveables.PlaneType;
import co.uk.flansmods.common.driveables.Propeller;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EntityBullet;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.network.PacketPlaySound;
import co.uk.flansmods.common.network.PacketVehicleControl;
import co.uk.flansmods.common.network.PacketVehicleKey;
import co.uk.flansmods.common.vector.Vector3f;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EntityPlane
extends EntityDriveable {
    public float flapsYaw;
    public float flapsPitchLeft;
    public float flapsPitchRight;
    public int soundPosition;
    public float propAngle;
    public int bombDelay;
    public int gunDelay;
    public int ticksSinceUsed = 0;
    public boolean varGear = true;
    public boolean varDoor = false;
    public boolean varWing = false;
    public int toggleTimer = 0;

    public EntityPlane(abw world) {
        super(world);
    }

    public EntityPlane(abw world, double x, double y, double z, PlaneType type, DriveableData data) {
        super(world, type, data);
        this.b(x, y, z);
        this.initType(type, false);
    }

    public EntityPlane(abw world, double x, double y, double z, uf placer, PlaneType type, DriveableData data) {
        this(world, x, y, z, type, data);
        this.rotateYaw(placer.A + 90.0f);
        this.rotatePitch(type.restingPitch);
    }

    @Override
    protected void b(by tag) {
        super.b(tag);
        tag.a("VarGear", this.varGear);
        tag.a("VarDoor", this.varDoor);
        tag.a("VarWing", this.varWing);
    }

    @Override
    protected void a(by tag) {
        super.a(tag);
        this.varGear = tag.n("VarGear");
        this.varDoor = tag.n("VarDoor");
        this.varWing = tag.n("VarWing");
    }

    @Override
    public void writeUpdateData(DataOutputStream out) {
        try {
            out.writeBoolean(this.varGear);
            out.writeBoolean(this.varDoor);
            out.writeBoolean(this.varWing);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readUpdateData(DataInputStream in) {
        try {
            this.varGear = in.readBoolean();
            this.varDoor = in.readBoolean();
            this.varWing = in.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            return;
        }
        if (!FlansMod.proxy.mouseControlEnabled()) {
            return;
        }
        float sensitivity = 0.02f;
        this.flapsPitchLeft -= sensitivity * (float)deltaY;
        this.flapsPitchRight -= sensitivity * (float)deltaY;
        this.flapsPitchLeft -= sensitivity * (float)deltaX;
        this.flapsPitchRight += sensitivity * (float)deltaX;
    }

    public boolean c(uf entityplayer) {
        if (this.M) {
            return false;
        }
        if (this.q.I) {
            return false;
        }
        ye currentItem = entityplayer.by();
        if (currentItem != null && currentItem.b() instanceof ItemTool && ((ItemTool)currentItem.b()).type.healDriveables) {
            return true;
        }
        PlaneType type = this.getPlaneType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].c(entityplayer)) continue;
            if (i == 0) {
                this.bombDelay = type.planeBombDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, uf player) {
        PlaneType type = this.getPlaneType();
        if (this.q.I && (key == 6 || key == 8 || key == 9)) {
            PacketDispatcher.sendPacketToServer((ey)PacketVehicleKey.buildKeyPacket(key));
            return true;
        }
        switch (key) {
            case 0: {
                this.throttle += 0.01f;
                if (this.throttle > 1.0f) {
                    this.throttle = 1.0f;
                }
                return true;
            }
            case 1: {
                this.throttle -= 0.01f;
                if (this.throttle < -1.0f) {
                    this.throttle = -1.0f;
                }
                if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                    this.throttle = 0.0f;
                }
                return true;
            }
            case 2: {
                this.flapsYaw -= 1.0f;
                return true;
            }
            case 3: {
                this.flapsYaw += 1.0f;
                return true;
            }
            case 4: {
                this.flapsPitchLeft += 1.0f;
                this.flapsPitchRight += 1.0f;
                return true;
            }
            case 5: {
                this.flapsPitchLeft -= 1.0f;
                this.flapsPitchRight -= 1.0f;
                return true;
            }
            case 6: {
                this.seats[0].n.a(null);
                return true;
            }
            case 7: {
                if (this.q.I && (type.invInflight || Math.abs(this.throttle) < 0.1f && this.F)) {
                    FlansMod.proxy.openDriveableMenu((uf)this.seats[0].n, this.q, this);
                }
                return true;
            }
            case 8: {
                if (!this.q.I && this.bombDelay <= 0 && FlansMod.bombsEnabled) {
                    int slot = -1;
                    boolean bombType = false;
                    for (int i = this.driveableData.getBombInventoryStart(); i < this.driveableData.getBombInventoryStart() + type.numBombSlots; ++i) {
                        ye bomb = this.driveableData.a(i);
                        if (bomb == null || !(bomb.b() instanceof ItemBullet) || !((ItemBullet)bomb.b()).type.isBomb) continue;
                        slot = i;
                    }
                    if (slot != -1) {
                        atc bombVec = this.rotate(type.bombPosition).toVec3();
                        this.q.d((nn)new EntityBullet(this.q, bombVec.c(this.u, this.v, this.w), this.axes.getYaw(), this.axes.getPitch(), this.x, this.y, this.z, (of)((og)this.n), 1.0f, ((ItemBullet)this.driveableData.a((int)slot).b()).type, type));
                        if (type.shootSecondarySound != null) {
                            PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)50.0, (int)this.ar, (ey)PacketPlaySound.buildSoundPacket(this.u, this.v, this.w, type.shootSecondarySound, false));
                        }
                        if (!((uf)this.seats[0].n).bG.d) {
                            this.driveableData.a(slot, 1);
                        }
                        this.bombDelay = type.planeBombDelay;
                    }
                    return true;
                }
                return false;
            }
            case 9: {
                if (!this.q.I && this.gunDelay <= 0 && FlansMod.bulletsEnabled) {
                    for (PilotGun gun : this.getDriveableType().guns) {
                        BulletType bullet;
                        GunType gunType = gun.type;
                        ye bulletItemStack = this.driveableData.ammo[this.getDriveableType().numPassengerGunners + gun.gunID];
                        if (gunType == null || bulletItemStack == null || !(bulletItemStack.b() instanceof ItemBullet) || !gunType.isAmmo(bullet = ((ItemBullet)bulletItemStack.b()).type)) continue;
                        Vector3f gunVec = this.rotate(gun.position);
                        this.q.d((nn)new EntityBullet(this.q, Vector3f.add(gunVec, new Vector3f((float)this.u, (float)this.v, (float)this.w), null), this.axes.getXAxis(), (of)((og)this.n), gunType.bulletSpread / 2.0f, gunType.damage, bullet, 2.0f, (InfoType)type));
                        PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)50.0, (int)this.ar, (ey)PacketPlaySound.buildSoundPacket(this.u, this.v, this.w, type.shootMainSound, false));
                        int damage = bulletItemStack.k();
                        bulletItemStack.b(damage + 1);
                        if (damage + 1 == bulletItemStack.l()) {
                            bulletItemStack.b(0);
                            if (!((uf)this.seats[0].n).bG.d) {
                                --bulletItemStack.b;
                                if (bulletItemStack.b <= 0) {
                                    bulletItemStack = null;
                                }
                                this.driveableData.a(this.getDriveableType().numPassengerGunners + gun.gunID, bulletItemStack);
                            }
                        }
                        this.gunDelay = type.planeShootDelay;
                    }
                    return true;
                }
                return false;
            }
            case 10: {
                FlansMod.proxy.changeControlMode((uf)this.seats[0].n);
                return true;
            }
            case 11: {
                this.flapsPitchLeft += 1.0f;
                this.flapsPitchRight -= 1.0f;
                return true;
            }
            case 12: {
                this.flapsPitchLeft -= 1.0f;
                this.flapsPitchRight += 1.0f;
                return true;
            }
            case 13: {
                if (this.toggleTimer <= 0) {
                    this.varGear = !this.varGear;
                    player.a("Landing gear " + (this.varGear ? "down" : "up"));
                    this.toggleTimer = 10;
                    PacketDispatcher.sendPacketToServer((ey)PacketVehicleControl.buildUpdatePacket(this));
                }
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.a("Doors " + (this.varDoor ? "open" : "closed"));
                    }
                    this.toggleTimer = 10;
                    PacketDispatcher.sendPacketToServer((ey)PacketVehicleControl.buildUpdatePacket(this));
                }
                return true;
            }
            case 15: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varWing = !this.varWing;
                    if (type.hasWing) {
                        player.a("Toggling wings");
                    }
                    this.toggleTimer = 10;
                    PacketDispatcher.sendPacketToServer((ey)PacketVehicleControl.buildUpdatePacket(this));
                }
                return true;
            }
            case 16: {
                this.applyTorque(new Vector3f(this.axes.getRoll() / 10.0f, 0.0f, 0.0f));
                return true;
            }
        }
        return false;
    }

    @Override
    public void l_() {
        super.l_();
        PlaneType type = this.getPlaneType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Plane type null. Not ticking plane");
            return;
        }
        boolean thePlayerIsDrivingThis = this.q.I && this.seats[0] != null && this.seats[0].n instanceof uf && FlansMod.proxy.isThePlayer((uf)this.seats[0].n);
        ++this.ticksSinceUsed;
        if (!this.q.I && this.seats[0].n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.q.I && FlansMod.planeLife > 0 && this.ticksSinceUsed > FlansMod.planeLife * 20) {
            this.x();
        }
        if (this.bombDelay > 0) {
            --this.bombDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.hasEnoughFuel()) {
            this.propAngle += this.throttle / 7.0f;
        }
        this.flapsYaw *= 0.9f;
        this.flapsPitchLeft *= 0.9f;
        this.flapsPitchRight *= 0.9f;
        if (this.flapsYaw > 20.0f) {
            this.flapsYaw = 20.0f;
        }
        if (this.flapsYaw < -20.0f) {
            this.flapsYaw = -20.0f;
        }
        if (this.flapsPitchRight > 20.0f) {
            this.flapsPitchRight = 20.0f;
        }
        if (this.flapsPitchRight < -20.0f) {
            this.flapsPitchRight = -20.0f;
        }
        if (this.flapsPitchLeft > 20.0f) {
            this.flapsPitchLeft = 20.0f;
        }
        if (this.flapsPitchLeft < -20.0f) {
            this.flapsPitchLeft = -20.0f;
        }
        if (this.q.I && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.u + (this.bZ - this.u) / (double)this.serverPositionTransitionTicker;
            double y = this.v + (this.ca - this.v) / (double)this.serverPositionTransitionTicker;
            double z = this.w + (this.cb - this.w) / (double)this.serverPositionTransitionTicker;
            double dYaw = ls.g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = ls.g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = ls.g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.A = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.B = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.b(x, y, z);
            this.setRotation(this.A, this.B, rotationRoll);
        }
        float sensitivityAdjust = 0.5f * type.mass / (float)Math.max(1.0, 5.0 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        float yaw = this.flapsYaw * (this.flapsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * sensitivityAdjust;
        float flapsPitch = (this.flapsPitchLeft + this.flapsPitchRight) / 2.0f;
        float pitch = flapsPitch * (flapsPitch > 0.0f ? type.lookUpModifier : type.lookDownModifier) * sensitivityAdjust;
        float flapsRoll = (this.flapsPitchRight - this.flapsPitchLeft) / 2.0f;
        float roll = flapsRoll * (flapsRoll > 0.0f ? type.rollLeftModifier : type.rollRightModifier) * sensitivityAdjust;
        this.applyTorque(this.axes.findLocalVectorGlobally(new Vector3f(-roll, yaw, -pitch)));
        float thrustFormulaCoefficient = 2.0f;
        float dragFormulaCoefficient = 10.0f;
        float gravity = 0.49050003f;
        float liftFormulaCoefficient = 1.2f * (dragFormulaCoefficient * type.drag * type.mass * gravity) / (type.lift * thrustFormulaCoefficient * type.maxThrottle * (float)type.propellers.size());
        for (Propeller propeller : type.propellers) {
            boolean canThrustCreatively;
            if (this.getDriveableData().parts.get((Object)((Object)propeller.planePart)).dead) continue;
            boolean bl = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].n instanceof uf && ((uf)this.seats[0].n).bG.d;
            if (!canThrustCreatively && !(data.fuelInTank > data.engine.fuelConsumption * this.throttle)) continue;
            float thrust = thrustFormulaCoefficient * this.throttle * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
            this.applyForce(this.axes.findLocalVectorGlobally(propeller.getPosition()), (Vector3f)this.axes.getXAxis().scale(thrust));
            if (canThrustCreatively) continue;
            data.fuelInTank -= data.engine.fuelConsumption * this.throttle;
        }
        Vector3f velocityVector = new Vector3f((float)this.x, (float)this.y, (float)this.z);
        if (velocityVector.lengthSquared() > 1.0E-7f) {
            float drag = dragFormulaCoefficient * type.drag * velocityVector.lengthSquared();
            this.applyForce(new Vector3f(), (Vector3f)velocityVector.normalise().negate().scale(drag));
        }
        velocityVector = new Vector3f((float)this.x, (float)this.y, (float)this.z);
        float xVelocity = Vector3f.dot(velocityVector, this.axes.getXAxis());
        float zVelocity = Vector3f.dot(velocityVector, this.axes.getZAxis());
        float perpendicularVelocity = xVelocity * xVelocity + zVelocity * zVelocity;
        if (velocityVector.lengthSquared() > 1.0E-7f) {
            float lift = liftFormulaCoefficient * type.lift * perpendicularVelocity;
            this.applyForce(new Vector3f(), (Vector3f)this.axes.getYAxis().scale(lift));
        }
        float gravitationalForce = type.mass * gravity;
        this.applyForce(new Vector3f(), new Vector3f(0.0f, -gravitationalForce, 0.0f));
        this.angularVelocity.scale(0.95f);
        this.moveDriveable();
        if (data.fuel != null && data.fuel.b <= 0) {
            data.fuel = null;
        }
        boolean bl = this.fuelling = data.fuel != null && data.fuelInTank < (float)type.fuelTankSize && data.fuel.b > 0 && data.fuel.b() instanceof ItemPart && ((ItemPart)data.fuel.b()).type.category == 9;
        if (this.fuelling) {
            int damage = data.fuel.k();
            data.fuel.b(damage + 1);
            data.fuelInTank += 100.0f;
            if (damage >= data.fuel.l()) {
                data.fuel.b(0);
                --data.fuel.b;
                if (data.fuel.b <= 0) {
                    data.fuel = null;
                }
            }
        }
        if (FlansMod.hooks.BuildCraftLoaded && !this.fuelling && data.fuel != null && data.fuel.b > 0) {
            if (data.fuel.a(FlansMod.hooks.BuildCraftOilBucket) && data.fuelInTank + 500.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 5000.0f;
                data.fuel = new ye(yc.ay);
            } else if (data.fuel.a(FlansMod.hooks.BuildCraftFuelBucket) && data.fuelInTank + 1000.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 10000.0f;
                data.fuel = new ye(yc.ay);
            }
        }
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.u, this.v, this.w, 50.0, this.ar, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.u, this.v, this.w, 50.0, this.ar, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (thePlayerIsDrivingThis) {
            PacketDispatcher.sendPacketToServer((ey)PacketVehicleControl.buildUpdatePacket(this));
            this.bZ = this.u;
            this.ca = this.v;
            this.cb = this.w;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.q.I && this.ac % 5 == 0) {
            PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)200.0, (int)this.ar, (ey)PacketVehicleControl.buildUpdatePacket(this));
        }
    }

    @Override
    public boolean gearDown() {
        return this.varGear;
    }

    public boolean attackEntityFrom(nb damagesource, float i, boolean doDamage) {
        if (this.q.I || this.M) {
            return true;
        }
        PlaneType type = PlaneType.getPlane(this.driveableType);
        if (damagesource.o.equals("player") && ((nc)damagesource).i().F && (this.seats[0] == null || this.seats[0].n == null)) {
            ye planeStack = new ye(type.itemID, 1, 0);
            planeStack.e = new by();
            this.driveableData.writeToNBT(planeStack.e);
            this.a(planeStack, 0.5f);
            this.x();
        }
        return true;
    }

    @Override
    public boolean canHitPart(EnumDriveablePart part) {
        return this.varGear || part != EnumDriveablePart.coreWheel && part != EnumDriveablePart.leftWingWheel && part != EnumDriveablePart.rightWingWheel && part != EnumDriveablePart.tailWheel;
    }

    @Override
    public boolean a(nb damagesource, float i) {
        return this.attackEntityFrom(damagesource, i, true);
    }

    public PlaneType getPlaneType() {
        return PlaneType.getPlane(this.driveableType);
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Bombs";
    }

    @Override
    public boolean hasMouseControlMode() {
        return true;
    }
}

