/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables;

import co.uk.flansmods.api.IControllable;
import co.uk.flansmods.client.FlansModClient;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.ItemTool;
import co.uk.flansmods.common.RotatedAxes;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.Seat;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EntityBullet;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.network.PacketPlaySound;
import co.uk.flansmods.common.network.PacketSeatUpdates;
import co.uk.flansmods.common.network.PacketVehicleKey;
import co.uk.flansmods.common.vector.Vector3f;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;

public class EntitySeat
extends nn
implements IControllable,
IEntityAdditionalSpawnData {
    @SideOnly(value=Side.CLIENT)
    public boolean foundDriveable;
    private int driveableID;
    private int seatID;
    public EntityDriveable driveable;
    @SideOnly(value=Side.CLIENT)
    public float playerRoll;
    public Seat seatInfo;
    public boolean driver;
    public RotatedAxes looking;
    public RotatedAxes prevLooking;
    public int gunDelay;
    public int soundDelay;
    private double playerPosX;
    private double playerPosY;
    private double playerPosZ;
    private float playerYaw;
    private float playerPitch;
    private double prevPlayerPosX;
    private double prevPlayerPosY;
    private double prevPlayerPosZ;
    private float prevPlayerYaw;
    private float prevPlayerPitch;

    public EntitySeat(abw world) {
        super(world);
        this.a(1.0f, 1.0f);
        this.prevLooking = new RotatedAxes();
        this.looking = new RotatedAxes();
    }

    public EntitySeat(abw world, EntityDriveable d, int id) {
        this(world);
        this.driveable = d;
        this.driveableID = d.k;
        this.seatInfo = this.driveable.getDriveableType().seats[id];
        this.driver = id == 0;
        this.b(d.u, d.v, d.w);
        this.playerPosX = this.prevPlayerPosX = this.u;
        this.playerPosY = this.prevPlayerPosY = this.v;
        this.playerPosZ = this.prevPlayerPosZ = this.w;
        this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
    }

    public void a(double x, double y, double z, float yaw, float pitch, int i) {
    }

    public void l_() {
        super.l_();
        if (this.q.I && !this.foundDriveable) {
            this.driveable = (EntityDriveable)this.q.a(this.driveableID);
            if (this.driveable == null) {
                return;
            }
            this.foundDriveable = true;
            this.driveable.seats[this.seatID] = this;
            this.seatInfo = this.driveable.getDriveableType().seats[this.seatID];
            this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
            this.prevPlayerPosX = this.u = this.driveable.u;
            this.playerPosX = this.u;
            this.prevPlayerPosY = this.v = this.driveable.v;
            this.playerPosY = this.v;
            this.prevPlayerPosZ = this.w = this.driveable.w;
            this.playerPosZ = this.w;
            this.b(this.u, this.v, this.w);
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.soundDelay > 0) {
            --this.soundDelay;
        }
        if (this.q.I) {
            if (this.driver && this.n == atv.w().h && FlansModClient.controlModeMouse && this.driveable.hasMouseControlMode()) {
                this.looking = new RotatedAxes();
            }
            Vector3f xAxis = this.driveable.axes.findLocalAxesGlobally(this.looking).getXAxis();
            Vector3f yAxis = this.driveable.axes.findLocalAxesGlobally(this.looking).getYAxis();
            Vector3f zAxis = this.driveable.axes.findLocalAxesGlobally(this.looking).getZAxis();
            Vector3f yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, this.n == null ? 0.0f : (float)this.n.X(), 0.0f));
            for (int i = 0; i < 10; ++i) {
            }
        }
    }

    public void updatePosition() {
        if (this.q.I && !this.foundDriveable) {
            return;
        }
        this.prevPlayerPosX = this.playerPosX;
        this.prevPlayerPosY = this.playerPosY;
        this.prevPlayerPosZ = this.playerPosZ;
        this.prevPlayerYaw = this.playerYaw;
        this.prevPlayerPitch = this.playerPitch;
        Vector3f localPosition = new Vector3f((float)this.seatInfo.x / 16.0f, (float)this.seatInfo.y / 16.0f, (float)this.seatInfo.z / 16.0f);
        if (this.driver) {
            RotatedAxes yawOnlyLooking = new RotatedAxes(this.looking.getYaw(), 0.0f, 0.0f);
            Vector3f rotatedOffset = yawOnlyLooking.findLocalVectorGlobally(this.driveable.getDriveableType().rotatedDriverOffset);
            Vector3f.add(localPosition, new Vector3f(rotatedOffset.x, 0.0f, rotatedOffset.z), localPosition);
        }
        Vector3f relativePosition = this.driveable.axes.findLocalVectorGlobally(localPosition);
        this.b(this.driveable.u + (double)relativePosition.x, this.driveable.v + (double)relativePosition.y, this.driveable.w + (double)relativePosition.z);
        if (this.n != null) {
            DriveableType type = this.driveable.getDriveableType();
            atc yOffset = this.driveable.rotate(0.0, this.n.X(), 0.0).toVec3();
            this.playerPosX = this.u + yOffset.c;
            this.playerPosY = this.v + yOffset.d;
            this.playerPosZ = this.w + yOffset.e;
            this.n.U = this.n.r = this.prevPlayerPosX;
            this.n.V = this.n.s = this.prevPlayerPosY;
            this.n.W = this.n.t = this.prevPlayerPosZ;
            this.n.b(this.playerPosX, this.playerPosY, this.playerPosZ);
            RotatedAxes globalLookAxes = this.driveable.axes.findLocalAxesGlobally(this.looking);
            this.playerYaw = -90.0f + globalLookAxes.getYaw();
            this.playerPitch = globalLookAxes.getPitch();
            double dYaw = this.playerYaw - this.prevPlayerYaw;
            if (dYaw > 180.0) {
                this.prevPlayerYaw += 360.0f;
            }
            if (dYaw < -180.0) {
                this.prevPlayerYaw -= 360.0f;
            }
            if (this.n instanceof uf) {
                this.n.C = this.prevPlayerYaw;
                this.n.D = this.prevPlayerPitch;
                this.n.A = this.playerYaw;
                this.n.B = this.playerPitch;
            }
            if (this.q.I) {
                this.playerRoll = -globalLookAxes.getRoll();
            }
        }
    }

    public void W() {
        if (this.n instanceof uf) {
            this.n.A = this.playerYaw;
            this.n.B = this.playerPitch;
            this.n.C = this.prevPlayerYaw;
            this.n.D = this.prevPlayerPitch;
        }
        this.n.U = this.n.r = this.prevPlayerPosX;
        this.n.V = this.n.s = this.prevPlayerPosY;
        this.n.W = this.n.t = this.prevPlayerPosZ;
    }

    public boolean L() {
        return !this.M;
    }

    protected void a() {
    }

    public float S() {
        return 4.0f;
    }

    protected void a(by tags) {
    }

    protected void b(by tags) {
    }

    public boolean d(by tags) {
        return false;
    }

    public boolean c(by tags) {
        return false;
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
        if (!this.foundDriveable) {
            return;
        }
        this.prevLooking = this.looking.clone();
        if (this.driver) {
            this.driveable.onMouseMoved(deltaX, deltaY);
        }
        if (!(this.driver && FlansModClient.controlModeMouse && this.driveable.hasMouseControlMode())) {
            float lookSpeed = 4.0f;
            float newPitch = this.looking.getPitch() - (float)deltaY / lookSpeed * atv.w().u.c;
            if (newPitch > -this.seatInfo.minPitch) {
                newPitch = -this.seatInfo.minPitch;
            }
            if (newPitch < -this.seatInfo.maxPitch) {
                newPitch = -this.seatInfo.maxPitch;
            }
            float newYaw = this.looking.getYaw() + (float)deltaX / lookSpeed * atv.w().u.c;
            float otherNewYaw = newYaw - 360.0f;
            if (newYaw < 0.0f) {
                otherNewYaw = newYaw + 360.0f;
            }
            if (!(newYaw >= this.seatInfo.minYaw && newYaw <= this.seatInfo.maxYaw || otherNewYaw >= this.seatInfo.minYaw && otherNewYaw <= this.seatInfo.maxYaw)) {
                float otherNewYawDistFromRange;
                float newYawDistFromRange = Math.min(Math.abs(newYaw - this.seatInfo.minYaw), Math.abs(newYaw - this.seatInfo.maxYaw));
                if (newYawDistFromRange <= (otherNewYawDistFromRange = Math.min(Math.abs(otherNewYaw - this.seatInfo.minYaw), Math.abs(otherNewYaw - this.seatInfo.maxYaw)))) {
                    if (newYaw > this.seatInfo.maxYaw) {
                        newYaw = this.seatInfo.maxYaw;
                    }
                    if (newYaw < this.seatInfo.minYaw) {
                        newYaw = this.seatInfo.minYaw;
                    }
                } else {
                    if (otherNewYaw > this.seatInfo.maxYaw) {
                        otherNewYaw = this.seatInfo.maxYaw;
                    }
                    if (otherNewYaw < this.seatInfo.minYaw) {
                        otherNewYaw = this.seatInfo.minYaw;
                    }
                    newYaw = newYaw < 0.0f ? otherNewYaw - 360.0f : otherNewYaw + 360.0f;
                }
            }
            this.looking.setAngles(newYaw, newPitch, 0.0f);
            PacketDispatcher.sendPacketToServer((ey)PacketSeatUpdates.buildUpdatePacket(this));
        }
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if ((!this.q.I || this.foundDriveable) && this.driver) {
            this.driveable.updateKeyHeldState(key, held);
        }
    }

    @Override
    public boolean pressKey(int key, uf player) {
        if (this.q.I && !this.foundDriveable) {
            return false;
        }
        if (this.driver) {
            return this.driveable.pressKey(key, player);
        }
        if (key == 6) {
            if (this.q.I) {
                PacketDispatcher.sendPacketToServer((ey)PacketVehicleKey.buildKeyPacket(key));
            } else {
                this.n.a(null);
            }
            return true;
        }
        if (key == 9) {
            if (this.q.I) {
                PacketDispatcher.sendPacketToServer((ey)PacketVehicleKey.buildKeyPacket(key));
                Vector3f shootVec = this.driveable.axes.findLocalVectorGlobally(this.looking.getXAxis());
                Vector3f yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, (float)player.X(), 0.0f));
                for (int i = 0; i < 10; ++i) {
                }
            } else if (this.gunDelay <= 0 && FlansMod.bulletsEnabled) {
                BulletType bullet;
                GunType gun = this.seatInfo.gunType;
                ye bulletItemStack = this.driveable.getDriveableData().ammo[this.seatInfo.gunnerID];
                if (gun != null && bulletItemStack != null && bulletItemStack.b() instanceof ItemBullet && gun.isAmmo(bullet = ((ItemBullet)bulletItemStack.b()).type)) {
                    RotatedAxes globalLookAxes = this.driveable.axes.findLocalAxesGlobally(this.looking);
                    Vector3f shootVec = this.driveable.axes.findLocalVectorGlobally(this.looking.getXAxis());
                    Vector3f yOffset = this.driveable.axes.findLocalVectorGlobally(new Vector3f(0.0f, (float)player.Y(), 0.0f));
                    this.q.d((nn)new EntityBullet(this.q, Vector3f.add(yOffset, new Vector3f((float)this.u, (float)this.v, (float)this.w), null), shootVec, (of)this.n, gun.bulletSpread, gun.damage, bullet, 1.0f, (InfoType)this.driveable.getDriveableType()));
                    if (this.soundDelay <= 0) {
                        PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)50.0, (int)this.ar, (ey)PacketPlaySound.buildSoundPacket(this.u, this.v, this.w, gun.shootSound, false));
                        this.soundDelay = gun.shootSoundLength;
                    }
                    int damage = bulletItemStack.k();
                    bulletItemStack.b(damage + 1);
                    if (damage + 1 == bulletItemStack.l()) {
                        bulletItemStack.b(0);
                        if (!((uf)this.n).bG.d) {
                            this.driveable.getDriveableData().a(3 + this.seatID, 1);
                        }
                    }
                    this.gunDelay = gun.shootDelay;
                }
            }
        }
        return false;
    }

    public boolean c(uf entityplayer) {
        if (this.M) {
            return false;
        }
        if (this.q.I) {
            return false;
        }
        ye currentItem = entityplayer.by();
        if (currentItem != null && currentItem.b() instanceof ItemTool && ((ItemTool)currentItem.b()).type.healDriveables) {
            return true;
        }
        if (currentItem != null && currentItem.b() instanceof yg) {
            if (this.n != null && this.n instanceof og && !(this.n instanceof uf)) {
                og mob = (og)this.n;
                this.n.a(null);
                mob.b((nn)entityplayer, true);
                return true;
            }
            double checkRange = 10.0;
            List nearbyMobs = this.q.a(og.class, asx.a((double)(this.u - checkRange), (double)(this.v - checkRange), (double)(this.w - checkRange), (double)(this.u + checkRange), (double)(this.v + checkRange), (double)(this.w + checkRange)));
            for (Object obj : nearbyMobs) {
                og entity = (og)obj;
                if (!entity.bH() || entity.bI() != entityplayer) continue;
                entity.a((nn)this);
                this.looking.setAngles(-entity.A, entity.B, 0.0f);
                entity.a(true, !entityplayer.bG.d);
            }
            return true;
        }
        if (this.n == null) {
            entityplayer.a((nn)this);
            return true;
        }
        return false;
    }

    @Override
    public nn getControllingEntity() {
        return this.n;
    }

    @Override
    public boolean isDead() {
        return this.M;
    }

    public void x() {
        super.x();
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.driveableID);
        data.writeInt(this.seatInfo.id);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.driveableID = data.readInt();
        this.driveable = (EntityDriveable)this.q.a(this.driveableID);
        this.seatID = data.readInt();
        boolean bl = this.driver = this.seatID == 0;
        if (this.driveable != null) {
            this.seatInfo = this.driveable.getDriveableType().seats[this.seatID];
            this.looking.setAngles((this.seatInfo.minYaw + this.seatInfo.maxYaw) / 2.0f, 0.0f, 0.0f);
            this.prevPlayerPosX = this.u = this.driveable.u;
            this.playerPosX = this.u;
            this.prevPlayerPosY = this.v = this.driveable.v;
            this.playerPosY = this.v;
            this.prevPlayerPosZ = this.w = this.driveable.w;
            this.playerPosZ = this.w;
            this.b(this.u, this.v, this.w);
        }
    }

    public ye getPickedResult(ata target) {
        if (this.q.I && !this.foundDriveable) {
            return null;
        }
        return this.driveable.getPickedResult(target);
    }

    @Override
    public float getPlayerRoll() {
        return this.playerRoll;
    }

    @Override
    public float getCameraDistance() {
        return this.foundDriveable && this.seatID == 0 ? this.driveable.getDriveableType().cameraDistance : 5.0f;
    }

    public boolean a(nb source, float f) {
        if (this.q.I && !this.foundDriveable) {
            return false;
        }
        return this.driveable.a(source, f);
    }
}

