/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables;

import co.uk.flansmods.api.IExplodeable;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.ItemPart;
import co.uk.flansmods.common.ItemTool;
import co.uk.flansmods.common.driveables.DriveableData;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.driveables.PilotGun;
import co.uk.flansmods.common.driveables.VehicleType;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EntityBullet;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.network.PacketPlaySound;
import co.uk.flansmods.common.network.PacketVehicleControl;
import co.uk.flansmods.common.network.PacketVehicleKey;
import co.uk.flansmods.common.vector.Vector3f;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EntityVehicle
extends EntityDriveable
implements IExplodeable {
    public int shellDelay;
    public int gunDelay;
    public int soundPosition;
    public float wheelsYaw;
    private int ticksSinceUsed = 0;
    public boolean varDoor;
    public float wheelsAngle;
    public int toggleTimer = 0;

    public EntityVehicle(abw world) {
        super(world);
    }

    public EntityVehicle(abw world, double x, double y, double z, VehicleType type, DriveableData data) {
        super(world, type, data);
        this.b(x, y, z);
        this.initType(type, false);
    }

    public EntityVehicle(abw world, double x, double y, double z, uf placer, VehicleType type, DriveableData data) {
        this(world, x, y, z, type, data);
        this.rotateYaw(placer.A + 90.0f);
    }

    @Override
    protected void b(by tag) {
        super.b(tag);
        tag.a("VarDoor", this.varDoor);
    }

    @Override
    protected void a(by tag) {
        super.a(tag);
        this.varDoor = tag.n("VarDoor");
    }

    @Override
    public void writeUpdateData(DataOutputStream out) {
        try {
            out.writeBoolean(this.varDoor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readUpdateData(DataInputStream in) {
        try {
            this.varDoor = in.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    public boolean c(uf entityplayer) {
        if (this.M) {
            return false;
        }
        if (this.q.I) {
            return false;
        }
        ye currentItem = entityplayer.by();
        if (currentItem != null && currentItem.b() instanceof ItemTool && ((ItemTool)currentItem.b()).type.healDriveables) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].c(entityplayer)) continue;
            if (i == 0) {
                this.shellDelay = type.vehicleShellDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, uf player) {
        VehicleType type = this.getVehicleType();
        if (this.q.I && (key == 6 || key == 8 || key == 9)) {
            PacketDispatcher.sendPacketToServer((ey)PacketVehicleKey.buildKeyPacket(key));
            return true;
        }
        switch (key) {
            case 0: {
                this.throttle += 0.01f;
                if (this.throttle > 1.0f) {
                    this.throttle = 1.0f;
                }
                return true;
            }
            case 1: {
                this.throttle -= 0.01f;
                if (this.throttle < -1.0f) {
                    this.throttle = -1.0f;
                }
                if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                    this.throttle = 0.0f;
                }
                return true;
            }
            case 2: {
                this.wheelsYaw -= 1.0f;
                return true;
            }
            case 3: {
                this.wheelsYaw += 1.0f;
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                this.seats[0].n.a(null);
                return true;
            }
            case 7: {
                if (this.q.I) {
                    FlansMod.proxy.openDriveableMenu((uf)this.seats[0].n, this.q, this);
                }
                return true;
            }
            case 9: {
                if (!this.q.I && this.shellDelay <= 0 && FlansMod.bombsEnabled) {
                    int slot = -1;
                    for (int i = this.driveableData.getBombInventoryStart(); i < this.driveableData.getBombInventoryStart() + type.numBombSlots; ++i) {
                        ye shell = this.driveableData.a(i);
                        if (shell == null || !(shell.b() instanceof ItemBullet) || !((ItemBullet)shell.b()).type.isShell) continue;
                        slot = i;
                    }
                    if (slot != -1) {
                        boolean spread = false;
                        boolean damageMultiplier = true;
                        float shellSpeed = 3.0f;
                        this.q.d((nn)new EntityBullet(this.q, Vector3f.add(new Vector3f(this.u, this.v, this.w), this.rotate(type.barrelPosition), null), this.rotate(this.seats[0].looking.getXAxis()), (of)this.seats[0].n, (float)spread, (float)damageMultiplier, ((ItemBullet)this.driveableData.a((int)slot).b()).type, shellSpeed, (InfoType)type));
                        if (type.shootSecondarySound != null) {
                            PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)50.0, (int)this.ar, (ey)PacketPlaySound.buildSoundPacket(this.u, this.v, this.w, type.shootSecondarySound, false));
                        }
                        if (!((uf)this.seats[0].n).bG.d) {
                            this.driveableData.a(slot, 1);
                        }
                        this.shellDelay = type.vehicleShellDelay;
                    }
                    return true;
                }
                return false;
            }
            case 8: {
                if (!this.q.I && this.gunDelay <= 0 && FlansMod.bulletsEnabled) {
                    for (PilotGun gun : this.getDriveableType().guns) {
                        BulletType bullet;
                        GunType gunType = gun.type;
                        ye bulletItemStack = this.driveableData.ammo[this.getDriveableType().numPassengerGunners + gun.gunID];
                        if (gunType == null || bulletItemStack == null || !(bulletItemStack.b() instanceof ItemBullet) || !gunType.isAmmo(bullet = ((ItemBullet)bulletItemStack.b()).type)) continue;
                        Vector3f localGunVec = gun.position;
                        Vector3f lookVec = this.axes.getXAxis();
                        if (gun.driveablePart == EnumDriveablePart.turret) {
                            localGunVec = this.seats[0].looking.findLocalVectorGlobally(localGunVec);
                            lookVec = this.axes.findLocalVectorGlobally(this.seats[0].looking.getXAxis());
                        }
                        Vector3f gunVec = this.rotate(localGunVec);
                        this.q.d((nn)new EntityBullet(this.q, Vector3f.add(gunVec, new Vector3f((float)this.u, (float)this.v, (float)this.w), null), lookVec, (of)((og)this.n), gunType.bulletSpread / 2.0f, gunType.damage, bullet, 2.0f, (InfoType)type));
                        PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)50.0, (int)this.ar, (ey)PacketPlaySound.buildSoundPacket(this.u, this.v, this.w, type.shootMainSound, false));
                        int damage = bulletItemStack.k();
                        bulletItemStack.b(damage + 1);
                        if (damage + 1 == bulletItemStack.l()) {
                            bulletItemStack.b(0);
                            if (!((uf)this.seats[0].n).bG.d) {
                                --bulletItemStack.b;
                                if (bulletItemStack.b <= 0) {
                                    bulletItemStack = null;
                                }
                                this.driveableData.a(this.getDriveableType().numPassengerGunners + gun.gunID, bulletItemStack);
                            }
                        }
                        this.gunDelay = type.vehicleShootDelay;
                    }
                    return true;
                }
                return false;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.a("Doors " + (this.varDoor ? "open" : "closed"));
                    }
                    this.toggleTimer = 10;
                    PacketDispatcher.sendPacketToServer((ey)PacketVehicleControl.buildUpdatePacket(this));
                }
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                this.applyTorque(new Vector3f(this.axes.getRoll() / 10.0f, 0.0f, 0.0f));
                return true;
            }
        }
        return false;
    }

    @Override
    public void l_() {
        super.l_();
        VehicleType type = this.getVehicleType();
        if (type == null) {
            FlansMod.log("Vehicle type null. Not ticking vehicle");
            return;
        }
        boolean thePlayerIsDrivingThis = this.q.I && this.seats[0] != null && this.seats[0].n instanceof uf && FlansMod.proxy.isThePlayer((uf)this.seats[0].n);
        ++this.ticksSinceUsed;
        if (!this.q.I && this.seats[0].n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.q.I && FlansMod.vehicleLife > 0 && this.ticksSinceUsed > FlansMod.vehicleLife * 20) {
            this.x();
        }
        if (this.shellDelay > 0) {
            --this.shellDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        if (this.hasEnoughFuel()) {
            this.wheelsAngle += this.throttle / 7.0f;
        }
        this.wheelsYaw *= 0.9f;
        if (this.wheelsYaw > 20.0f) {
            this.wheelsYaw = 20.0f;
        }
        if (this.wheelsYaw < -20.0f) {
            this.wheelsYaw = -20.0f;
        }
        if (this.q.I && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.u + (this.bZ - this.u) / (double)this.serverPositionTransitionTicker;
            double y = this.v + (this.ca - this.v) / (double)this.serverPositionTransitionTicker;
            double z = this.w + (this.cb - this.w) / (double)this.serverPositionTransitionTicker;
            double dYaw = ls.g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = ls.g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = ls.g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.A = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.B = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.b(x, y, z);
            this.setRotation(this.A, this.B, rotationRoll);
        }
        float sensitivityAdjust = 1.0f * type.mass / (float)Math.max(1.0, 5.0 * Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        float yaw = this.wheelsYaw * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * sensitivityAdjust;
        this.applyTorque(this.axes.findLocalVectorGlobally(new Vector3f(0.0f, yaw, 0.0f)));
        float thrustFormulaCoefficient = 0.1f;
        float dragFormulaCoefficient = 1.0f;
        float gravity = 0.49050003f;
        float thrust = thrustFormulaCoefficient * this.throttle * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * this.getDriveableData().engine.engineSpeed;
        if (type.tank) {
            this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.leftTrack), thrust);
            this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.rightTrack), thrust);
        } else {
            this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.backLeftWheel), thrust);
            this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.backRightWheel), thrust);
            this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.backWheel), thrust);
            if (type.fourWheelDrive) {
                this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.frontLeftWheel), thrust);
                this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.frontRightWheel), thrust);
                this.applyThrust(this.getDriveableData().parts.get((Object)EnumDriveablePart.frontWheel), thrust);
            }
        }
        Vector3f velocityVector = new Vector3f((float)this.x, (float)this.y, (float)this.z);
        if (velocityVector.lengthSquared() > 1.0E-7f) {
            float drag = dragFormulaCoefficient * type.drag * velocityVector.lengthSquared();
            this.applyForce(new Vector3f(), (Vector3f)velocityVector.normalise().negate().scale(drag));
        }
        float gravitationalForce = type.mass * gravity;
        this.applyForce(new Vector3f(), new Vector3f(0.0f, -gravitationalForce, 0.0f));
        this.angularVelocity.scale(0.95f);
        this.moveDriveable();
        DriveableData data = this.getDriveableData();
        if (data.fuel != null && data.fuel.b <= 0) {
            data.fuel = null;
        }
        boolean bl = this.fuelling = data.fuel != null && data.fuelInTank < (float)type.fuelTankSize && data.fuel.b > 0 && data.fuel.b() instanceof ItemPart && ((ItemPart)data.fuel.b()).type.category == 9;
        if (this.fuelling) {
            int damage = data.fuel.k();
            data.fuel.b(damage + 1);
            data.fuelInTank += 100.0f;
            if (damage >= data.fuel.l()) {
                data.fuel.b(0);
                --data.fuel.b;
                if (data.fuel.b <= 0) {
                    data.fuel = null;
                }
            }
        }
        if (FlansMod.hooks.BuildCraftLoaded && !this.fuelling && data.fuel != null && data.fuel.b > 0) {
            if (data.fuel.a(FlansMod.hooks.BuildCraftOilBucket) && data.fuelInTank + 500.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 5000.0f;
                data.fuel = new ye(yc.ay);
            } else if (data.fuel.a(FlansMod.hooks.BuildCraftFuelBucket) && data.fuelInTank + 1000.0f <= (float)type.fuelTankSize) {
                data.fuelInTank += 10000.0f;
                data.fuel = new ye(yc.ay);
            }
        }
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.u, this.v, this.w, 50.0, this.ar, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.u, this.v, this.w, 50.0, this.ar, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (thePlayerIsDrivingThis) {
            PacketDispatcher.sendPacketToServer((ey)PacketVehicleControl.buildUpdatePacket(this));
            this.bZ = this.u;
            this.ca = this.v;
            this.cb = this.w;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.q.I && this.ac % 5 == 0) {
            PacketDispatcher.sendPacketToAllAround((double)this.u, (double)this.v, (double)this.w, (double)200.0, (int)this.ar, (ey)PacketVehicleControl.buildUpdatePacket(this));
        }
    }

    private void applyThrust(DriveablePart part, float thrust) {
        boolean canThrustCreatively;
        if (part.maxHealth > 0 && part.health <= 0) {
            return;
        }
        if (part.box == null) {
            return;
        }
        DriveableData data = this.getDriveableData();
        boolean bl = canThrustCreatively = this.seats != null && this.seats[0] != null && this.seats[0].n instanceof uf && ((uf)this.seats[0].n).bG.d;
        if (canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption * this.throttle) {
            int z;
            int y;
            Vector3f midPoint = part.box.getCentre();
            Vector3f globalMidPoint = this.axes.findLocalVectorGlobally(midPoint);
            int x = ls.c((double)(this.u + (double)globalMidPoint.x));
            if (!this.q.c(x, y = ls.c((double)(this.v + (double)globalMidPoint.y - (double)this.getVehicleType().wheelRadius)), z = ls.c((double)(this.w + (double)globalMidPoint.z)))) {
                Vector3f xAxis = this.axes.getXAxis();
                this.applyForce(globalMidPoint, (Vector3f)new Vector3f(xAxis.x, 0.0f, xAxis.z).scale(thrust));
            }
            if (!canThrustCreatively) {
                data.fuelInTank -= data.engine.fuelConsumption * this.throttle;
            }
        }
    }

    @Override
    public boolean landVehicle() {
        return true;
    }

    @Override
    public boolean a(nb damagesource, float i) {
        if (this.q.I || this.M) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        if (damagesource.o.equals("player") && ((nc)damagesource).i().F && (this.seats[0] == null || this.seats[0].n == null)) {
            ye vehicleStack = new ye(type.itemID, 1, 0);
            vehicleStack.e = new by();
            this.driveableData.writeToNBT(vehicleStack.e);
            this.a(vehicleStack, 0.5f);
            this.x();
        }
        return true;
    }

    public VehicleType getVehicleType() {
        return VehicleType.getVehicle(this.driveableType);
    }

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Shells";
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }
}

