/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.guns;

import co.uk.flansmods.client.model.ModelGun;
import co.uk.flansmods.client.model.ModelMG;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.TypeFile;
import co.uk.flansmods.common.guns.AttachmentType;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.EnumFireMode;
import co.uk.flansmods.common.guns.IScope;
import co.uk.flansmods.common.guns.ItemBullet;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;

public class GunType
extends InfoType
implements IScope {
    public List<BulletType> ammo = new ArrayList<BulletType>();
    public boolean canForceReload = true;
    public int reloadTime;
    public int recoil;
    public float bulletSpread;
    public float damage = 0.0f;
    public float meleeDamage = 1.0f;
    public float bulletSpeed = 5.0f;
    public int numBullets = 1;
    public int shootDelay = 0;
    public int numAmmoItemsInGun = 1;
    public EnumFireMode mode = EnumFireMode.FULLAUTO;
    public boolean canShootUnderwater = true;
    public String shootSound;
    public int shootSoundLength;
    public boolean distortSound = true;
    public String reloadSound;
    public boolean deployable = false;
    @SideOnly(value=Side.CLIENT)
    public ModelMG deployableModel;
    public String deployableTexture;
    public float standBackDist = 1.5f;
    public float topViewLimit = -60.0f;
    public float bottomViewLimit = 30.0f;
    public float sideViewLimit = 45.0f;
    public float pivotHeight = 0.375f;
    public String defaultScopeTexture;
    public boolean hasScopeOverlay = false;
    public float zoomLevel = 1.0f;
    public float FOVFactor = 1.5f;
    @SideOnly(value=Side.CLIENT)
    public ModelGun model;
    public float modelScale = 1.0f;
    public boolean allowAllAttachments = false;
    public ArrayList<AttachmentType> allowedAttachments = new ArrayList();
    public boolean allowBarrelAttachments = false;
    public boolean allowScopeAttachments = false;
    public boolean allowStockAttachments = false;
    public boolean allowGripAttachments = false;
    public int numGenericAttachmentSlots = 0;
    public static List<GunType> guns = new ArrayList<GunType>();

    public GunType(TypeFile file) {
        super(file);
        guns.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            BulletType type;
            if (split[0].equals("Damage")) {
                this.damage = Float.parseFloat(split[1]);
            }
            if (split[0].equals("MeleeDamage")) {
                this.meleeDamage = Float.parseFloat(split[1]);
            }
            if (split[0].equals("CanForceReload")) {
                this.canForceReload = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("ReloadTime")) {
                this.reloadTime = Integer.parseInt(split[1]);
            }
            if (split[0].equals("Recoil")) {
                this.recoil = Integer.parseInt(split[1]);
            }
            if (split[0].equals("Accuracy") || split[0].equals("Spread")) {
                this.bulletSpread = Float.parseFloat(split[1]);
            }
            if (split[0].equals("NumBullets")) {
                this.numBullets = Integer.parseInt(split[1]);
            }
            if (split[0].equals("ShootDelay")) {
                this.shootDelay = Integer.parseInt(split[1]);
            }
            if (split[0].equals("SoundLength")) {
                this.shootSoundLength = Integer.parseInt(split[1]);
            }
            if (split[0].equals("DistortSound")) {
                this.distortSound = split[1].equals("True");
            }
            if (split[0].equals("ShootSound")) {
                this.shootSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            }
            if (split[0].equals("ReloadSound")) {
                this.reloadSound = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "guns", split[1]);
            }
            if (split[0].equals("Mode")) {
                EnumFireMode enumFireMode = this.mode = split[1].equals("FullAuto") ? EnumFireMode.FULLAUTO : EnumFireMode.SEMIAUTO;
            }
            if (split[0].equals("Scope")) {
                this.hasScopeOverlay = true;
                if (split[1].equals("None")) {
                    this.hasScopeOverlay = false;
                } else {
                    this.defaultScopeTexture = split[1];
                }
            }
            if (split[0].equals("ZoomLevel")) {
                this.zoomLevel = Float.parseFloat(split[1]);
            }
            if (split[0].equals("FOVZoomLevel")) {
                this.FOVFactor = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Deployable")) {
                this.deployable = split[1].equals("True");
            }
            if (FMLCommonHandler.instance().getSide().isClient() && this.deployable && split[0].equals("DeployedModel")) {
                this.deployableModel = FlansMod.proxy.loadModel(split[1], this.shortName, ModelMG.class);
            }
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelGun.class);
            }
            if (split[0].equals("ModelScale")) {
                this.modelScale = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Texture")) {
                this.texture = split[1];
            }
            if (split[0].equals("DeployedTexture")) {
                this.deployableTexture = split[1];
            }
            if (split[0].equals("StandBackDistance")) {
                this.standBackDist = Float.parseFloat(split[1]);
            }
            if (split[0].equals("TopViewLimit")) {
                this.topViewLimit = -Float.parseFloat(split[1]);
            }
            if (split[0].equals("BottomViewLimit")) {
                this.bottomViewLimit = Float.parseFloat(split[1]);
            }
            if (split[0].equals("SideViewLimit")) {
                this.sideViewLimit = Float.parseFloat(split[1]);
            }
            if (split[0].equals("PivotHeight")) {
                this.pivotHeight = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Ammo") && (type = BulletType.getBullet(split[1])) != null) {
                this.ammo.add(type);
            }
            if (split[0].equals("NumAmmoSlots") || split[0].equals("NumAmmoItemsInGun") || split[0].equals("LoadIntoGun")) {
                this.numAmmoItemsInGun = Integer.parseInt(split[1]);
            }
            if (split[0].equals("BulletSpeed")) {
                this.bulletSpeed = Float.parseFloat(split[1]);
            }
            if (split[0].equals("CanShootUnderwater")) {
                this.canShootUnderwater = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("AllowAllAttachments")) {
                this.allowAllAttachments = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("AllowAttachments")) {
                for (int i = 1; i < split.length; ++i) {
                    this.allowedAttachments.add(AttachmentType.getAttachment(split[i]));
                }
            }
            if (split[0].equals("AllowBarrelAttachments")) {
                this.allowBarrelAttachments = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("AllowScopeAttachments")) {
                this.allowScopeAttachments = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("AllowStockAttachments")) {
                this.allowStockAttachments = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("AllowGripAttachments")) {
                this.allowGripAttachments = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("NumGenericAttachmentSlots")) {
                this.numGenericAttachmentSlots = Integer.parseInt(split[1]);
            }
        }
        catch (Exception e) {
            System.out.println("Reading gun file failed.");
            e.printStackTrace();
        }
    }

    public boolean isAmmo(BulletType type) {
        return this.ammo.contains(type);
    }

    public boolean isAmmo(ye stack) {
        if (stack == null) {
            return false;
        }
        if (stack.b() instanceof ItemBullet) {
            return this.isAmmo(((ItemBullet)stack.b()).type);
        }
        return false;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelGun.class);
    }

    @Override
    public float getZoomFactor() {
        return this.zoomLevel;
    }

    @Override
    public boolean hasZoomOverlay() {
        return this.hasScopeOverlay;
    }

    @Override
    public String getZoomOverlay() {
        return this.defaultScopeTexture;
    }

    @Override
    public float getFOVFactor() {
        return this.FOVFactor;
    }

    public IScope getCurrentScope(ye gunStack) {
        AttachmentType attachedScope = this.getScope(gunStack);
        return attachedScope == null ? this : attachedScope;
    }

    public ArrayList<AttachmentType> getCurrentAttachments(ye gun) {
        this.checkForTags(gun);
        ArrayList<AttachmentType> attachments = new ArrayList<AttachmentType>();
        by attachmentTags = gun.e.l("attachments");
        cg genericsList = attachmentTags.m("generics");
        for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
            this.appendToList(gun, "generic_" + i, attachments);
        }
        this.appendToList(gun, "barrel", attachments);
        this.appendToList(gun, "scope", attachments);
        this.appendToList(gun, "stock", attachments);
        this.appendToList(gun, "grip", attachments);
        return attachments;
    }

    private void appendToList(ye gun, String name, ArrayList<AttachmentType> attachments) {
        AttachmentType type = this.getAttachment(gun, name);
        if (type != null) {
            attachments.add(type);
        }
    }

    public AttachmentType getBarrel(ye gun) {
        return this.getAttachment(gun, "barrel");
    }

    public AttachmentType getScope(ye gun) {
        return this.getAttachment(gun, "scope");
    }

    public AttachmentType getStock(ye gun) {
        return this.getAttachment(gun, "stock");
    }

    public AttachmentType getGrip(ye gun) {
        return this.getAttachment(gun, "grip");
    }

    public AttachmentType getGeneric(ye gun, int i) {
        return this.getAttachment(gun, "generic_" + i);
    }

    public ye getBarrelItemStack(ye gun) {
        return this.getAttachmentItemStack(gun, "barrel");
    }

    public ye getScopeItemStack(ye gun) {
        return this.getAttachmentItemStack(gun, "scope");
    }

    public ye getStockItemStack(ye gun) {
        return this.getAttachmentItemStack(gun, "stock");
    }

    public ye getGripItemStack(ye gun) {
        return this.getAttachmentItemStack(gun, "grip");
    }

    public ye getGenericItemStack(ye gun, int i) {
        return this.getAttachmentItemStack(gun, "generic_" + i);
    }

    public AttachmentType getAttachment(ye gun, String name) {
        this.checkForTags(gun);
        return AttachmentType.getFromNBT(gun.e.l("attachments").l(name));
    }

    public ye getAttachmentItemStack(ye gun, String name) {
        this.checkForTags(gun);
        return ye.a((by)gun.e.l("attachments").l(name));
    }

    private void checkForTags(ye gun) {
        if (!gun.p()) {
            gun.e = new by("tag");
        }
        if (!gun.e.b("attachments")) {
            by attachmentTags = new by("attachments");
            for (int i = 0; i < this.numGenericAttachmentSlots; ++i) {
                attachmentTags.a("generic_" + i, new by());
            }
            attachmentTags.a("barrel", new by());
            attachmentTags.a("scope", new by());
            attachmentTags.a("stock", new by());
            attachmentTags.a("grip", new by());
            gun.e.a("attachments", attachmentTags);
        }
    }

    public float getMeleeDamage(ye stack) {
        float stackMeleeDamage = this.meleeDamage;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackMeleeDamage *= attachment.meleeDamageMultiplier;
        }
        return stackMeleeDamage;
    }

    public float getDamage(ye stack) {
        float stackDamage = this.damage;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackDamage *= attachment.damageMultiplier;
        }
        return stackDamage;
    }

    public float getSpread(ye stack) {
        float stackSpread = this.bulletSpread;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackSpread *= attachment.spreadMultiplier;
        }
        return stackSpread;
    }

    public float getRecoil(ye stack) {
        float stackRecoil = this.recoil;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackRecoil *= attachment.recoilMultiplier;
        }
        return stackRecoil;
    }

    public float getBulletSpeed(ye stack) {
        float stackBulletSpeed = this.bulletSpeed;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackBulletSpeed *= attachment.bulletSpeedMultiplier;
        }
        return stackBulletSpeed;
    }

    public float getReloadTime(ye stack) {
        float stackReloadTime = this.reloadTime;
        for (AttachmentType attachment : this.getCurrentAttachments(stack)) {
            stackReloadTime *= attachment.reloadTimeMultiplier;
        }
        return stackReloadTime;
    }

    public static GunType getGun(String s) {
        for (GunType gun : guns) {
            if (!gun.shortName.equals(s)) continue;
            return gun;
        }
        return null;
    }
}

