/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.network;

import co.uk.flansmods.client.GuiTeamSelect;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.network.FlanPacketCommon;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class PacketTeamSelect
extends FlanPacketCommon {
    public static final byte packetID = 6;

    public static ey buildTeamChoicesPacket(Team[] teams) {
        ea packet = new ea();
        packet.a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(6);
            data.writeBoolean(false);
            data.writeByte(teams.length);
            for (int i = 0; i < teams.length; ++i) {
                data.writeUTF(teams[i] == null ? Team.spectators.shortName : teams[i].shortName);
            }
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    public static ey buildClassChoicesPacket(PlayerClass[] classes) {
        ea packet = new ea();
        packet.a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(6);
            data.writeBoolean(true);
            data.writeByte(classes.length);
            for (int i = 0; i < classes.length; ++i) {
                data.writeUTF(classes[i].shortName);
            }
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    public static ey buildSelectionPacket(String shortName, boolean classPacket) {
        ea packet = new ea();
        packet.a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(6);
            data.writeBoolean(classPacket);
            data.writeUTF(shortName);
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    @Override
    public void interpret(DataInputStream stream, Object[] extradata, Side side) {
        if (side.equals((Object)Side.CLIENT)) {
            this.interpretClient(stream, extradata);
        }
        if (side.equals((Object)Side.SERVER)) {
            this.interpretServer(stream, extradata);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void interpretClient(DataInputStream stream, Object[] extradata) {
        try {
            boolean classPacket = stream.readBoolean();
            if (classPacket) {
                int numClasses = stream.readByte();
                PlayerClass[] classes = new PlayerClass[numClasses];
                for (int i = 0; i < numClasses; ++i) {
                    classes[i] = PlayerClass.getClass(stream.readUTF());
                }
                atv.w().a((awe)new GuiTeamSelect(classes));
            } else {
                int numTeams = stream.readByte();
                Team[] teams = new Team[numTeams];
                for (int i = 0; i < numTeams; ++i) {
                    teams[i] = Team.getTeam(stream.readUTF());
                }
                atv.w().a((awe)new GuiTeamSelect(teams));
            }
        }
        catch (Exception e) {
            FlansMod.log("Error reading packet or opening team gui");
            e.printStackTrace();
        }
    }

    public void interpretServer(DataInputStream stream, Object[] extradata) {
        try {
            jv player = (jv)extradata[0];
            boolean classPacket = stream.readBoolean();
            String choice = stream.readUTF();
            if (classPacket) {
                TeamsManager.getInstance().playerSelectedClass(player, choice);
            } else {
                TeamsManager.getInstance().playerSelectedTeam(player, choice);
            }
        }
        catch (Exception e) {
            FlansMod.log("Error reading packet or selecting team / class");
            e.printStackTrace();
        }
    }
}

