/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.network.PacketTeamSelect;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.MinecraftServer;

public abstract class Gametype {
    public static List<Gametype> gametypes = new ArrayList<Gametype>();
    public static TeamsManager teamsManager = TeamsManager.getInstance();
    public static Random rand = new Random();
    public String name;
    public String shortName;
    public int numTeamsRequired;

    public static Gametype getGametype(String type) {
        for (Gametype gametype : gametypes) {
            if (!gametype.shortName.equals(type)) continue;
            return gametype;
        }
        return null;
    }

    public Gametype(String s, String s1, int numTeams) {
        this.name = s;
        this.shortName = s1;
        this.numTeamsRequired = numTeams;
        gametypes.add(this);
    }

    public jv getPlayer(String username) {
        return MinecraftServer.a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance()).f(username);
    }

    public static FlansModPlayerData getPlayerData(jv player) {
        return FlansModPlayerHandler.getPlayerData((uf)player);
    }

    public static void sendPacketToPlayer(ey packet, jv player) {
        PacketDispatcher.sendPacketToPlayer((ey)packet, (Player)((Player)player));
    }

    public static void sendTeamsMenuToPlayer(jv player) {
        if (Gametype.teamsManager.teams == null) {
            return;
        }
        Team[] availableTeams = new Team[Gametype.teamsManager.teams.length + 1];
        for (int i = 0; i < Gametype.teamsManager.teams.length; ++i) {
            availableTeams[i] = Gametype.teamsManager.teams[i];
        }
        availableTeams[Gametype.teamsManager.teams.length] = Team.spectators;
        Gametype.getPlayerData((jv)player).team = Team.spectators;
        Gametype.sendPacketToPlayer(PacketTeamSelect.buildTeamChoicesPacket(availableTeams), player);
    }

    public static void sendClassMenuToPlayer(jv player) {
        Team team = Gametype.getPlayerData((jv)player).team;
        if (team == null) {
            Gametype.sendTeamsMenuToPlayer(player);
        } else if (team != Team.spectators && team.classes.size() > 0) {
            Gametype.sendPacketToPlayer(PacketTeamSelect.buildClassChoicesPacket(team.classes.toArray(new PlayerClass[team.classes.size()])), player);
        }
    }

    public static String[] getPlayerNames() {
        return MinecraftServer.F().C();
    }

    public static List<uf> getPlayers() {
        return MinecraftServer.F().af().a;
    }

    public static void showTeamsMenuToAll(boolean spectatorsValid) {
        for (uf player : Gametype.getPlayers()) {
            if (Gametype.getPlayerData((jv)player) == null) continue;
            if (Gametype.getPlayerData((jv)((jv)player)).team == null || !Gametype.isAValidTeam(Gametype.getPlayerData((jv)((jv)player)).team, spectatorsValid)) {
                Gametype.sendTeamsMenuToPlayer((jv)player);
                continue;
            }
            if (Gametype.getPlayerData((jv)((jv)player)).playerClass != null) continue;
            Gametype.sendClassMenuToPlayer((jv)player);
        }
    }

    public static boolean isAValidTeam(Team team, boolean spectatorsValid) {
        if (Gametype.teamsManager.teams == null) {
            return false;
        }
        if (team == Team.spectators && spectatorsValid) {
            return true;
        }
        for (Team t : Gametype.teamsManager.teams) {
            if (t != team) continue;
            return true;
        }
        return false;
    }

    public static void resetScores() {
        if (Gametype.teamsManager.teams != null) {
            for (Team team : Gametype.teamsManager.teams) {
                if (team == null) continue;
                team.score = 0;
            }
        }
        for (uf player : Gametype.getPlayers()) {
            Gametype.getPlayerData((jv)player).resetScore();
        }
    }

    public static void respawnAll() {
        for (uf player : Gametype.getPlayers()) {
            TeamsManager.getInstance().forceRespawn((jv)player);
        }
    }

    public static void givePoints(jv player, int points) {
        FlansModPlayerData data = Gametype.getPlayerData(player);
        data.score += points;
        if (data.team != null) {
            data.team.score += points;
        }
    }

    public static jv getPlayerFromDamageSource(nb source) {
        jv attacker = null;
        if (source instanceof nc && ((nc)source).i() instanceof jv) {
            attacker = (jv)((nc)source).i();
        }
        if (source instanceof nd && ((nd)source).h() instanceof jv) {
            attacker = (jv)((nd)source).h();
        }
        return attacker;
    }

    public abstract void teamsSet();

    public abstract void initGametype();

    public void startNewRound() {
        FlansModPlayerHandler.roundEnded();
        for (ITeamBase base : Gametype.teamsManager.bases) {
            base.startRound();
        }
        Gametype.respawnAll();
        for (uf player : Gametype.getPlayers()) {
            Gametype.getPlayerData((jv)((jv)player)).playerClass = null;
            Gametype.getPlayerData((jv)((jv)player)).newPlayerClass = null;
            if (Gametype.getPlayerData((jv)((jv)player)).team == null) continue;
            Gametype.getPlayerData((jv)((jv)player)).team.removePlayer(player);
        }
        Gametype.resetScores();
        TeamsManager.messageAll("\u00a7fA new round has started!");
        if (Gametype.teamsManager.teams != null) {
            for (Team team : Gametype.teamsManager.teams) {
                if (team != null) continue;
                return;
            }
            Gametype.showTeamsMenuToAll(false);
        }
    }

    public void stopGametype() {
        FlansModPlayerHandler.roundEnded();
    }

    public abstract void tick();

    public abstract void playerJoined(jv var1);

    public abstract void playerRespawned(jv var1);

    public abstract void playerQuit(jv var1);

    public abstract boolean playerChoseTeam(jv var1, Team var2, Team var3);

    public abstract boolean playerChoseClass(jv var1, PlayerClass var2);

    public abstract boolean playerAttacked(jv var1, nb var2);

    public abstract void playerKilled(jv var1, nb var2);

    public abstract void baseAttacked(ITeamBase var1, nb var2);

    public abstract void objectAttacked(ITeamObject var1, nb var2);

    public abstract void baseClickedByPlayer(ITeamBase var1, jv var2);

    public abstract void objectClickedByPlayer(ITeamObject var1, jv var2);

    public abstract atc getSpawnPoint(jv var1);

    public abstract boolean setVariable(String var1, String var2);

    public abstract void readFromNBT(by var1);

    public abstract void saveToNBT(by var1);

    public abstract boolean sortScoreboardByTeam();
}

