/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.teams.EntityFlag;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import java.util.ArrayList;

public class GametypeCTF
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int scoreLimit = 5;
    public int newRoundTimer = 0;
    public int time;
    public int autoBalanceInterval = 1200;

    public GametypeCTF() {
        super("Capture the Flag", "CTF", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void stopGametype() {
        super.stopGametype();
        GametypeCTF.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (FlansMod.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeCTF.teamsManager.teams != null) {
            for (Team team : GametypeCTF.teamsManager.teams) {
                if (team == null || team.score < this.scoreLimit || this.newRoundTimer >= 0) continue;
                TeamsManager.messageAll("\u00a7" + team.textColour + team.name + "\u00a7f won!");
                this.newRoundTimer = 200;
                TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                this.time = -300;
            }
        }
        ++this.time;
        if (this.autoBalance && this.time % this.autoBalanceInterval == this.autoBalanceInterval - 200 && this.needAutobalance()) {
            TeamsManager.messageAll("\u00a7fAutobalancing teams...");
        }
        if (this.autoBalance && this.time % this.autoBalanceInterval == 0 && this.needAutobalance()) {
            this.autobalance();
        }
    }

    public boolean needAutobalance() {
        int membersTeamB;
        if (GametypeCTF.teamsManager.teams == null || GametypeCTF.teamsManager.teams[0] == null || GametypeCTF.teamsManager.teams[1] == null) {
            return false;
        }
        int membersTeamA = GametypeCTF.teamsManager.teams[0].members.size();
        return Math.abs(membersTeamA - (membersTeamB = GametypeCTF.teamsManager.teams[1].members.size())) > 1;
    }

    public void autobalance() {
        int i;
        int membersTeamB;
        if (GametypeCTF.teamsManager.teams == null || GametypeCTF.teamsManager.teams[0] == null || GametypeCTF.teamsManager.teams[1] == null) {
            return;
        }
        int membersTeamA = GametypeCTF.teamsManager.teams[0].members.size();
        if (membersTeamA - (membersTeamB = GametypeCTF.teamsManager.teams[1].members.size()) > 1) {
            for (i = 0; i < (membersTeamA - membersTeamB) / 2; ++i) {
                GametypeCTF.sendClassMenuToPlayer(this.getPlayer(GametypeCTF.teamsManager.teams[1].addPlayer(GametypeCTF.teamsManager.teams[0].removeWorstPlayer())));
            }
        }
        if (membersTeamB - membersTeamA > 1) {
            for (i = 0; i < (membersTeamB - membersTeamA) / 2; ++i) {
                GametypeCTF.sendClassMenuToPlayer(this.getPlayer(GametypeCTF.teamsManager.teams[0].addPlayer(GametypeCTF.teamsManager.teams[1].removeWorstPlayer())));
            }
        }
    }

    @Override
    public void playerJoined(jv player) {
        GametypeCTF.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(jv player, Team team, Team previousTeam) {
        int membersOnBothTeams;
        int membersOnTeamTheyDontWantToJoin;
        int membersOnTeamTheyWantToJoin;
        if (GametypeCTF.teamsManager.teams == null || GametypeCTF.teamsManager.teams[0] == null || GametypeCTF.teamsManager.teams[1] == null) {
            return false;
        }
        if (this.autoBalance && (membersOnTeamTheyWantToJoin = team.members.size()) > (membersOnTeamTheyDontWantToJoin = (membersOnBothTeams = GametypeCTF.teamsManager.teams[0].members.size() + GametypeCTF.teamsManager.teams[1].members.size()) - membersOnTeamTheyWantToJoin)) {
            return false;
        }
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeCTF.isAValidTeam(previousTeam, true)) {
            ++GametypeCTF.getPlayerData((jv)player).deaths;
            --GametypeCTF.getPlayerData((jv)player).score;
            GametypeCTF.getPlayerData((jv)player).playerClass = null;
            GametypeCTF.getPlayerData((jv)player).newPlayerClass = null;
        }
        GametypeCTF.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(jv player, PlayerClass playerClass) {
        Team team = GametypeCTF.getPlayerData((jv)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeCTF.getPlayerData((jv)player).newPlayerClass = playerClass;
        if (GametypeCTF.getPlayerData((jv)player).playerClass == null) {
            teamsManager.resetInventory((uf)player);
        } else {
            player.a("You will respawn with the " + playerClass.name.toLowerCase() + " class");
        }
        return true;
    }

    @Override
    public void playerQuit(jv player) {
    }

    @Override
    public boolean playerAttacked(jv player, nb source) {
        if (GametypeCTF.getPlayerData(player) == null || GametypeCTF.getPlayerData((jv)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        jv attacker = GametypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeCTF.getPlayerData(attacker) == null || GametypeCTF.getPlayerData((jv)attacker).team == null) {
                return false;
            }
            if (GametypeCTF.getPlayerData((jv)attacker).team == Team.spectators) {
                return false;
            }
            if (GametypeCTF.getPlayerData((jv)player).team == GametypeCTF.getPlayerData((jv)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GametypeCTF.getPlayerData((jv)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(jv player, nb source) {
        jv attacker = GametypeCTF.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeCTF.getPlayerData((jv)player).score;
            } else {
                ++GametypeCTF.getPlayerData((jv)attacker).score;
                ++GametypeCTF.getPlayerData((jv)attacker).kills;
            }
        } else {
            --GametypeCTF.getPlayerData((jv)player).score;
        }
        ++GametypeCTF.getPlayerData((jv)player).deaths;
        for (Team team : GametypeCTF.teamsManager.teams) {
            for (ITeamBase base : team.bases) {
                ITeamObject obj = base.getFlag();
            }
        }
    }

    @Override
    public void baseAttacked(ITeamBase base, nb source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, nb source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, jv player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, jv player) {
        Team team;
        EntityFlag flag;
        if (object instanceof EntityFlag && (flag = (EntityFlag)object).getBase().getOwner() != null && flag.getBase().getOwner() != Team.spectators && (team = GametypeCTF.getPlayerData((jv)player).team) != null && team != Team.spectators) {
            if (team == flag.getBase().getOwner()) {
                EntityFlag otherFlag;
                if (flag.o == null && !flag.isHome) {
                    flag.reset();
                    TeamsManager.messageAll("\u00a7f" + player.bu + " returned the \u00a7" + flag.getBase().getOwner().textColour + flag.getBase().getOwner().name + "\u00a7f flag");
                } else if (player.n instanceof EntityFlag && (otherFlag = (EntityFlag)player.n).getBase().getOwner() != null && otherFlag.getBase().getOwner() != team && otherFlag.getBase().getOwner() != Team.spectators && flag.isHome && this.newRoundTimer <= 0) {
                    ++team.score;
                    otherFlag.reset();
                    TeamsManager.messageAll("\u00a7f" + player.bu + " captured the \u00a7" + otherFlag.getBase().getOwner().textColour + otherFlag.getBase().getOwner().name + "\u00a7f flag");
                }
            } else if (flag.o == player) {
                flag.a(null);
                TeamsManager.messageAll("\u00a7f" + player.bu + " dropped the \u00a7" + flag.getBase().getOwner().textColour + flag.getBase().getOwner().name + "\u00a7f flag");
            } else if (flag.o == null) {
                flag.a((nn)player);
                TeamsManager.messageAll("\u00a7f" + player.bu + " picked up the \u00a7" + flag.getBase().getOwner().textColour + flag.getBase().getOwner().name + "\u00a7f flag");
                flag.isHome = false;
            }
        }
    }

    @Override
    public atc getSpawnPoint(jv player) {
        FlansModPlayerData data = GametypeCTF.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.team == null) {
            return null;
        }
        for (int j = 0; j < data.team.bases.size(); ++j) {
            ITeamBase base = data.team.bases.get(j);
            if (base.getMap() != GametypeCTF.teamsManager.currentMap) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return atc.a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(jv player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(by tags) {
        this.scoreLimit = tags.e("CTFScoreLimit");
        this.friendlyFire = tags.n("CTFFriendlyFire");
        this.autoBalance = tags.n("CTFAutoBalance");
    }

    @Override
    public void saveToNBT(by tags) {
        tags.a("CTFScoreLimit", this.scoreLimit);
        tags.a("CTFFriendlyFire", this.friendlyFire);
        tags.a("CTFAutoBalance", this.autoBalance);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }
}

