/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GametypeConquest
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int newRoundTimer = 0;
    public int time;
    public int autoBalanceInterval = 1200;
    public int baseRange = 5;
    public int captureTimerLimit = 400;
    public HashMap<Integer, Integer> captureTimers = new HashMap();

    public GametypeConquest() {
        super("Conquest (Broken)", "CON", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void stopGametype() {
        super.stopGametype();
        GametypeConquest.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (FlansMod.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeConquest.teamsManager.teams != null) {
            for (int i = 0; i < 2; ++i) {
                Team team = GametypeConquest.teamsManager.teams[i];
                if (team == null || team.bases.size() != 0 || this.newRoundTimer >= 0) continue;
                boolean teamHasPlayersAlive = false;
                for (String username : team.members) {
                    jv player = this.getPlayer(username);
                    if (player == null || player.M) continue;
                    teamHasPlayersAlive = true;
                }
                if (teamHasPlayersAlive) continue;
                Team winners = GametypeConquest.teamsManager.teams[1 - i];
                TeamsManager.messageAll("\u00a7" + winners.textColour + winners.name + "\u00a7f won!");
                this.newRoundTimer = 200;
                TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                this.time = -300;
            }
        }
        ++this.time;
        if (this.autoBalance && this.time % this.autoBalanceInterval == this.autoBalanceInterval - 200 && this.needAutobalance()) {
            TeamsManager.messageAll("\u00a7fAutobalancing teams...");
        }
        if (this.autoBalance && this.time % this.autoBalanceInterval == 0 && this.needAutobalance()) {
            this.autobalance();
        }
        for (ITeamBase base : GametypeConquest.teamsManager.bases) {
            Team baseTeam = base.getOwner();
            if (baseTeam == null || baseTeam == Team.spectators) continue;
            int captureTimer = this.captureTimers.containsKey(base.getID()) ? this.captureTimers.get(base.getID()) : 0;
            List playersNearBase = base.getWorld().a(jv.class, asx.a((double)(base.getPosX() - (double)this.baseRange), (double)(base.getPosY() - (double)this.baseRange), (double)(base.getPosZ() - (double)this.baseRange), (double)(base.getPosX() + (double)this.baseRange), (double)(base.getPosY() + (double)this.baseRange), (double)(base.getPosZ() + (double)this.baseRange)));
            ArrayList<jv> enemiesNearBase = new ArrayList<jv>();
            for (Object obj : playersNearBase) {
                jv player = (jv)obj;
                if (GametypeConquest.getPlayerData(player) == null) continue;
                Team playerTeam = GametypeConquest.getPlayerData((jv)player).team;
                if (playerTeam != baseTeam && playerTeam != Team.spectators && playerTeam != null && !player.M) {
                    enemiesNearBase.add(player);
                }
                if (playerTeam != baseTeam) continue;
                enemiesNearBase = new ArrayList();
                break;
            }
            captureTimer = enemiesNearBase.size() == 0 ? 0 : (captureTimer += enemiesNearBase.size());
            if (captureTimer >= this.captureTimerLimit) {
                Team newTeam = GametypeConquest.getPlayerData((jv)((jv)enemiesNearBase.get((int)0))).team;
                base.captureBase(newTeam);
                for (ITeamObject object : base.getObjects()) {
                    object.onBaseCapture(newTeam);
                }
                for (jv player : enemiesNearBase) {
                    GametypeConquest.getPlayerData((jv)player).score += 5;
                }
                captureTimer = 0;
            }
            this.captureTimers.put(base.getID(), captureTimer);
        }
    }

    public boolean needAutobalance() {
        int membersTeamB;
        if (GametypeConquest.teamsManager.teams == null || GametypeConquest.teamsManager.teams[0] == null || GametypeConquest.teamsManager.teams[1] == null) {
            return false;
        }
        int membersTeamA = GametypeConquest.teamsManager.teams[0].members.size();
        return Math.abs(membersTeamA - (membersTeamB = GametypeConquest.teamsManager.teams[1].members.size())) > 1;
    }

    public void autobalance() {
        int i;
        int membersTeamB;
        if (GametypeConquest.teamsManager.teams == null || GametypeConquest.teamsManager.teams[0] == null || GametypeConquest.teamsManager.teams[1] == null) {
            return;
        }
        int membersTeamA = GametypeConquest.teamsManager.teams[0].members.size();
        if (membersTeamA - (membersTeamB = GametypeConquest.teamsManager.teams[1].members.size()) > 1) {
            for (i = 0; i < (membersTeamA - membersTeamB) / 2; ++i) {
                GametypeConquest.sendClassMenuToPlayer(this.getPlayer(GametypeConquest.teamsManager.teams[1].addPlayer(GametypeConquest.teamsManager.teams[0].removeWorstPlayer())));
            }
        }
        if (membersTeamB - membersTeamA > 1) {
            for (i = 0; i < (membersTeamB - membersTeamA) / 2; ++i) {
                GametypeConquest.sendClassMenuToPlayer(this.getPlayer(GametypeConquest.teamsManager.teams[0].addPlayer(GametypeConquest.teamsManager.teams[1].removeWorstPlayer())));
            }
        }
    }

    @Override
    public void playerJoined(jv player) {
        GametypeConquest.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(jv player, Team team, Team previousTeam) {
        int membersOnBothTeams;
        int membersOnTeamTheyDontWantToJoin;
        int membersOnTeamTheyWantToJoin;
        if (this.autoBalance && (membersOnTeamTheyWantToJoin = team.members.size()) > (membersOnTeamTheyDontWantToJoin = (membersOnBothTeams = GametypeConquest.teamsManager.teams[0].members.size() + GametypeConquest.teamsManager.teams[1].members.size()) - membersOnTeamTheyWantToJoin)) {
            return false;
        }
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeConquest.isAValidTeam(previousTeam, true)) {
            ++GametypeConquest.getPlayerData((jv)player).deaths;
            --GametypeConquest.getPlayerData((jv)player).score;
            GametypeConquest.getPlayerData((jv)player).playerClass = null;
            GametypeConquest.getPlayerData((jv)player).newPlayerClass = null;
        }
        GametypeConquest.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(jv player, PlayerClass playerClass) {
        Team team = GametypeConquest.getPlayerData((jv)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeConquest.getPlayerData((jv)player).newPlayerClass = playerClass;
        if (GametypeConquest.getPlayerData((jv)player).playerClass == null) {
            teamsManager.resetInventory((uf)player);
        } else {
            player.a("You will respawn with the " + playerClass.name.toLowerCase() + " class");
        }
        return true;
    }

    @Override
    public void playerQuit(jv player) {
    }

    @Override
    public boolean playerAttacked(jv player, nb source) {
        if (GametypeConquest.getPlayerData(player) == null || GametypeConquest.getPlayerData((jv)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        jv attacker = GametypeConquest.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeConquest.getPlayerData((jv)attacker).team == Team.spectators) {
                return false;
            }
            if (GametypeConquest.getPlayerData(attacker) == null || GametypeConquest.getPlayerData((jv)attacker).team == null) {
                return false;
            }
            if (GametypeConquest.getPlayerData((jv)player).team == GametypeConquest.getPlayerData((jv)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GametypeConquest.getPlayerData((jv)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(jv player, nb source) {
        jv attacker = GametypeConquest.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeConquest.getPlayerData((jv)player).score;
            } else {
                GametypeConquest.givePoints(attacker, 1);
                ++GametypeConquest.getPlayerData((jv)attacker).kills;
            }
        } else {
            --GametypeConquest.getPlayerData((jv)player).score;
        }
        ++GametypeConquest.getPlayerData((jv)player).deaths;
    }

    @Override
    public void baseAttacked(ITeamBase base, nb source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, nb source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, jv player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, jv player) {
    }

    @Override
    public atc getSpawnPoint(jv player) {
        FlansModPlayerData data = GametypeConquest.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.team == null) {
            return null;
        }
        for (ITeamBase base : data.team.bases) {
            for (ITeamObject object : base.getObjects()) {
                if (!object.isSpawnPoint()) continue;
                validSpawnPoints.add(object);
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return atc.a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(jv player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("capturetime")) {
            this.captureTimerLimit = Integer.parseInt(value) * 20;
            if (this.captureTimerLimit <= 0) {
                this.captureTimerLimit = 400;
            }
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(by tags) {
        this.friendlyFire = tags.n("ConqFriendlyFire");
        this.autoBalance = tags.n("ConqAutoBalance");
        this.captureTimerLimit = tags.e("ConqCaptureTime");
        if (this.captureTimerLimit <= 0) {
            this.captureTimerLimit = 400;
        }
    }

    @Override
    public void saveToNBT(by tags) {
        tags.a("ConqFriendlyFire", this.friendlyFire);
        tags.a("ConqAutoBalance", this.autoBalance);
        tags.a("ConqCaptureTime", this.captureTimerLimit);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }
}

