/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import java.util.ArrayList;

public class GametypeDM
extends Gametype {
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;

    public GametypeDM() {
        super("Deathmatch", "DM", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void startNewRound() {
        GametypeDM.respawnAll();
        for (uf player : GametypeDM.getPlayers()) {
            GametypeDM.getPlayerData((jv)((jv)player)).playerClass = null;
            GametypeDM.getPlayerData((jv)((jv)player)).newPlayerClass = null;
            if (GametypeDM.getPlayerData((jv)((jv)player)).team == null) continue;
            GametypeDM.getPlayerData((jv)((jv)player)).team.removePlayer(player);
        }
        GametypeDM.resetScores();
        TeamsManager.messageAll("\u00a7fA new round has started!");
        if (GametypeDM.teamsManager.teams != null) {
            for (Team team : GametypeDM.teamsManager.teams) {
                if (team != null) continue;
                return;
            }
            GametypeDM.showTeamsMenuToAll(false);
        }
    }

    @Override
    public void stopGametype() {
        GametypeDM.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (FlansMod.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeDM.teamsManager.teams != null) {
            for (Team team : GametypeDM.teamsManager.teams) {
                if (team == null) continue;
                for (String name : team.members) {
                    FlansModPlayerData data = FlansModPlayerHandler.getPlayerData(name);
                    if (data.score < this.scoreLimit || this.newRoundTimer >= 0) continue;
                    TeamsManager.messageAll(name + "\u00a7f won!");
                    this.newRoundTimer = 200;
                    TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                    this.time = -300;
                }
            }
        }
        ++this.time;
    }

    @Override
    public void playerJoined(jv player) {
        GametypeDM.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(jv player, Team team, Team previousTeam) {
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeDM.isAValidTeam(previousTeam, true)) {
            ++GametypeDM.getPlayerData((jv)player).deaths;
            --GametypeDM.getPlayerData((jv)player).score;
            GametypeDM.getPlayerData((jv)player).playerClass = null;
            GametypeDM.getPlayerData((jv)player).newPlayerClass = null;
        }
        GametypeDM.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(jv player, PlayerClass playerClass) {
        Team team = GametypeDM.getPlayerData((jv)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeDM.getPlayerData((jv)player).newPlayerClass = playerClass;
        if (GametypeDM.getPlayerData((jv)player).playerClass == null) {
            teamsManager.resetInventory((uf)player);
        } else {
            player.a("You will respawn with the " + playerClass.name.toLowerCase() + " class");
        }
        return true;
    }

    @Override
    public void playerQuit(jv player) {
    }

    @Override
    public boolean playerAttacked(jv player, nb source) {
        if (GametypeDM.getPlayerData(player) == null || GametypeDM.getPlayerData((jv)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        jv attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeDM.getPlayerData(attacker) == null || GametypeDM.getPlayerData((jv)attacker).team == null) {
                return false;
            }
            if (GametypeDM.getPlayerData((jv)attacker).team == Team.spectators) {
                return false;
            }
        }
        return GametypeDM.getPlayerData((jv)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(jv player, nb source) {
        jv attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeDM.getPlayerData((jv)player).score;
            } else {
                ++GametypeDM.getPlayerData((jv)attacker).score;
                ++GametypeDM.getPlayerData((jv)attacker).kills;
            }
        } else {
            --GametypeDM.getPlayerData((jv)player).score;
        }
        ++GametypeDM.getPlayerData((jv)player).deaths;
    }

    @Override
    public void baseAttacked(ITeamBase base, nb source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, nb source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, jv player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, jv player) {
    }

    @Override
    public atc getSpawnPoint(jv player) {
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        FlansModPlayerData data = GametypeDM.getPlayerData(player);
        if (data != null && data.team == Team.spectators) {
            for (int j = 0; j < data.team.bases.size(); ++j) {
                ITeamBase base = data.team.bases.get(j);
                if (base.getMap() != GametypeDM.teamsManager.currentMap) continue;
                for (int i = 0; i < base.getObjects().size(); ++i) {
                    if (!base.getObjects().get(i).isSpawnPoint()) continue;
                    validSpawnPoints.add(base.getObjects().get(i));
                }
            }
        } else {
            for (Team team : GametypeDM.teamsManager.teams) {
                for (int j = 0; j < data.team.bases.size(); ++j) {
                    ITeamBase base = data.team.bases.get(j);
                    if (base.getMap() != GametypeDM.teamsManager.currentMap) continue;
                    for (int i = 0; i < base.getObjects().size(); ++i) {
                        if (!base.getObjects().get(i).isSpawnPoint()) continue;
                        validSpawnPoints.add(base.getObjects().get(i));
                    }
                }
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return atc.a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(jv player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(by tags) {
        this.scoreLimit = tags.e("DMScoreLimit");
    }

    @Override
    public void saveToNBT(by tags) {
        tags.a("DMScoreLimit", this.scoreLimit);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return false;
    }
}

