/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.guns.EntityDamageSourceGun;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import java.util.ArrayList;

public class GametypeNerf
extends Gametype {
    public boolean friendlyFire = false;
    public boolean autoBalance = true;
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;
    public int autoBalanceInterval = 1200;

    public GametypeNerf() {
        super("Nerf Team Deathmatch", "Nerf", 2);
    }

    @Override
    public void initGametype() {
        this.startNewRound();
    }

    @Override
    public void teamsSet() {
        this.startNewRound();
    }

    @Override
    public void stopGametype() {
        super.stopGametype();
        GametypeNerf.resetScores();
    }

    @Override
    public void tick() {
        --this.newRoundTimer;
        if (this.newRoundTimer == 0) {
            if (FlansMod.useRotation) {
                TeamsManager.getInstance().switchToNextGametype();
                return;
            }
            this.startNewRound();
        }
        if (GametypeNerf.teamsManager.teams != null) {
            for (Team team : GametypeNerf.teamsManager.teams) {
                if (team == null || team.score < this.scoreLimit || this.newRoundTimer >= 0) continue;
                TeamsManager.messageAll("\u00a7" + team.textColour + team.name + "\u00a7f won!");
                this.newRoundTimer = 200;
                TeamsManager.messageAll("\u00a7fThe next round will start in 10 seconds");
                this.time = -300;
            }
        }
        ++this.time;
        if (this.autoBalance && this.time % this.autoBalanceInterval == this.autoBalanceInterval - 200 && this.needAutobalance()) {
            TeamsManager.messageAll("\u00a7fAutobalancing teams...");
        }
        if (this.autoBalance && this.time % this.autoBalanceInterval == 0 && this.needAutobalance()) {
            this.autobalance();
        }
    }

    public boolean needAutobalance() {
        int membersTeamB;
        if (GametypeNerf.teamsManager.teams == null || GametypeNerf.teamsManager.teams[0] == null || GametypeNerf.teamsManager.teams[1] == null) {
            return false;
        }
        int membersTeamA = GametypeNerf.teamsManager.teams[0].members.size();
        return Math.abs(membersTeamA - (membersTeamB = GametypeNerf.teamsManager.teams[1].members.size())) > 1;
    }

    public void autobalance() {
        int i;
        int membersTeamB;
        if (GametypeNerf.teamsManager.teams == null || GametypeNerf.teamsManager.teams[0] == null || GametypeNerf.teamsManager.teams[1] == null) {
            return;
        }
        int membersTeamA = GametypeNerf.teamsManager.teams[0].members.size();
        if (membersTeamA - (membersTeamB = GametypeNerf.teamsManager.teams[1].members.size()) > 1) {
            for (i = 0; i < (membersTeamA - membersTeamB) / 2; ++i) {
                GametypeNerf.sendClassMenuToPlayer(this.getPlayer(GametypeNerf.teamsManager.teams[1].addPlayer(GametypeNerf.teamsManager.teams[0].removeWorstPlayer())));
            }
        }
        if (membersTeamB - membersTeamA > 1) {
            for (i = 0; i < (membersTeamB - membersTeamA) / 2; ++i) {
                GametypeNerf.sendClassMenuToPlayer(this.getPlayer(GametypeNerf.teamsManager.teams[0].addPlayer(GametypeNerf.teamsManager.teams[1].removeWorstPlayer())));
            }
        }
    }

    @Override
    public void playerJoined(jv player) {
        GametypeNerf.sendTeamsMenuToPlayer(player);
    }

    @Override
    public boolean playerChoseTeam(jv player, Team team, Team previousTeam) {
        int membersOnBothTeams;
        int membersOnTeamTheyDontWantToJoin;
        int membersOnTeamTheyWantToJoin;
        if (GametypeNerf.teamsManager.teams == null || GametypeNerf.teamsManager.teams[0] == null || GametypeNerf.teamsManager.teams[1] == null) {
            return false;
        }
        if (this.autoBalance && (membersOnTeamTheyWantToJoin = team.members.size()) > (membersOnTeamTheyDontWantToJoin = (membersOnBothTeams = GametypeNerf.teamsManager.teams[0].members.size() + GametypeNerf.teamsManager.teams[1].members.size()) - membersOnTeamTheyWantToJoin)) {
            return false;
        }
        if (previousTeam != null && previousTeam != Team.spectators && previousTeam != team && GametypeNerf.isAValidTeam(previousTeam, true)) {
            ++GametypeNerf.getPlayerData((jv)player).deaths;
            --GametypeNerf.getPlayerData((jv)player).score;
            GametypeNerf.getPlayerData((jv)player).playerClass = null;
            GametypeNerf.getPlayerData((jv)player).newPlayerClass = null;
        }
        GametypeNerf.sendClassMenuToPlayer(player);
        if (team != previousTeam) {
            teamsManager.forceRespawn(player);
        }
        return true;
    }

    @Override
    public boolean playerChoseClass(jv player, PlayerClass playerClass) {
        Team team = GametypeNerf.getPlayerData((jv)player).team;
        if (!team.classes.contains(playerClass)) {
            return false;
        }
        GametypeNerf.getPlayerData((jv)player).newPlayerClass = playerClass;
        if (GametypeNerf.getPlayerData((jv)player).playerClass == null) {
            teamsManager.resetInventory((uf)player);
        } else {
            player.a("You will respawn with the " + playerClass.name.toLowerCase() + " class");
        }
        return true;
    }

    @Override
    public void playerQuit(jv player) {
    }

    @Override
    public boolean playerAttacked(jv player, nb source) {
        if (GametypeNerf.getPlayerData(player) == null || GametypeNerf.getPlayerData((jv)player).team == null) {
            return false;
        }
        if (this.newRoundTimer > 0) {
            return false;
        }
        if (GametypeNerf.getPlayerData((jv)player).out) {
            return false;
        }
        if (GametypeNerf.getPlayerData((jv)player).team == Team.spectators) {
            return false;
        }
        jv attacker = GametypeNerf.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeNerf.getPlayerData(attacker) == null || GametypeNerf.getPlayerData((jv)attacker).team == null) {
                return false;
            }
            if (GametypeNerf.getPlayerData((jv)attacker).team == Team.spectators) {
                return false;
            }
            if (GametypeNerf.getPlayerData((jv)player).team == GametypeNerf.getPlayerData((jv)attacker).team && !this.friendlyFire) {
                return false;
            }
            if (GametypeNerf.getPlayerData((jv)attacker).out) {
                return false;
            }
            if (source instanceof EntityDamageSourceGun) {
                GametypeNerf.getPlayerData((jv)player).out = true;
                GametypeNerf.givePoints(attacker, 1);
                ++GametypeNerf.getPlayerData((jv)attacker).kills;
                ++GametypeNerf.getPlayerData((jv)player).deaths;
                player.a("You are hit. Go back to base to respawn");
                attacker.a("You hit " + player.bu + ". He is out until he returns to base");
            }
        }
        return false;
    }

    @Override
    public void playerKilled(jv player, nb source) {
    }

    @Override
    public void baseAttacked(ITeamBase base, nb source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, nb source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, jv player) {
        if (GametypeNerf.getPlayerData((jv)player).out) {
            GametypeNerf.getPlayerData((jv)player).out = false;
            player.a("You are back in the game!");
        }
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, jv player) {
        if (GametypeNerf.getPlayerData((jv)player).out) {
            GametypeNerf.getPlayerData((jv)player).out = false;
            player.a("You are back in the game!");
        }
    }

    @Override
    public atc getSpawnPoint(jv player) {
        FlansModPlayerData data = GametypeNerf.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.team == null) {
            return null;
        }
        for (int j = 0; j < data.team.bases.size(); ++j) {
            ITeamBase base = data.team.bases.get(j);
            if (base.getMap() != GametypeNerf.teamsManager.currentMap) continue;
            for (int i = 0; i < base.getObjects().size(); ++i) {
                if (!base.getObjects().get(i).isSpawnPoint()) continue;
                validSpawnPoints.add(base.getObjects().get(i));
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return atc.a((double)spawnPoint.getPosX(), (double)spawnPoint.getPosY(), (double)spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(jv player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        if (variable.toLowerCase().equals("friendlyfire")) {
            this.friendlyFire = Boolean.parseBoolean(value);
            return true;
        }
        if (variable.toLowerCase().equals("autobalance")) {
            this.autoBalance = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(by tags) {
        this.scoreLimit = tags.e("TDMScoreLimit");
        this.friendlyFire = tags.n("TDMFriendlyFire");
        this.autoBalance = tags.n("TDMAutoBalance");
    }

    @Override
    public void saveToNBT(by tags) {
        tags.a("TDMScoreLimit", this.scoreLimit);
        tags.a("TDMFriendlyFire", this.friendlyFire);
        tags.a("TDMAutoBalance", this.autoBalance);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return true;
    }
}

