/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.ItemPlane;
import co.uk.flansmods.common.ItemVehicle;
import co.uk.flansmods.common.guns.BulletType;
import co.uk.flansmods.common.guns.GunType;
import co.uk.flansmods.common.guns.ItemAAGun;
import co.uk.flansmods.common.guns.ItemBullet;
import co.uk.flansmods.common.guns.ItemGun;
import co.uk.flansmods.common.network.PacketTeamInfo;
import co.uk.flansmods.common.teams.EntityGunItem;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.GametypeCTF;
import co.uk.flansmods.common.teams.GametypeConquest;
import co.uk.flansmods.common.teams.GametypeDM;
import co.uk.flansmods.common.teams.GametypeNerf;
import co.uk.flansmods.common.teams.GametypeTDM;
import co.uk.flansmods.common.teams.ITeamBase;
import co.uk.flansmods.common.teams.ITeamObject;
import co.uk.flansmods.common.teams.ItemOpStick;
import co.uk.flansmods.common.teams.ItemTeamArmour;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class TeamsManager
implements IPlayerTracker {
    public Gametype currentGametype;
    public TeamsMap currentMap;
    public Team[] teams;
    public static TeamsManager instance;
    public List<ITeamBase> bases;
    public List<ITeamObject> objects;
    public List<TeamsMap> maps;
    private int nextBaseID = 1;
    private long time;
    public List<RotationEntry> rotation;
    public int currentRotationEntry;

    public TeamsManager() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerPlayerTracker((IPlayerTracker)this);
        this.bases = new ArrayList<ITeamBase>();
        this.objects = new ArrayList<ITeamObject>();
        this.maps = new ArrayList<TeamsMap>();
        this.maps.add(TeamsMap.def);
        this.rotation = new ArrayList<RotationEntry>();
        this.currentMap = TeamsMap.def;
        new GametypeTDM();
        new GametypeConquest();
        new GametypeDM();
        new GametypeCTF();
        new GametypeNerf();
    }

    public void reset() {
        this.currentGametype = null;
        this.currentMap = TeamsMap.def;
        this.teams = null;
        this.bases = new ArrayList<ITeamBase>();
        this.objects = new ArrayList<ITeamObject>();
        this.maps = new ArrayList<TeamsMap>();
        this.maps.add(TeamsMap.def);
        this.rotation = new ArrayList<RotationEntry>();
    }

    public static TeamsManager getInstance() {
        return instance;
    }

    public void tick() {
        if (this.currentGametype != null) {
            this.currentGametype.tick();
        }
        ++this.time;
        if (this.time % 40L == 0L) {
            PacketDispatcher.sendPacketToAllPlayers((ey)PacketTeamInfo.buildInfoPacket());
        }
        for (ITeamBase base : this.bases) {
            base.tick();
        }
        for (ITeamObject object : this.objects) {
            object.tick();
        }
        for (Object obj : MinecraftServer.a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance()).a) {
            jv player = (jv)obj;
            FlansModPlayerData data = FlansModPlayerHandler.getPlayerData((uf)player);
            if (data.spawnDelay != 0) continue;
            js world = (js)player.q;
            world.q().a((nn)player, (ey)new gb((nn)player));
        }
    }

    public void switchToNextGametype() {
        FlansModPlayerHandler.roundEnded();
        this.currentRotationEntry = (this.currentRotationEntry + 1) % this.rotation.size();
        RotationEntry entry = this.rotation.get(this.currentRotationEntry);
        if (this.currentGametype != null && this.currentGametype != entry.gametype) {
            this.currentGametype.stopGametype();
        }
        this.currentGametype = entry.gametype;
        this.currentMap = entry.map;
        this.teams = entry.teams;
        this.currentGametype.initGametype();
    }

    public jv getPlayer(String username) {
        return MinecraftServer.a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance()).f(username);
    }

    public static void log(String s) {
        FlansMod.log("Teams Info : " + s);
    }

    public static void messagePlayer(jv player, String s) {
        player.a(s);
    }

    public static void messageAll(String s) {
        FlansMod.log("Teams Announcement : " + s);
        for (jv player : MinecraftServer.F().af().a) {
            player.a(s);
        }
    }

    @ForgeSubscribe
    public void onPlayerUpdate(EntityInteractEvent event) {
        if (event.entityPlayer.bn.h() != null && event.entityPlayer.bn.h().b() instanceof ItemOpStick) {
            ((ItemOpStick)event.entityPlayer.bn.h().b()).clickedEntity(event.entityPlayer.q, event.entityPlayer, event.target);
        }
    }

    @ForgeSubscribe
    public void onEntityHurt(LivingAttackEvent event) {
        if (event.entity instanceof jv && this.currentGametype != null && !this.currentGametype.playerAttacked((jv)event.entity, event.source)) {
            event.setCanceled(true);
        }
    }

    @ForgeSubscribe
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.entity instanceof jv && this.currentGametype != null) {
            ye stack;
            nn entity;
            jv killed = (jv)event.entity;
            this.currentGametype.playerKilled(killed, event.source);
            if (event.source instanceof nc && (entity = event.source.h()) instanceof uf && (stack = ((uf)entity).by()) != null && stack.b() != null && stack.b() instanceof ItemGun) {
                TeamsManager.messageAll("flanDeath." + ((ItemGun)stack.b()).type.shortName + "." + FlansModPlayerHandler.getPlayerData((uf)killed).team.textColour + event.entity.an() + "." + FlansModPlayerHandler.getPlayerData((uf)((uf)entity)).team.textColour + entity.an());
            }
        }
    }

    @ForgeSubscribe
    public void entityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof ITeamBase) {
            this.registerBase((ITeamBase)event.entity);
        }
        if (event.entity instanceof ITeamObject) {
            this.objects.add((ITeamObject)event.entity);
        }
    }

    @ForgeSubscribe
    public void playerInteracted(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && !event.entityPlayer.bG.e) {
            event.setCanceled(true);
            return;
        }
        if (event.entityPlayer.q.I) {
            return;
        }
        asp te = event.entityPlayer.q.r(event.x, event.y, event.z);
        if (te != null) {
            ye currentItem = event.entityPlayer.by();
            if (currentItem != null && currentItem.b() != null && currentItem.b() instanceof ItemOpStick) {
                if (te instanceof ITeamObject) {
                    ((ItemOpStick)currentItem.b()).clickedObject(event.entityPlayer.q, (jv)event.entityPlayer, (ITeamObject)te);
                }
                if (te instanceof ITeamBase) {
                    ((ItemOpStick)currentItem.b()).clickedBase(event.entityPlayer.q, (jv)event.entityPlayer, (ITeamBase)te);
                }
            } else if (this.currentGametype != null) {
                if (te instanceof ITeamObject) {
                    this.currentGametype.objectClickedByPlayer((ITeamObject)te, (jv)event.entityPlayer);
                }
                if (te instanceof ITeamBase) {
                    this.currentGametype.baseClickedByPlayer((ITeamBase)te, (jv)event.entityPlayer);
                }
            }
        }
    }

    @ForgeSubscribe
    public void playerDrops(PlayerDropsEvent event) {
        ye stack;
        ArrayList<ss> dropsToThrow = new ArrayList<ss>();
        if (FlansMod.weaponDrops == 2) {
            for (ss entity : event.drops) {
                stack = entity.d();
                if (stack == null || stack.b() == null || !(stack.b() instanceof ItemGun)) continue;
                EntityGunItem gunEntity = new EntityGunItem(entity);
                stack.b = 0;
                boolean alreadyAdded = false;
                for (ss check : dropsToThrow) {
                    if (((ItemGun)stack.b()).type != ((ItemGun)check.d().b()).type) continue;
                    alreadyAdded = true;
                }
                if (alreadyAdded) continue;
                event.entityPlayer.q.d((nn)gunEntity);
                dropsToThrow.add(gunEntity);
            }
        }
        for (ss entity : dropsToThrow) {
            EntityGunItem gunEntity = (EntityGunItem)entity;
            GunType gunType = ((ItemGun)gunEntity.d().b()).type;
            for (ss ammoEntity : event.drops) {
                BulletType bulletType;
                ye ammoItemstack = ammoEntity.d();
                if (ammoItemstack == null || !(ammoItemstack.b() instanceof ItemBullet) || !gunType.isAmmo(bulletType = ((ItemBullet)ammoItemstack.b()).type)) continue;
                gunEntity.ammoStacks.add(ammoItemstack.m());
                ammoItemstack.b = 0;
            }
        }
        for (ss entity : event.drops) {
            stack = entity.d();
            if (stack == null || stack.b() == null || stack.b <= 0) continue;
            if (stack.b() instanceof ItemGun || stack.b() instanceof ItemPlane || stack.b() instanceof ItemVehicle || stack.b() instanceof ItemAAGun || stack.b() instanceof ItemBullet) {
                if (FlansMod.weaponDrops == 1) continue;
                dropsToThrow.add(entity);
                continue;
            }
            if (!(stack.b() instanceof ItemTeamArmour) || FlansMod.armourDrops) continue;
            dropsToThrow.add(entity);
        }
        event.drops.removeAll(dropsToThrow);
    }

    @ForgeSubscribe
    public void playerLoot(EntityItemPickupEvent event) {
        FlansModPlayerData data = FlansModPlayerHandler.getPlayerData(event.entityPlayer);
        if (data != null && data.team == Team.spectators) {
            event.setCanceled(true);
        }
    }

    @ForgeSubscribe
    public void chunkLoaded(ChunkDataEvent event) {
        adr chunk = event.getChunk();
        for (List list : chunk.j) {
            for (nn entity : list) {
                if (entity instanceof ITeamBase) {
                    this.bases.add((ITeamBase)entity);
                    if (((ITeamBase)entity).getID() > this.nextBaseID) {
                        FlansMod.log("Loaded base with ID higher than the supposed highest ID. Adjusted highest ID");
                        this.nextBaseID = ((ITeamBase)entity).getID();
                    }
                }
                if (!(entity instanceof ITeamObject)) continue;
                this.objects.add((ITeamObject)entity);
            }
        }
    }

    @ForgeSubscribe
    public void worldData(WorldEvent event) {
        if (event.world.I) {
            return;
        }
        if (event instanceof WorldEvent.Load) {
            this.loadPerWorldData((Event)event, event.world);
            this.savePerWorldData((Event)event, event.world);
        }
        if (event instanceof WorldEvent.Save) {
            this.savePerWorldData((Event)event, event.world);
        }
    }

    private void loadPerWorldData(Event event, abw world) {
        this.reset();
        File file = new File(FMLCommonHandler.instance().getSide().isClient() ? "saves/" + MinecraftServer.F().M() : MinecraftServer.F().L(), "teams.dat");
        if (!this.checkFileExists(file)) {
            return;
        }
        try {
            int i;
            by tags = ci.a((DataInput)new DataInputStream(new FileInputStream(file)));
            this.nextBaseID = tags.e("NextBaseID");
            for (i = 0; i < tags.e("NumMaps"); ++i) {
                String shortName = tags.i("MapShortName " + i);
                if (shortName.equals("default")) continue;
                this.maps.add(new TeamsMap(shortName, tags.i("MapName " + i)));
            }
            this.currentMap = this.getTeamsMap(tags.i("Map"));
            this.currentGametype = Gametype.getGametype(tags.i("Gametype"));
            if (this.currentGametype != null) {
                this.currentGametype.initGametype();
                this.currentGametype.readFromNBT(tags);
                this.teams = new Team[this.currentGametype.numTeamsRequired];
                for (i = 0; i < this.teams.length; ++i) {
                    this.teams[i] = Team.getTeam(tags.i("Team " + i));
                }
            }
            int rotationSize = tags.e("RotationSize");
            for (int i2 = 0; i2 < rotationSize; ++i2) {
                TeamsMap map = this.getTeamsMap(tags.i("RotationMap " + i2));
                Gametype gametype = Gametype.getGametype(tags.i("RotationGametype " + i2));
                int nTeams = tags.e("RotationTeams " + i2);
                Team[] demTeams = new Team[nTeams];
                for (int j = 0; j < nTeams; ++j) {
                    demTeams[j] = Team.getTeam(tags.i("RotationTeam " + i2 + " " + j));
                }
                if (map == null || gametype == null) continue;
                this.rotation.add(new RotationEntry(map, gametype, demTeams));
            }
            FlansMod.useRotation = tags.n("UseRotation");
            FlansMod.bombsEnabled = tags.n("Bombs");
            FlansMod.bulletsEnabled = tags.n("Bullets");
            FlansMod.explosions = tags.n("Explosions");
            FlansMod.forceAdventureMode = tags.n("ForceAdventure");
            FlansMod.canBreakGuns = tags.n("CanBreakGuns");
            FlansMod.canBreakGlass = tags.n("CanBreakGlass");
            FlansMod.armourDrops = tags.n("ArmourDrops");
            FlansMod.weaponDrops = tags.e("WeaponDrops");
            FlansMod.vehiclesNeedFuel = tags.n("NeedFuel");
            FlansMod.mgLife = tags.e("MGLife");
            FlansMod.aaLife = tags.e("AALife");
            FlansMod.vehicleLife = tags.e("VehicleLife");
            FlansMod.mechaLove = tags.e("MechaLove");
            FlansMod.planeLife = tags.e("PlaneLife");
            FlansMod.driveablesBreakBlocks = tags.n("BreakBlocks");
        }
        catch (Exception e) {
            FlansMod.log("Failed to load from teams.dat");
            e.printStackTrace();
        }
    }

    private void savePerWorldData(Event event, abw world) {
        File file = new File(FMLCommonHandler.instance().getSide().isClient() ? "saves/" + MinecraftServer.F().M() : MinecraftServer.F().L(), "teams.dat");
        this.checkFileExists(file);
        try {
            by tags = new by();
            tags.a("NextBaseID", this.nextBaseID);
            tags.a("NumMaps", this.maps.size());
            if (this.maps != null) {
                for (int i = 0; i < this.maps.size(); ++i) {
                    if (this.maps.get(i) == null) continue;
                    tags.a("MapShortName " + i, this.maps.get((int)i).shortName);
                    tags.a("MapName " + i, this.maps.get((int)i).name);
                }
            }
            if (this.currentMap != null) {
                tags.a("Map", this.currentMap.shortName);
            }
            tags.a("Gametype", this.currentGametype == null ? "None" : this.currentGametype.shortName);
            for (Gametype gametype : Gametype.gametypes) {
                gametype.saveToNBT(tags);
            }
            if (this.teams != null) {
                for (int i = 0; i < this.teams.length; ++i) {
                    if (this.teams[i] == null) continue;
                    tags.a("Team " + i, this.teams[i].shortName);
                }
            }
            if (this.rotation != null) {
                tags.a("RotationSize", this.rotation.size());
                for (int i = 0; i < this.rotation.size(); ++i) {
                    RotationEntry entry = this.rotation.get(i);
                    if (entry == null) continue;
                    tags.a("RotationMap " + i, entry.map.shortName);
                    tags.a("RotationGametype " + i, entry.gametype.shortName);
                    tags.a("RotationTeams " + i, entry.teams.length);
                    for (int j = 0; j < entry.teams.length; ++j) {
                        tags.a("RotationTeam " + i + " " + j, entry.teams[j].shortName);
                    }
                }
            } else {
                tags.a("RotationSize", 0);
            }
            tags.a("UseRotation", FlansMod.useRotation);
            tags.a("Bombs", FlansMod.bombsEnabled);
            tags.a("Bullets", FlansMod.bulletsEnabled);
            tags.a("Explosions", FlansMod.explosions);
            tags.a("ForceAdventure", FlansMod.forceAdventureMode);
            tags.a("CanBreakGuns", FlansMod.canBreakGuns);
            tags.a("CanBreakGlass", FlansMod.canBreakGlass);
            tags.a("ArmourDrops", FlansMod.armourDrops);
            tags.a("WeaponDrops", FlansMod.weaponDrops);
            tags.a("NeedFuel", FlansMod.vehiclesNeedFuel);
            tags.a("MGLife", FlansMod.mgLife);
            tags.a("AALife", FlansMod.aaLife);
            tags.a("VehicleLife", FlansMod.vehicleLife);
            tags.a("MechaLove", FlansMod.mechaLove);
            tags.a("PlaneLife", FlansMod.planeLife);
            tags.a("BreakBlocks", FlansMod.driveablesBreakBlocks);
            ci.a((by)tags, (DataOutput)new DataOutputStream(new FileOutputStream(file)));
        }
        catch (Exception e) {
            FlansMod.log("Failed to save to teams.dat");
        }
    }

    private boolean checkFileExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                FlansMod.log("Failed to create file");
                FlansMod.log(file.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    public ITeamBase getBase(int ID) {
        for (ITeamBase base : this.bases) {
            if (base.getID() != ID) continue;
            return base;
        }
        return null;
    }

    public void registerBase(ITeamBase base) {
        if (base.getID() == 0) {
            base.setID(this.nextBaseID++);
        }
        this.bases.add(base);
    }

    public void registerObject(ITeamObject obj) {
        this.objects.add(obj);
    }

    public void onPlayerLogin(uf player) {
        if (player instanceof jv) {
            jv playerMP = (jv)player;
            if (this.currentGametype != null) {
                this.currentGametype.playerJoined(playerMP);
            }
        }
    }

    public void onPlayerLogout(uf player) {
        for (Team team : Team.teams) {
            team.removePlayer(player);
        }
    }

    public void onPlayerChangedDimension(uf player) {
    }

    public void onPlayerRespawn(uf player) {
        if (this.currentGametype != null) {
            jv playerMP = (jv)player;
            FlansModPlayerData data = FlansModPlayerHandler.getPlayerData((uf)playerMP);
            if (playerMP != null && data != null && data.team == Team.spectators && MinecraftServer.a((MinecraftServer)playerMP.b).e(playerMP.bu)) {
                return;
            }
            atc spawnPoint = this.currentGametype.getSpawnPoint(playerMP);
            if (spawnPoint != null) {
                player.a(new t(ls.c((double)spawnPoint.c), ls.c((double)spawnPoint.d) + 1, ls.c((double)spawnPoint.e)), true);
                data.setSpawn(spawnPoint.c, spawnPoint.d, spawnPoint.e, 5);
                playerMP.b(spawnPoint.c, spawnPoint.d, spawnPoint.e, 0.0f, 0.0f);
                if (data.playerClass != null && data.playerClass.horse) {
                    rs horse = new rs(playerMP.q);
                    by tags = new by();
                    horse.e(tags);
                    tags.a("Tame", true);
                    tags.a("Temper", 0);
                    tags.a("OwnerName", playerMP.bu);
                    tags.a("SaddleItem", (cl)new ye(yc.aC).b(new by("SaddleItem")));
                    tags.a("Type", 0);
                    tags.a("Variant", 0);
                    horse.f(tags);
                    horse.b(playerMP.u, playerMP.v, playerMP.w);
                    playerMP.q.d((nn)horse);
                    playerMP.a((nn)horse);
                }
                if (FlansMod.forceAdventureMode && player.bG.e) {
                    player.a(ace.d);
                }
                this.resetInventory(player);
            }
            this.currentGametype.playerRespawned((jv)player);
        }
    }

    public void forceRespawn(jv player) {
        player.bn.b = new ye[4];
        player.bn.a = new ye[36];
        player.f(9001.0f);
        if (FlansMod.forceAdventureMode && player.bG.e) {
            player.a(ace.d);
        }
        this.onPlayerRespawn((uf)player);
    }

    public void playerSelectedTeam(jv player, String teamName) {
        Team previousTeam = Gametype.getPlayerData((jv)player).team;
        if (previousTeam != null && previousTeam.shortName.equals(teamName)) {
            Gametype.sendClassMenuToPlayer(player);
            return;
        }
        Team team = null;
        for (Team t2 : this.teams) {
            if (t2 == null || !t2.shortName.equals(teamName)) continue;
            team = t2;
        }
        if (teamName.equals(Team.spectators.shortName)) {
            team = Team.spectators;
        }
        if (team == null) {
            team = Team.spectators;
        }
        if (team != null && this.currentGametype != null) {
            FlansModPlayerHandler.getPlayerData((uf)player).team = team;
            boolean canJoinTeam = this.currentGametype.playerChoseTeam(player, team, previousTeam);
            if (canJoinTeam) {
                team.addPlayer((uf)player);
                TeamsManager.messageAll(player.bu + " joined \u00a7" + team.textColour + team.name);
            } else {
                player.a("You may not pick that team");
                Gametype.sendTeamsMenuToPlayer(player);
            }
        }
        if (team == Team.spectators) {
            FlansModPlayerHandler.getPlayerData((uf)player).newPlayerClass = null;
            FlansModPlayerHandler.getPlayerData((uf)player).playerClass = null;
            this.resetInventory((uf)player);
            player.bG.c = true;
        } else {
            player.bG.c = false;
        }
    }

    public void playerSelectedClass(jv player, String className) {
        Team team = FlansModPlayerHandler.getPlayerData((uf)player).team;
        if (team == null) {
            return;
        }
        PlayerClass playerClass = null;
        for (PlayerClass pc : team.classes) {
            if (!pc.shortName.equals(className)) continue;
            playerClass = pc;
        }
        if (playerClass != null) {
            if (this.currentGametype != null) {
                this.currentGametype.playerChoseClass(player, playerClass);
            }
            FlansModPlayerHandler.getPlayerData((uf)player).playerClass = playerClass;
        }
    }

    public void resetInventory(uf player) {
        Team team = FlansModPlayerHandler.getPlayerData((uf)player).team;
        PlayerClass playerClass = FlansModPlayerHandler.getPlayerData(player).getPlayerClass();
        if (team == null) {
            return;
        }
        player.bn.b = new ye[4];
        player.bn.a = new ye[36];
        if (team.hat != null) {
            player.bn.b[3] = team.hat.m();
        }
        if (team.chest != null) {
            player.bn.b[2] = team.chest.m();
        }
        if (team.legs != null) {
            player.bn.b[1] = team.legs.m();
        }
        if (team.shoes != null) {
            player.bn.b[0] = team.shoes.m();
        }
        if (playerClass == null) {
            return;
        }
        for (ye stack : playerClass.startingItems) {
            player.bn.a(stack.m());
        }
        for (int i = 0; i < player.bn.j_(); ++i) {
            ye stack;
            stack = player.bn.a(i);
            if (stack == null || !(stack.b() instanceof ItemGun)) continue;
            ((ItemGun)stack.b()).reload(stack, player.q, player, true);
        }
    }

    public boolean areTeamsValid() {
        if (this.teams == null) {
            return false;
        }
        for (Team t2 : this.teams) {
            if (t2 != null) continue;
            return false;
        }
        return true;
    }

    public TeamsMap getTeamsMap(String s) {
        for (TeamsMap map : this.maps) {
            if (!map.shortName.equals(s)) continue;
            return map;
        }
        return null;
    }

    public static class RotationEntry {
        public TeamsMap map;
        public Gametype gametype;
        public Team[] teams;

        public RotationEntry(TeamsMap m, Gametype g, Team[] t) {
            this.map = m;
            this.gametype = g;
            this.teams = t;
        }
    }

    public static class TeamsMap {
        public static TeamsMap def = new TeamsMap("default", "Default");
        public String name;
        public String shortName;

        public TeamsMap(String s1, String s2) {
            this.shortName = s1;
            this.name = s2;
        }
    }
}

