/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.vector;

import co.uk.flansmods.common.vector.Vector;
import java.nio.FloatBuffer;

public class Vector3i
extends Vector {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;

    public Vector3i() {
    }

    public Vector3i(int x, int y, int z2) {
        this.set(x, y, z2);
    }

    public Vector3i(atc vec) {
        this((int)vec.c, (int)vec.d, (int)vec.e);
    }

    public Vector3i(double x, double y, double z2) {
        this((int)x, (int)y, (int)z2);
    }

    public Vector3i(Vector3i v) {
        this(v.x, v.y, v.z);
    }

    public atc toVec3() {
        return atc.a((double)this.x, (double)this.y, (double)this.z);
    }

    public void set(int x, int y, int z2) {
        this.x = x;
        this.y = y;
        this.z = z2;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3i translate(int x, int y, int z2) {
        this.x += x;
        this.y += y;
        this.z += z2;
        return this;
    }

    public static Vector3i add(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            return new Vector3i(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        dest.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return dest;
    }

    public static Vector3i sub(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            return new Vector3i(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        dest.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return dest;
    }

    public static Vector3i cross(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            dest = new Vector3i();
        }
        dest.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return dest;
    }

    @Override
    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3i negate(Vector3i dest) {
        if (dest == null) {
            dest = new Vector3i();
        }
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public Vector3i normalise(Vector3i dest) {
        float l = this.length();
        if (dest == null) {
            dest = new Vector3i((float)this.x / l, (float)this.y / l, (float)this.z / l);
        } else {
            dest.set((int)((float)this.x / l), (int)((float)this.y / l), (int)((float)this.z / l));
        }
        return dest;
    }

    public static float dot(Vector3i left, Vector3i right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    public static float angle(Vector3i a, Vector3i b) {
        float dls = Vector3i.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    @Override
    public Vector load(FloatBuffer buf) {
        this.x = (int)buf.get();
        this.y = (int)buf.get();
        this.z = (int)buf.get();
        return this;
    }

    @Override
    public Vector scale(float scale) {
        this.x = (int)((float)this.x * scale);
        this.y = (int)((float)this.y * scale);
        this.z = (int)((float)this.z * scale);
        return this;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Vector3i[");
        sb.append(this.x);
        sb.append(", ");
        sb.append(this.y);
        sb.append(", ");
        sb.append(this.z);
        sb.append(']');
        return sb.toString();
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public void setZ(int z2) {
        this.z = z2;
    }

    public int getZ() {
        return this.z;
    }
}

