/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.vector;

import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector2;

public class Vector3
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3(double x, double y, double z2) {
        this.x = x;
        this.y = y;
        this.z = z2;
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(Vector3 vector) {
        this(vector.x, vector.y, vector.z);
    }

    public Vector3(double amount) {
        this(amount, amount, amount);
    }

    public Vector3(nn par1) {
        this(par1.u, par1.v, par1.w);
    }

    public Vector3(asp par1) {
        this(par1.l, par1.m, par1.n);
    }

    public Vector3(atc par1) {
        this(par1.c, par1.d, par1.e);
    }

    public Vector3(ata par1) {
        this(par1.b, par1.c, par1.d);
    }

    public Vector3(t par1) {
        this(par1.a, par1.b, par1.c);
    }

    public Vector3(ForgeDirection direction) {
        this(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vector3(by nbt) {
        this(nbt.h("x"), nbt.h("y"), nbt.h("z"));
    }

    public Vector3(float rotationYaw, float rotationPitch) {
        this(Math.cos(Math.toRadians(rotationYaw + 90.0f)), Math.sin(Math.toRadians(-rotationPitch)), Math.sin(Math.toRadians(rotationYaw + 90.0f)));
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public float floatX() {
        return (float)this.x;
    }

    public float floatY() {
        return (float)this.y;
    }

    public float floatZ() {
        return (float)this.z;
    }

    public Vector3 clone() {
        return new Vector3(this);
    }

    public int getBlockID(acf world) {
        return world.a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(acf world) {
        return world.h(this.intX(), this.intY(), this.intZ());
    }

    public asp getTileEntity(acf world) {
        return world.r(this.intX(), this.intY(), this.intZ());
    }

    public boolean setBlock(abw world, int id, int metadata, int notify) {
        return world.f(this.intX(), this.intY(), this.intZ(), id, metadata, notify);
    }

    public boolean setBlock(abw world, int id, int metadata) {
        return this.setBlock(world, id, metadata, 3);
    }

    public boolean setBlock(abw world, int id) {
        return this.setBlock(world, id, 0);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.z);
    }

    public atc toVec3() {
        return atc.a((double)this.x, (double)this.y, (double)this.z);
    }

    public ForgeDirection toForgeDirection() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.x != (double)direction.offsetX || this.y != (double)direction.offsetY || this.z != (double)direction.offsetZ) continue;
            return direction;
        }
        return ForgeDirection.UNKNOWN;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.scale(1.0 / d);
        }
        return this;
    }

    public static double distance(Vector3 vec1, Vector3 vec2) {
        return vec1.distance(vec2);
    }

    @Deprecated
    public double distanceTo(Vector3 vector3) {
        return this.distance(vector3);
    }

    public double distance(Vector3 compare) {
        Vector3 difference = this.clone().difference(compare);
        return difference.getMagnitude();
    }

    public Vector3 invert() {
        this.scale(-1.0);
        return this;
    }

    public Vector3 translate(Vector3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
        return this;
    }

    public Vector3 translate(double par1) {
        this.x += par1;
        this.y += par1;
        this.z += par1;
        return this;
    }

    public static Vector3 translate(Vector3 translate, Vector3 par1) {
        translate.x += par1.x;
        translate.y += par1.y;
        translate.z += par1.z;
        return translate;
    }

    public static Vector3 translate(Vector3 translate, double par1) {
        translate.x += par1;
        translate.y += par1;
        translate.z += par1;
        return translate;
    }

    @Deprecated
    public Vector3 add(Vector3 amount) {
        return this.translate(amount);
    }

    @Deprecated
    public Vector3 add(double amount) {
        return this.translate(amount);
    }

    @Deprecated
    public Vector3 subtract(Vector3 amount) {
        return this.translate(amount.clone().invert());
    }

    @Deprecated
    public Vector3 subtract(double amount) {
        return this.translate(-amount);
    }

    public Vector3 difference(Vector3 amount) {
        return this.translate(amount.clone().invert());
    }

    public Vector3 difference(double amount) {
        return this.translate(-amount);
    }

    public Vector3 scale(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
        return this;
    }

    public Vector3 scale(Vector3 amount) {
        this.x *= amount.x;
        this.y *= amount.y;
        this.z *= amount.z;
        return this;
    }

    public static Vector3 scale(Vector3 vec, double amount) {
        return vec.scale(amount);
    }

    public static Vector3 scale(Vector3 vec, Vector3 amount) {
        return vec.scale(amount);
    }

    @Deprecated
    public Vector3 multiply(double amount) {
        return this.scale(amount);
    }

    @Deprecated
    public Vector3 multiply(Vector3 amount) {
        return this.scale(amount);
    }

    @Deprecated
    public static Vector3 subtract(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x - par2.x, par1.y - par2.y, par1.z - par2.z);
    }

    @Deprecated
    public static Vector3 add(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x + par2.x, par1.y + par2.y, par1.z + par2.z);
    }

    @Deprecated
    public static Vector3 add(Vector3 par1, double par2) {
        return new Vector3(par1.x + par2, par1.y + par2, par1.z + par2);
    }

    @Deprecated
    public static Vector3 multiply(Vector3 vec1, Vector3 vec2) {
        return new Vector3(vec1.x * vec2.x, vec1.y * vec2.y, vec1.z * vec2.z);
    }

    @Deprecated
    public static Vector3 multiply(Vector3 vec1, double vec2) {
        return new Vector3(vec1.x * vec2, vec1.y * vec2, vec1.z * vec2);
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 ceil() {
        return new Vector3(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public Vector3 toRound() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    public Vector3 toCeil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    public Vector3 toFloor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public List<nn> getEntitiesWithin(abw worldObj, Class<? extends nn> par1Class) {
        return worldObj.a(par1Class, asx.a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public Vector3 modifyPositionFromSide(ForgeDirection side, double amount) {
        return this.translate(new Vector3(side).scale(amount));
    }

    public Vector3 modifyPositionFromSide(ForgeDirection side) {
        this.modifyPositionFromSide(side, 1.0);
        return this;
    }

    public Vector3 toCrossProduct(Vector3 compare) {
        double newX = this.y * compare.z - this.z * compare.y;
        double newY = this.z * compare.x - this.x * compare.z;
        double newZ = this.x * compare.y - this.y * compare.x;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vector3 crossProduct(Vector3 compare) {
        return this.clone().toCrossProduct(compare);
    }

    public Vector3 xCrossProduct() {
        return new Vector3(0.0, this.z, -this.y);
    }

    public Vector3 zCrossProduct() {
        return new Vector3(-this.y, this.x, 0.0);
    }

    public double dotProduct(Vector3 vec2) {
        return this.x * vec2.x + this.y * vec2.y + this.z * vec2.z;
    }

    public Vector3 getPerpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Vector3 rotate(float angle, Vector3 axis) {
        return Vector3.translateMatrix(Vector3.getRotationMatrix(angle, axis), this.clone());
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Vector3 axis = this.clone().normalize();
        double x = axis.x;
        double y = axis.y;
        double z2 = axis.z;
        angle = (float)((double)angle * 0.0174532925);
        float cos = (float)Math.cos(angle);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angle);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z2 * (double)sin;
        matrix[2] = x * z2 * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z2 * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z2 * (double)ocos + x * (double)sin;
        matrix[8] = x * z2 * (double)ocos + y * (double)sin;
        matrix[9] = y * z2 * (double)ocos - x * (double)sin;
        matrix[10] = z2 * z2 * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public static Vector3 translateMatrix(double[] matrix, Vector3 translation) {
        double x = translation.x * matrix[0] + translation.y * matrix[1] + translation.z * matrix[2] + matrix[3];
        double y = translation.x * matrix[4] + translation.y * matrix[5] + translation.z * matrix[6] + matrix[7];
        double z2 = translation.x * matrix[8] + translation.y * matrix[9] + translation.z * matrix[10] + matrix[11];
        translation.x = x;
        translation.y = y;
        translation.z = z2;
        return translation;
    }

    public static double[] getRotationMatrix(float angle, Vector3 axis) {
        return axis.getRotationMatrix(angle);
    }

    public void rotate(double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double x = this.x;
        double y = this.y;
        double z2 = this.z;
        this.x = x * Math.cos(yawRadians) * Math.cos(pitchRadians) + z2 * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        this.z = x * Math.sin(yawRadians) * Math.cos(pitchRadians) + z2 * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        this.y = -x * Math.sin(pitchRadians) + z2 * Math.cos(pitchRadians) * Math.sin(rollRadians) + y * Math.cos(pitchRadians) * Math.cos(rollRadians);
    }

    public void rotate(double yaw, double pitch) {
        this.rotate(yaw, pitch, 0.0);
    }

    public void rotate(double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double x = this.x;
        double z2 = this.z;
        if (yaw != 0.0) {
            this.x = x * Math.cos(yawRadians) - z2 * Math.sin(yawRadians);
            this.z = x * Math.sin(yawRadians) + z2 * Math.cos(yawRadians);
        }
    }

    public static Vector3 getDeltaPositionFromRotation(float rotationYaw, float rotationPitch) {
        return new Vector3(rotationYaw, rotationPitch);
    }

    public double getAngle(Vector3 vec2) {
        return Vector3.anglePreNorm(this.clone().normalize(), vec2.clone().normalize());
    }

    public static double getAngle(Vector3 vec1, Vector3 vec2) {
        return vec1.getAngle(vec2);
    }

    public double anglePreNorm(Vector3 vec2) {
        return Math.acos(this.dotProduct(vec2));
    }

    public static double anglePreNorm(Vector3 vec1, Vector3 vec2) {
        return Math.acos(vec1.clone().dotProduct(vec2));
    }

    @Deprecated
    public static Vector3 readFromNBT(by nbt) {
        return new Vector3(nbt);
    }

    public by writeToNBT(by nbt) {
        nbt.a("x", this.x);
        nbt.a("y", this.y);
        nbt.a("z", this.z);
        return nbt;
    }

    public static Vector3 UP() {
        return new Vector3(0.0, 1.0, 0.0);
    }

    public static Vector3 DOWN() {
        return new Vector3(0.0, -1.0, 0.0);
    }

    public static Vector3 NORTH() {
        return new Vector3(0.0, 0.0, -1.0);
    }

    public static Vector3 SOUTH() {
        return new Vector3(0.0, 0.0, 1.0);
    }

    public static Vector3 WEST() {
        return new Vector3(-1.0, 0.0, 0.0);
    }

    public static Vector3 EAST() {
        return new Vector3(1.0, 0.0, 0.0);
    }

    public ata rayTrace(abw world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        ata pickedBlock = this.rayTraceBlocks(world, rotationYaw, rotationPitch, collisionFlag, reachDistance);
        ata pickedEntity = this.rayTraceEntities(world, rotationYaw, rotationPitch, collisionFlag, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        double dBlock = this.distance(new Vector3(pickedBlock.f));
        double dEntity = this.distance(new Vector3(pickedEntity.f));
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public ata rayTraceBlocks(abw world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        Vector3 lookVector = Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3 reachPoint = Vector3.translate(this, Vector3.scale(lookVector, reachDistance));
        return world.a(this.toVec3(), reachPoint.toVec3(), collisionFlag, !collisionFlag);
    }

    @Deprecated
    public ata rayTraceEntities(abw world, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        return this.rayTraceEntities(world, rotationYaw, rotationPitch, reachDistance);
    }

    public ata rayTraceEntities(abw world, float rotationYaw, float rotationPitch, double reachDistance) {
        return this.rayTraceEntities(world, Vector3.getDeltaPositionFromRotation(rotationYaw, rotationPitch).scale(reachDistance));
    }

    public ata rayTraceEntities(abw world, Vector3 target) {
        ata pickedEntity = null;
        atc startingPosition = this.toVec3();
        atc look = target.clone().difference(this).normalize().toVec3();
        double reachDistance = this.distance(target);
        atc reachPoint = atc.a((double)(startingPosition.c + look.c * reachDistance), (double)(startingPosition.d + look.d * reachDistance), (double)(startingPosition.e + look.e * reachDistance));
        double checkBorder = 1.1 * reachDistance;
        asx boxToScan = asx.a().a(-checkBorder, -checkBorder, -checkBorder, checkBorder, checkBorder, checkBorder).d(this.x, this.y, this.z);
        List entitiesHit = world.b(null, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (nn entityHit : entitiesHit) {
            float border;
            asx aabb;
            ata hitMOP;
            if (entityHit == null || !entityHit.L() || entityHit.E == null || (hitMOP = (aabb = entityHit.E.b((double)(border = entityHit.Z()), (double)border, (double)border)).a(startingPosition, reachPoint)) == null) continue;
            if (aabb.a(startingPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new ata(entityHit)) == null) continue;
                pickedEntity.f = hitMOP.f;
                closestEntity = 0.0;
                continue;
            }
            double distance = startingPosition.d(hitMOP.f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new ata(entityHit);
            pickedEntity.f = hitMOP.f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public int hashCode() {
        return ("X:" + this.x + "Y:" + this.y + "Z:" + this.z).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3) {
            Vector3 vector3 = (Vector3)o;
            return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
        }
        return false;
    }

    public String toString() {
        return "Vector3 [" + this.x + "," + this.y + "," + this.z + "]";
    }
}

