/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fossilsarch.common.ai.DinoAIControlledByPlayer;
import net.fossilsarch.common.ai.DinoAIEatFerns;
import net.fossilsarch.common.ai.DinoAIFollowOwner;
import net.fossilsarch.common.ai.DinoAIGrowup;
import net.fossilsarch.common.ai.DinoAIPickItem;
import net.fossilsarch.common.ai.DinoAIStarvation;
import net.fossilsarch.common.ai.DinoAIUseFeeder;
import net.fossilsarch.common.ai.DinoAIWander;
import net.fossilsarch.common.entity.EntityDinosaurce;
import net.fossilsarch.common.io.EnumDinoEating;
import net.fossilsarch.common.io.EnumDinoType;
import net.fossilsarch.common.io.EnumOrderType;
import net.fossilsarch.common.io.EnumSituation;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityTriceratops
extends EntityDinosaurce {
    private boolean looksWithInterest;
    public final float HuntLimit = this.getHungerLimit() * 4 / 5;
    private float field_25048_b;
    private float field_25054_c;
    private boolean field_25052_g;
    protected final int AGE_LIMIT = 12;
    public int RushTick = 0;
    public int BreedTick = 3000;
    public boolean Running = false;

    public EntityTriceratops(World world) {
        this(world, EntityTriceratops.randomSpawnAge(world.field_73012_v));
        this.setSubSpecies(this.field_70170_p.field_73012_v.nextInt(3) + 1);
        this.OrderStatus = EnumOrderType.FreeMove;
    }

    public EntityTriceratops(World world, int age) {
        super(world);
        this.setDinoAge(age);
        this.func_70105_a((float)(1.5 + 0.3 * (double)this.getDinoAge()), (float)(1.5 + 0.3 * (double)this.getDinoAge()));
        this.OrderStatus = EnumOrderType.FreeMove;
        this.SelfType = EnumDinoType.Triceratops;
        this.looksWithInterest = false;
        this.updateSize(false);
        this.func_70606_j(8 + age);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIGrowup(this, 12));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIStarvation(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.ridingHandler = new DinoAIControlledByPlayer(this, 0.34f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.ridingHandler);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0f, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIEatFerns(this, this.HuntLimit));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIUseFeeder(this, 1.0f, 24, this.HuntLimit, EnumDinoEating.Herbivorous));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIPickItem(this, Item.field_77685_T, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIPickItem(this, Item.field_77706_j, 1.0f, 24, this.HuntLimit));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIWander(this, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_70689_ay() {
        float speed = super.func_70689_ay();
        speed *= 0.7f + 0.2f * (float)this.getDinoAge();
        speed = this.isSelfAngry() ? (speed *= 2.0f) : (speed *= 0.5f);
        return speed;
    }

    private static int randomSpawnAge(Random random) {
        boolean isChild;
        boolean bl = isChild = random.nextInt(4) == 0;
        if (isChild) {
            return random.nextInt(4);
        }
        return random.nextInt(9) + 4;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public int getHungerLimit() {
        return 500;
    }

    @Override
    public boolean func_70650_aV() {
        return !this.isModelized();
    }

    public boolean isBaby() {
        return this.getDinoAge() <= 4;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("SubSpecies", this.getSubSpecies());
        nbttagcompound.func_74757_a("Angry", this.isSelfAngry());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSubSpecies(nbttagcompound.func_74762_e("SubSpecies"));
        this.CheckSkin();
        boolean angry = nbttagcompound.func_74767_n("Angry");
        if (!this.isModelized()) {
            this.setSelfAngry(angry);
        }
        this.InitSize();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        if (this.field_70170_p.func_72890_a((Entity)this, 8.0) != null) {
            return "fossilsarch:tri_roar";
        }
        return null;
    }

    protected String func_70621_aR() {
        return "mob.cow.hurt";
    }

    protected String func_70673_aS() {
        return "fossilsarch:tri_death";
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            this.field_70700_bx = 10;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        if (this.isSelfSitting()) {
            return 20;
        }
        return super.func_70646_bf();
    }

    protected boolean func_70780_i() {
        return this.isSelfSitting() || this.field_25052_g;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.modelizedDrop()) {
            return true;
        }
        Entity entity = damagesource.func_76346_g();
        this.setSelfSitting(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            i = (i + 1.0f) / 2.0f;
        }
        if (super.func_70097_a(damagesource, i)) {
            if (!this.func_70909_n() && !this.isSelfAngry()) {
                if (entity instanceof EntityPlayer) {
                    this.setSelfAngry(true);
                    this.field_70789_a = entity;
                }
                if (entity instanceof EntityArrow && ((EntityArrow)entity).field_70250_c != null) {
                    entity = ((EntityArrow)entity).field_70250_c;
                }
            } else if (entity != this && entity != null) {
                if (this.func_70909_n() && entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71092_bJ.equalsIgnoreCase(this.func_70905_p())) {
                    return true;
                }
                this.field_70789_a = entity;
            }
            return true;
        }
        return false;
    }

    protected Entity func_70782_k() {
        if (this.isSelfAngry()) {
            return this.field_70170_p.func_72890_a((Entity)this, 16.0);
        }
        return null;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (this.isModelized()) {
            return this.modelizedInteract(entityplayer);
        }
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.field_77993_c == Item.field_77685_T.field_77779_bT) {
            if (this.CheckEatable(itemstack.field_77993_c) && this.HandleEating(10)) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                }
                this.func_70691_i(3.0f);
            }
            return true;
        }
        if (FMLCommonHandler.instance().getSide().isClient() && itemstack != null && itemstack.field_77993_c == mod_Fossil.DinoPedia.field_77779_bT) {
            EntityDinosaurce.pediaingDino = this;
            mod_Fossil.callGUI(entityplayer, 4, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        if (this.EOCInteract(itemstack, entityplayer)) {
            return true;
        }
        if (itemstack != null && itemstack.field_77993_c == Item.field_77669_D.field_77779_bT && entityplayer.field_71092_bJ.equalsIgnoreCase(this.func_70905_p())) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70703_bu = false;
                this.func_70778_a(null);
                this.OrderStatus = EnumOrderType.values()[(mod_Fossil.EnumToInt(this.OrderStatus) + 1) % 3];
                this.SendOrderMessage(this.OrderStatus);
                switch (this.OrderStatus) {
                    case Stay: {
                        this.setSelfSitting(true);
                        break;
                    }
                    case Follow: {
                        this.setSelfSitting(false);
                        break;
                    }
                    case FreeMove: {
                        this.setSelfSitting(false);
                    }
                }
            }
            return true;
        }
        if (this.func_70909_n() && this.getDinoAge() > 4 && !this.field_70170_p.field_72995_K && (this.field_70153_n == null || this.field_70153_n == entityplayer)) {
            entityplayer.field_70177_z = this.field_70177_z;
            entityplayer.func_70078_a((Entity)this);
            this.func_70778_a(null);
            this.field_70761_aq = this.field_70177_z;
            return true;
        }
        return false;
    }

    public int func_70641_bl() {
        return 100;
    }

    public boolean isSelfAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public boolean isSelfSitting() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setSelfAngry(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFD)));
        }
    }

    public void setSelfSitting(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFE)));
        }
    }

    public void func_70903_f(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 4)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFB)));
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    private void InitSize() {
        this.updateSize(false);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void ChangeTexture() {
        this.CheckSkin();
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.getGLY() * 0.65 + 0.07 * (double)(12 - this.getDinoAge()), this.field_70161_v);
    }

    @Override
    public boolean HandleEating(int FoodValue) {
        return this.HandleEating(FoodValue, false);
    }

    public boolean HandleEating(int FoodValue, boolean FernFlag) {
        if (this.getHunger() >= this.getHungerLimit()) {
            if (this.func_70909_n() && !FernFlag) {
                this.SendStatusMessage(EnumSituation.Full, this.SelfType);
            }
            return false;
        }
        this.increaseHunger(FoodValue);
        this.showHeartsOrSmokeFX(false);
        if (this.getHunger() >= this.getHungerLimit()) {
            this.setHunger(this.getHungerLimit());
        }
        return true;
    }

    private boolean FindWheats(int range) {
        if (!this.isSelfSitting()) {
            List NearBy = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0));
            if (NearBy != null) {
                for (int i = 0; i < NearBy.size(); ++i) {
                    if (!(NearBy.get(i) instanceof EntityItem)) continue;
                    EntityItem ItemInRange = (EntityItem)NearBy.get(i);
                    if (ItemInRange.func_92059_d().field_77993_c != Item.field_77685_T.field_77779_bT) continue;
                    this.HandleEating(10);
                    this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((new Random().nextFloat() - new Random().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    ItemInRange.func_70106_y();
                    return true;
                }
            }
            EntityItem TargetItem = null;
            List searchlist = this.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72332_a().func_72299_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b((double)range, 4.0, (double)range));
            for (Entity entity1 : searchlist) {
                if (!(entity1 instanceof EntityItem)) continue;
                EntityItem Tmp = (EntityItem)entity1;
                if (Tmp.func_92059_d().func_77973_b().field_77779_bT != Item.field_77685_T.field_77779_bT) continue;
                if (TargetItem != null) {
                    if (!(this.GetDistanceWithEntity((Entity)Tmp) < this.GetDistanceWithEntity((Entity)TargetItem))) continue;
                    TargetItem = Tmp;
                    continue;
                }
                TargetItem = Tmp;
            }
            if (TargetItem != null) {
                this.func_70778_a(this.field_70170_p.func_72865_a((Entity)this, TargetItem, (float)range, true, false, true, false));
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && this.field_70153_n != null && this.field_70122_E) {
            this.func_70074_a((EntityLivingBase)entity);
            ((EntityLivingBase)entity).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
            return;
        }
        super.func_70108_f(entity);
    }

    @Override
    public void BlockInteractive() {
        for (int j = (int)Math.round(this.field_70121_D.field_72340_a) - 1; j <= (int)Math.round(this.field_70121_D.field_72336_d) + 1; ++j) {
            for (int k = (int)Math.round(this.field_70121_D.field_72338_b); k <= (int)Math.round(this.field_70121_D.field_72337_e); ++k) {
                for (int l = (int)Math.round(this.field_70121_D.field_72339_c) - 1; l <= (int)Math.round(this.field_70121_D.field_72334_f) + 1; ++l) {
                    if (this.field_70170_p.func_72799_c(j, k, l)) continue;
                    int blockid = this.field_70170_p.func_72798_a(j, k, l);
                    if (this.field_70171_ac) continue;
                    if (!this.func_70909_n() || this.field_70153_n != null) {
                        if (!((double)Block.field_71973_m[blockid].func_71934_m(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 5.0) && blockid != Block.field_71951_J.field_71990_ca) continue;
                        if (new Random().nextInt(10) == 5) {
                            Block.field_71973_m[blockid].func_71897_c(this.field_70170_p, j, k, l, 1, 0);
                        }
                        this.field_70170_p.func_94575_c(j, k, l, 0);
                        this.RushTick = 10;
                        continue;
                    }
                    if (blockid != Block.field_71951_J.field_71990_ca && blockid != Block.field_71952_K.field_71990_ca) continue;
                    this.field_70170_p.func_94575_c(j, k, l, 0);
                    this.RushTick = 10;
                }
            }
        }
    }

    public boolean isWheat(ItemStack par1ItemStack) {
        return par1ItemStack != null && par1ItemStack.field_77993_c == Item.field_77685_T.field_77779_bT;
    }

    @Override
    public void ShowPedia(EntityPlayer checker) {
        this.PediaTextCorrection(this.SelfType, checker);
        if (this.func_70909_n()) {
            mod_Fossil.ShowMessage(OwnerText + this.func_70905_p(), checker);
            mod_Fossil.ShowMessage(AgeText + this.getDinoAge(), checker);
            mod_Fossil.ShowMessage(HelthText + this.func_110143_aJ() + "/" + 20, checker);
            mod_Fossil.ShowMessage(HungerText + this.getHunger() + "/" + this.getHungerLimit(), checker);
            if (this.func_70909_n() && this.getDinoAge() > 4 && this.field_70153_n == null) {
                mod_Fossil.ShowMessage(RidiableText, checker);
            }
        } else {
            mod_Fossil.ShowMessage(UntamedText, checker);
        }
    }

    @Override
    public void SetOrder(EnumOrderType input) {
        this.OrderStatus = input;
    }

    public boolean CheckEatable(int itemIndex) {
        Item tmp = Item.field_77698_e[itemIndex];
        boolean result = false;
        result = tmp == Item.field_77685_T || tmp == Item.field_77738_bf;
        return result;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        return new EntityTriceratops(this.field_70170_p, 0);
    }

    private boolean FindFren(int range) {
        int j;
        int i;
        float TempDis = range * 2;
        int targetX = 0;
        int targetY = 0;
        int targetZ = 0;
        for (i = -range; i <= range; ++i) {
            for (j = -2; j <= 2; ++j) {
                for (int k = -range; k <= range; ++k) {
                    if (this.field_70170_p.func_72798_a((int)Math.round(this.field_70165_t + (double)i), (int)Math.round(this.field_70163_u + (double)j), (int)Math.round(this.field_70161_v + (double)k)) != mod_Fossil.Ferns.field_71990_ca || !(TempDis > this.GetDistanceWithXYZ(this.field_70165_t + (double)i, this.field_70163_u + (double)j, this.field_70161_v + (double)k))) continue;
                    TempDis = this.GetDistanceWithXYZ(this.field_70165_t + (double)i, this.field_70163_u + (double)j, this.field_70161_v + (double)k);
                    targetX = i;
                    targetY = j;
                    targetZ = k;
                }
            }
        }
        if (TempDis != (float)(range * 2)) {
            if (Math.sqrt(targetX ^ 2 + targetY ^ 2 + targetZ ^ 2) >= 2.0) {
                this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, (int)Math.round(this.field_70165_t + (double)targetX), (int)Math.round(this.field_70163_u + (double)targetY), (int)Math.round(this.field_70161_v + (double)targetZ), 10.0f, true, false, true, false));
                return true;
            }
            this.FaceToCoord((int)(-(this.field_70165_t + (double)targetX)), (int)(this.field_70163_u + (double)targetY), (int)(-(this.field_70161_v + (double)targetZ)));
            this.HandleEating(10, true);
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    if (this.field_70170_p.func_72798_a((int)Math.round(this.field_70165_t + (double)targetX + (double)i), (int)Math.round(this.field_70163_u + (double)targetY), (int)Math.round(this.field_70161_v + (double)targetZ + (double)j)) != mod_Fossil.Ferns.field_71990_ca) continue;
                    this.field_70170_p.func_72926_e(2001, (int)Math.round(this.field_70165_t + (double)targetX + (double)i), (int)Math.round(this.field_70163_u + (double)targetY), (int)Math.round(this.field_70161_v + (double)targetZ + (double)j), Block.field_71962_X.field_71990_ca);
                    this.field_70170_p.func_94575_c((int)Math.round(this.field_70165_t + (double)targetX + (double)i), (int)Math.round(this.field_70163_u + (double)targetY), (int)Math.round(this.field_70161_v + (double)targetZ + (double)j), 0);
                    if (this.field_70170_p.func_72798_a((int)Math.round(this.field_70165_t + (double)targetX + (double)i), (int)Math.round(this.field_70163_u + (double)targetY) + 1, (int)Math.round(this.field_70161_v + (double)targetZ + (double)j)) == mod_Fossil.FernUpper.field_71990_ca) {
                        this.field_70170_p.func_94575_c((int)Math.round(this.field_70165_t + (double)targetX + (double)i), (int)Math.round(this.field_70163_u + (double)targetY) + 1, (int)Math.round(this.field_70161_v + (double)targetZ + (double)j), 0);
                    }
                    if (this.field_70170_p.func_72798_a((int)Math.round(this.field_70165_t + (double)targetX + (double)i), (int)Math.round(this.field_70163_u + (double)targetY) - 1, (int)Math.round(this.field_70161_v + (double)targetZ + (double)j)) != Block.field_71980_u.field_71990_ca) continue;
                    this.field_70170_p.func_94575_c((int)Math.round(this.field_70165_t + (double)targetX + (double)i), (int)Math.round(this.field_70163_u + (double)targetY) - 1, (int)Math.round(this.field_70161_v + (double)targetZ + (double)j), Block.field_71979_v.field_71990_ca);
                }
                this.func_70691_i(3.0f);
                this.func_70778_a(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateSize(boolean shouldAddAge) {
        if (shouldAddAge && this.getDinoAge() < this.AGE_LIMIT) {
            this.increaseDinoAge();
        }
        this.func_70105_a((float)(1.5 + 0.3 * (double)this.getDinoAge()), (float)(1.5 + 0.3 * (double)this.getDinoAge()));
    }

    @Override
    public EnumOrderType getOrderType() {
        return this.OrderStatus;
    }

    @Override
    protected int foodValue(Item asked) {
        if (asked == Item.field_77685_T) {
            return 10;
        }
        if (asked == Item.field_77706_j) {
            return 30;
        }
        return 0;
    }

    @Override
    public void HoldItem(Item itemGot) {
    }

    @Override
    public float getGLX() {
        return (float)(1.5 + 0.3 * (double)this.getDinoAge());
    }

    @Override
    public float getGLY() {
        return (float)(1.5 + 0.3 * (double)this.getDinoAge());
    }

    @Override
    public String[] additionalPediaMessage() {
        String[] result = null;
        if (!this.func_70909_n()) {
            result = new String[]{UntamedText};
        } else {
            ArrayList<String> resultList = new ArrayList<String>();
            if (this.func_70909_n() && this.getDinoAge() > 4 && this.field_70153_n == null) {
                resultList.add(RidiableText);
            }
            if (!resultList.isEmpty()) {
                result = new String[1];
                result = resultList.toArray(result);
            }
        }
        return result;
    }
}

