/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.tileentity;

import java.util.Random;
import net.fossilsarch.common.block.BlockAnalyzer;
import net.fossilsarch.common.io.EnumDinoType;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityAnalyzer
extends TileEntity
implements IInventory,
ISidedInventory {
    private ItemStack[] analyzerItemStacks = new ItemStack[13];
    public int analyzerBurnTime = 0;
    public int currentItemBurnTime = 100;
    public int analyzerCookTime = 0;
    private int RawIndex = -1;
    private int SpaceIndex = -1;

    public int func_70302_i_() {
        return this.analyzerItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.analyzerItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.analyzerItemStacks[i] != null) {
            if (this.analyzerItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.analyzerItemStacks[i];
                this.analyzerItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.analyzerItemStacks[i].func_77979_a(j);
            if (this.analyzerItemStacks[i].field_77994_a == 0) {
                this.analyzerItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.analyzerItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Analyzer";
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
        this.analyzerItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.analyzerItemStacks.length) continue;
            this.analyzerItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.analyzerBurnTime = nbttagcompound.func_74765_d("BurnTime");
        this.analyzerCookTime = nbttagcompound.func_74765_d("CookTime");
        this.currentItemBurnTime = 100;
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("BurnTime", (short)this.analyzerBurnTime);
        nbttagcompound.func_74777_a("CookTime", (short)this.analyzerCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.analyzerItemStacks.length; ++i) {
            if (this.analyzerItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.analyzerItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getCookProgressScaled(int i) {
        return this.analyzerCookTime * i / 200;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 100;
        }
        return this.analyzerBurnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.analyzerBurnTime > 0;
    }

    public void func_70316_g() {
        boolean flag = this.analyzerBurnTime > 0;
        boolean flag1 = false;
        if (this.analyzerBurnTime > 0) {
            --this.analyzerBurnTime;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.analyzerBurnTime == 0 && this.canSmelt()) {
                this.analyzerBurnTime = 100;
                this.currentItemBurnTime = 100;
                if (this.analyzerBurnTime > 0) {
                    flag1 = true;
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.analyzerCookTime;
                if (this.analyzerCookTime == 200) {
                    this.analyzerCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.analyzerCookTime = 0;
            }
            if (flag != this.analyzerBurnTime > 0) {
                flag1 = true;
                BlockAnalyzer.updateFurnaceBlockState(this.analyzerBurnTime > 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean isValidInput(int itemID) {
        return itemID == mod_Fossil.biofossil.field_77779_bT || itemID == mod_Fossil.relic.field_77779_bT || itemID == mod_Fossil.RawDinoMeat.field_77779_bT || itemID == Item.field_77784_aq.field_77779_bT || itemID == Item.field_77741_bi.field_77779_bT || itemID == Item.field_77764_aP.field_77779_bT || itemID == Item.field_77735_bk.field_77779_bT || itemID == Block.field_72101_ab.field_71990_ca || itemID == mod_Fossil.IcedMeat.field_77779_bT;
    }

    private boolean canSmelt() {
        int i;
        this.SpaceIndex = -1;
        this.RawIndex = -1;
        for (i = 0; i < 9; ++i) {
            int tmp;
            if (this.analyzerItemStacks[i] == null || !this.isValidInput(tmp = this.analyzerItemStacks[i].func_77973_b().field_77779_bT)) continue;
            this.RawIndex = i;
            break;
        }
        if (this.RawIndex == -1) {
            return false;
        }
        for (i = 12; i > 8; --i) {
            if (this.analyzerItemStacks[i] != null) continue;
            this.SpaceIndex = i;
            break;
        }
        return this.SpaceIndex != -1 && this.RawIndex != -1;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemstack = null;
        int chance = new Random().nextInt(100);
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == mod_Fossil.biofossil) {
            if (chance <= 60) {
                itemstack = new ItemStack(Item.field_77756_aW, 3, 15);
            }
            if (chance > 60 && chance <= 80) {
                itemstack = new ItemStack(mod_Fossil.FernSeed, 3);
            }
            if (chance > 80) {
                int chanceDNA = new Random().nextInt(EnumDinoType.values().length - 1);
                if (chanceDNA >= EnumDinoType.Mosasaurus.ordinal()) {
                    ++chanceDNA;
                }
                itemstack = new ItemStack(mod_Fossil.DNA, 1, chanceDNA);
            }
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b().field_77779_bT == Block.field_72101_ab.field_71990_ca) {
            itemstack = new Random().nextInt(50) <= 30 ? new ItemStack(Item.field_77683_K, 4) : new ItemStack(mod_Fossil.AnimalDNA, 1, 1);
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == mod_Fossil.RawDinoMeat) {
            itemstack = new ItemStack(mod_Fossil.DNA, 4, this.analyzerItemStacks[this.RawIndex].func_77960_j());
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Item.field_77784_aq) {
            itemstack = new ItemStack(mod_Fossil.AnimalDNA, 2, 0);
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Item.field_77741_bi) {
            itemstack = new ItemStack(mod_Fossil.AnimalDNA, 2, 2);
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Item.field_77764_aP) {
            itemstack = new ItemStack(mod_Fossil.AnimalDNA, 1, 3);
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Item.field_77735_bk) {
            itemstack = new ItemStack(mod_Fossil.AnimalDNA, 1, 3);
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == mod_Fossil.IcedMeat) {
            if (chance <= 33) {
                itemstack = new ItemStack(mod_Fossil.AnimalDNA, 1, 4);
            }
            if (chance > 33 && chance < 66) {
                itemstack = new ItemStack(mod_Fossil.AnimalDNA, 1, 5);
            }
            if (itemstack == null) {
                itemstack = new ItemStack(Item.field_77741_bi);
            }
        }
        if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == mod_Fossil.relic) {
            if (chance <= 40) {
                itemstack = new ItemStack(Block.field_71940_F, 6);
            }
            if (chance > 40 && chance <= 70) {
                itemstack = new ItemStack(mod_Fossil.stoneboard, 1);
            }
            if (chance > 70 && chance <= 90) {
                itemstack = new ItemStack(Item.field_77804_ap, 2);
            }
            if (chance > 90) {
                itemstack = new ItemStack(mod_Fossil.BrokenSword, 1);
            }
        }
        if (itemstack != null) {
            if (itemstack.field_77993_c == Item.field_77756_aW.field_77779_bT || itemstack.field_77993_c == mod_Fossil.FernSeed.field_77779_bT || itemstack.field_77993_c == Item.field_77804_ap.field_77779_bT || itemstack.field_77993_c == Block.field_71940_F.field_71990_ca) {
                for (int i = 12; i > 8; --i) {
                    if (this.analyzerItemStacks[i] == null || itemstack.field_77993_c != this.analyzerItemStacks[i].field_77993_c) continue;
                    if (this.analyzerItemStacks[i].field_77994_a + itemstack.field_77994_a <= this.analyzerItemStacks[i].func_77976_d()) {
                        this.analyzerItemStacks[i].field_77994_a += itemstack.field_77994_a;
                        itemstack.field_77994_a = 0;
                        break;
                    }
                    itemstack.field_77994_a -= this.analyzerItemStacks[i].func_77976_d() - this.analyzerItemStacks[i].field_77994_a;
                    this.analyzerItemStacks[i].field_77994_a = this.analyzerItemStacks[i].func_77976_d();
                }
            }
            if (itemstack.field_77994_a != 0 && this.analyzerItemStacks[this.SpaceIndex] == null) {
                this.analyzerItemStacks[this.SpaceIndex] = itemstack.func_77946_l();
            }
            --this.analyzerItemStacks[this.RawIndex].field_77994_a;
            if (this.analyzerItemStacks[this.RawIndex].field_77994_a == 0) {
                this.analyzerItemStacks[this.RawIndex] = null;
            }
        }
    }

    private int getItemBurnTime(ItemStack itemstack) {
        return 100;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{9, 10, 11, 12};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i >= 9;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i >= 9) {
            return false;
        }
        return this.isValidInput(itemstack.field_77993_c);
    }
}

