/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.BlockNBTManager;
import powercrystals.minefactoryreloaded.core.IEntityCollidable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.tile.conveyor.TileEntityConveyor;

public class BlockConveyor
extends BlockContainer
implements IConnectableRedNet {
    private String[] _names = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "lightgray", "cyan", "purple", "blue", "brown", "green", "red", "black", "default"};
    private Icon[] _iconsActive = new Icon[this._names.length];
    private Icon[] _iconsStopped = new Icon[this._names.length];

    public BlockConveyor(int n) {
        super(n, Material.field_76265_p);
        this.func_71848_c(0.5f);
        this.func_71864_b("mfr.conveyor");
        this.func_71905_a(0.0f, 0.0f, 0.0f, 0.1f, 0.01f, 0.1f);
        this.func_71849_a(MFRCreativeTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        for (int i = 0; i < this._names.length; ++i) {
            this._iconsActive[i] = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a() + ".active." + this._names[i]);
            this._iconsStopped[i] = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_71917_a() + ".stopped." + this._names[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World world, MovingObjectPosition movingObjectPosition, EffectRenderer effectRenderer) {
        int n = movingObjectPosition.field_72311_b;
        int n2 = movingObjectPosition.field_72312_c;
        int n3 = movingObjectPosition.field_72309_d;
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            float f = 0.1f;
            Random random = new Random();
            double d = (double)n + random.nextDouble() * (this.func_83007_w() - this.func_83009_v() - (double)(f * 2.0f)) + (double)f + this.func_83009_v();
            double d2 = (double)n2 + random.nextDouble() * (this.func_83010_y() - this.func_83008_x() - (double)(f * 2.0f)) + (double)f + this.func_83008_x();
            double d3 = (double)n3 + random.nextDouble() * (this.func_83006_A() - this.func_83005_z() - (double)(f * 2.0f)) + (double)f + this.func_83005_z();
            switch (movingObjectPosition.field_72310_e) {
                case 0: {
                    d2 = (double)n2 + this.func_83008_x() - (double)f;
                    break;
                }
                case 1: {
                    d2 = (double)n2 + this.func_83010_y() + (double)f;
                    break;
                }
                case 2: {
                    d3 = (double)n3 + this.func_83005_z() - (double)f;
                    break;
                }
                case 3: {
                    d3 = (double)n3 + this.func_83006_A() + (double)f;
                    break;
                }
                case 4: {
                    d = (double)n + this.func_83009_v() - (double)f;
                    break;
                }
                case 5: {
                    d = (double)n + this.func_83007_w() + (double)f;
                }
            }
            effectRenderer.func_78873_a(new EntityDiggingFX(world, d, d2, d3, 0.0, 0.0, 0.0, (Block)this, this.func_71873_h(world, n, n2, n3)).func_70596_a(n, n2, n3).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World world, int n, int n2, int n3, int n4, EffectRenderer effectRenderer) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            int n5 = 4 - Minecraft.func_71410_x().field_71474_y.field_74362_aa * 2;
            n5 &= ~n5 >> 31;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n5; ++j) {
                    for (int k = 0; k < n5; ++k) {
                        double d = (double)n + ((double)i + 0.5) / (double)n5;
                        double d2 = (double)n2 + ((double)j + 0.5) / (double)n5;
                        double d3 = (double)n3 + ((double)k + 0.5) / (double)n5;
                        effectRenderer.func_78873_a((EntityFX)new EntityDiggingFX(world, d, d2, d3, d - (double)n - 0.5, d2 - (double)n2 - 0.5, d3 - (double)n3 - 0.5, (Block)this, this.func_71873_h(world, n, n2, n3)).func_70596_a(n, n2, n3));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean recolourBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            int n5 = ((TileEntityConveyor)tileEntity).getDyeColor();
            ((TileEntityConveyor)tileEntity).setDyeColor(n4);
            return n5 != ((TileEntityConveyor)tileEntity).getDyeColor();
        }
        return false;
    }

    public Icon func_71895_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = iBlockAccess.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            int n5 = ((TileEntityConveyor)tileEntity).getDyeColor();
            if (n5 == -1) {
                n5 = 16;
            }
            if (((TileEntityConveyor)tileEntity).getConveyorActive()) {
                return this._iconsActive[n5];
            }
            return this._iconsStopped[n5];
        }
        return this._iconsStopped[this._iconsStopped.length - 1];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int n, int n2) {
        return this._iconsStopped[n2];
    }

    public void func_71860_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntity tileEntity;
        if (entityLivingBase == null) {
            return;
        }
        int n4 = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (n4 == 0) {
            world.func_72921_c(n, n2, n3, 1, 2);
        }
        if (n4 == 1) {
            world.func_72921_c(n, n2, n3, 2, 2);
        }
        if (n4 == 2) {
            world.func_72921_c(n, n2, n3, 3, 2);
        }
        if (n4 == 3) {
            world.func_72921_c(n, n2, n3, 0, 2);
        }
        if ((tileEntity = world.func_72796_p(n, n2, n3)) instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).setDyeColor(itemStack.func_77960_j() == 16 ? -1 : itemStack.func_77960_j());
        }
    }

    public int func_71873_h(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        int n4 = 16;
        if (tileEntity instanceof TileEntityConveyor && (n4 = ((TileEntityConveyor)tileEntity).getDyeColor()) == -1) {
            n4 = 16;
        }
        return n4;
    }

    public void func_71869_a(World world, int n, int n2, int n3, Entity entity) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = entity instanceof EntityItem || entity instanceof EntityXPOrb;
        if (!bl2) {
            for (Class<?> clazz : MFRRegistry.getConveyerBlacklist()) {
                if (!clazz.isInstance(entity)) continue;
                return;
            }
        }
        if (!(bl2 || entity instanceof EntityLivingBase || entity instanceof EntityTNTPrimed)) {
            return;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (!(tileEntity instanceof TileEntityConveyor) || !((TileEntityConveyor)tileEntity).getConveyorActive()) {
            return;
        }
        if (!world.field_72995_K && entity instanceof EntityItem) {
            this.specialRoute(world, n, n2, n3, (EntityItem)entity);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = world.func_72805_g(n, n2, n3);
        int n5 = n4 & 3;
        boolean bl4 = (n4 & 4) != 0;
        boolean bl5 = bl = (n4 & 8) != 0;
        if (bl4) {
            d2 = 0.17;
        } else if (entity.field_70163_u - (double)n2 < 0.1 & entity.field_70163_u - (double)n2 > 0.0) {
            entity.field_70163_u = (double)n2 + 0.1;
        }
        if (bl4 || bl) {
            entity.field_70122_E = false;
        }
        if (n5 == 0) {
            d = 0.1;
        } else if (n5 == 1) {
            d3 = 0.1;
        } else if (n5 == 2) {
            d = -0.1;
        } else if (n5 == 3) {
            d3 = -0.1;
        }
        if (n5 == 0 || n5 == 2) {
            if (entity.field_70161_v > (double)n3 + 0.55) {
                d3 = -0.1;
            } else if (entity.field_70161_v < (double)n3 + 0.45) {
                d3 = 0.1;
            }
        } else if (n5 == 1 || n5 == 3) {
            if (entity.field_70165_t > (double)n + 0.55) {
                d = -0.1;
            } else if (entity.field_70165_t < (double)n + 0.45) {
                d = 0.1;
            }
        }
        this.setEntityVelocity(entity, d, d2, d3);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70143_R = 0.0f;
        } else if (entity instanceof EntityItem) {
            ((EntityItem)entity).field_70293_c = 40;
        }
    }

    public AxisAlignedBB func_71872_e(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        if ((n4 & 0xC) == 0) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.05f), (double)n2, (double)((float)n3 + 0.05f), (double)((float)(n + 1) - 0.05f), (double)((float)n2 + 0.01f), (double)((float)(n3 + 1) - 0.05f));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.1f), (double)n2, (double)((float)n3 + 0.1f), (double)((float)(n + 1) - 0.1f), (double)((float)n2 + 0.01f), (double)((float)(n3 + 1) - 0.1f));
    }

    public AxisAlignedBB func_71911_a_(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        if ((n4 & 0xC) == 0) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.05f), (double)n2, (double)((float)n3 + 0.05f), (double)((float)(n + 1) - 0.05f), (double)((float)n2 + 0.1f), (double)((float)(n3 + 1) - 0.05f));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)n + 0.1f), (double)n2, (double)((float)n3 + 0.1f), (double)((float)(n + 1) - 0.1f), (double)((float)n2 + 0.1f), (double)((float)(n3 + 1) - 0.1f));
    }

    public boolean func_71926_d() {
        return false;
    }

    public MovingObjectPosition func_71878_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.func_71902_a((IBlockAccess)world, n, n2, n3);
        return super.func_71878_a(world, n, n2, n3, vec3, vec32);
    }

    public void func_71902_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.func_72805_g(n, n2, n3);
        if (n4 >= 4 && n4 <= 11) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return MineFactoryReloadedCore.renderIdConveyor;
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    public boolean func_71930_b(World world, int n, int n2, int n3) {
        return this.func_71854_d(world, n, n2, n3);
    }

    public boolean func_71854_d(World world, int n, int n2, int n3) {
        return world.isBlockSolidOnSide(n, n2 - 1, n3, ForgeDirection.UP);
    }

    public boolean rotateBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        IRotateableTile iRotateableTile;
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof IRotateableTile && (iRotateableTile = (IRotateableTile)tileEntity).canRotate()) {
            iRotateableTile.rotate();
            return true;
        }
        return false;
    }

    public boolean func_71903_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        if (MFRUtil.isHoldingHammer(entityPlayer)) {
            TileEntity tileEntity = world.func_72796_p(n, n2, n3);
            if (tileEntity instanceof IRotateableTile) {
                ((IRotateableTile)tileEntity).rotate();
            }
            return true;
        }
        return false;
    }

    public void func_71863_a(World world, int n, int n2, int n3, int n4) {
        if (!this.func_71854_d(world, n, n2, n3)) {
            world.func_94571_i(n, n2, n3);
            this.func_71897_c(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
            return;
        }
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).updateConveyorActive();
        }
    }

    private void setEntityVelocity(Entity entity, double d, double d2, double d3) {
        entity.field_70159_w = d;
        entity.field_70181_x = d2;
        entity.field_70179_y = d3;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityConveyor();
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int n, int n2, int n3, int n4, int n5) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        NBTTagCompound nBTTagCompound = BlockNBTManager.getForBlock(n, n2, n3);
        if (nBTTagCompound != null) {
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound);
            if (itemStack != null) {
                arrayList.add(itemStack);
            }
        } else if (world.func_72798_a(n, n2, n3) == this.field_71990_ca) {
            arrayList.add(new ItemStack(this.field_71990_ca, 1, this.func_71873_h(world, n, n2, n3)));
            world.func_72921_c(n, n2, n3, 15, 4);
        }
        return arrayList;
    }

    public void func_71846_a(World world, int n, int n2, int n3, int n4, EntityPlayer entityPlayer) {
        if (entityPlayer.field_71075_bZ.field_75098_d) {
            world.func_72921_c(n, n2, n3, 15, 4);
        }
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        if (n5 != 15) {
            BlockNBTManager.setForBlock(new BlockPosition(n, n2, n3), new ItemStack(this.field_71990_ca, 1, this.func_71873_h(world, n, n2, n3)).func_77955_b(new NBTTagCompound()));
        }
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public boolean func_71853_i() {
        return false;
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return RedNetConnectionType.PlateSingle;
    }

    @Override
    public int[] getOutputValues(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return null;
    }

    @Override
    public int getOutputValue(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        return 0;
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).onRedNetChanged(n4);
        }
    }

    private void specialRoute(World world, int n, int n2, int n3, EntityItem entityItem) {
        TileEntity tileEntity = world.func_72796_p(n, n2 - 1, n3);
        if (tileEntity == null || entityItem.field_70128_L) {
            return;
        }
        if (tileEntity instanceof IEntityCollidable) {
            ((IEntityCollidable)tileEntity).onEntityCollided((Entity)entityItem);
        } else if (tileEntity instanceof TileEntityHopper && !((TileEntityHopper)tileEntity).func_98047_l()) {
            ItemStack itemStack = entityItem.func_92059_d().func_77946_l();
            itemStack.field_77994_a = 1;
            if ((itemStack = TileEntityHopper.func_94117_a((IInventory)((IInventory)tileEntity), (ItemStack)itemStack, (int)ForgeDirection.UP.ordinal())) == null) {
                --entityItem.func_92059_d().field_77994_a;
                ((TileEntityHopper)tileEntity).func_98046_c(8);
            }
        }
    }
}

