/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.net.PacketWrapper;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.api.IUpgrade;

public class HarvestAreaManager {
    private IRotateableTile _owner;
    private int _originX;
    private int _originY;
    private int _originZ;
    private ForgeDirection _originOrientation;
    private ForgeDirection _overrideDirection;
    private Area _harvestArea;
    private int _radius;
    private int _areaUp;
    private int _areaDown;
    private int _originOffsetX;
    private int _originOffsetY;
    private int _originOffsetZ;
    private List<BlockPosition> _harvestedBlocks;
    private int _currentBlock;
    private int _upgradeLevel;
    private float _upgradeModifier;
    private boolean hasDirtyUpgrade;

    public HarvestAreaManager(IRotateableTile iRotateableTile, int n, int n2, int n3) {
        this(iRotateableTile, n, n2, n3, 1.0f);
    }

    public HarvestAreaManager(IRotateableTile iRotateableTile, int n, int n2, int n3, float f) {
        this._owner = iRotateableTile;
        this._overrideDirection = ForgeDirection.UNKNOWN;
        this._radius = n;
        this._areaUp = n2;
        this._areaDown = n3;
        this._upgradeModifier = f;
        this._originX = ((TileEntity)iRotateableTile).field_70329_l;
        this._originY = ((TileEntity)iRotateableTile).field_70330_m;
        this._originZ = ((TileEntity)iRotateableTile).field_70327_n;
        this._originOrientation = iRotateableTile.getDirectionFacing();
        this.hasDirtyUpgrade = false;
    }

    public void setOriginOffset(int n, int n2, int n3) {
        this._originOffsetX = n;
        this._originOffsetY = n2;
        this._originOffsetZ = n3;
        this.checkRecalculate();
    }

    public Area getHarvestArea() {
        this.checkRecalculate();
        return this._harvestArea;
    }

    public int getOriginX() {
        return this._originX;
    }

    public int getOriginY() {
        return this._originY;
    }

    public int getOriginZ() {
        return this._originZ;
    }

    public int getRadius() {
        return this._radius + this._upgradeLevel;
    }

    public BlockPosition getNextBlock() {
        this.checkRecalculate();
        BlockPosition blockPosition = this._harvestedBlocks.get(this._currentBlock);
        ++this._currentBlock;
        if (this._currentBlock >= this._harvestedBlocks.size()) {
            this._currentBlock = 0;
        }
        return blockPosition;
    }

    public void rewindBlock() {
        --this._currentBlock;
        if (this._currentBlock < 0) {
            this._currentBlock = this._harvestedBlocks.size() - 1;
        }
    }

    public void setOverrideDirection(ForgeDirection forgeDirection) {
        this._overrideDirection = forgeDirection;
    }

    public void setUpgradeLevel(int n) {
        this._upgradeLevel = n;
        this.recalculateArea();
        this.hasDirtyUpgrade = true;
    }

    public Packet getUpgradePacket(TileEntity tileEntity) {
        if (this.hasDirtyUpgrade) {
            this.hasDirtyUpgrade = false;
            return PacketWrapper.createPacket((String)"MFReloaded", (int)5, (Object[])new Object[]{tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n, this._upgradeLevel});
        }
        return null;
    }

    public void updateUpgradeLevel(ItemStack itemStack) {
        IUpgrade iUpgrade;
        if (itemStack == null) {
            if (this._upgradeLevel != 0) {
                this.setUpgradeLevel(0);
            }
            return;
        }
        int n = 0;
        if (itemStack.func_77973_b() instanceof IUpgrade && (iUpgrade = (IUpgrade)itemStack.func_77973_b()).isApplicableFor(IUpgrade.UpgradeType.RADIUS, itemStack)) {
            n = (int)((float)iUpgrade.getUpgradeLevel(IUpgrade.UpgradeType.RADIUS, itemStack) * this._upgradeModifier);
        }
        if (n != this._upgradeLevel) {
            this.setUpgradeLevel(n);
        }
    }

    private void checkRecalculate() {
        if (this._harvestArea == null) {
            this.recalculateArea();
            return;
        }
        if (this._overrideDirection != ForgeDirection.UNKNOWN && this._originOrientation != this._overrideDirection || this._overrideDirection == ForgeDirection.UNKNOWN && this._originOrientation != this._owner.getDirectionFacing() || this._originX != ((TileEntity)this._owner).field_70329_l + this._originOffsetX || this._originY != ((TileEntity)this._owner).field_70330_m + this._originOffsetY || this._originZ != ((TileEntity)this._owner).field_70327_n + this._originOffsetZ) {
            this.recalculateArea();
        }
    }

    private void recalculateArea() {
        BlockPosition blockPosition = BlockPosition.fromFactoryTile((IRotateableTile)this._owner);
        if (this._overrideDirection != ForgeDirection.UNKNOWN) {
            blockPosition.orientation = this._overrideDirection;
        }
        this._originX = blockPosition.x + this._originOffsetX;
        this._originY = blockPosition.y + this._originOffsetY;
        this._originZ = blockPosition.z + this._originOffsetZ;
        this._originOrientation = blockPosition.orientation;
        int n = this._radius + this._upgradeLevel;
        if (blockPosition.orientation == ForgeDirection.UP || blockPosition.orientation == ForgeDirection.DOWN) {
            blockPosition.moveForwards(1);
        } else {
            blockPosition.moveForwards(n + 1);
        }
        blockPosition.x += this._originOffsetX;
        blockPosition.y += this._originOffsetY;
        blockPosition.z += this._originOffsetZ;
        this._harvestArea = new Area(blockPosition, n, this._areaDown, this._areaUp);
        this._harvestedBlocks = this._harvestArea.getPositionsBottomFirst();
        this._currentBlock = 0;
    }
}

