/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;

public abstract class MFRLiquidMover {
    public static boolean manuallyFillTank(ITankContainerBucketable iTankContainerBucketable, EntityPlayer entityPlayer) {
        IFluidContainerItem iFluidContainerItem;
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        if (fluidStack != null) {
            if (iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack, false) == fluidStack.amount) {
                iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack, true);
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, UtilInventory.consumeItem((ItemStack)itemStack, (EntityPlayer)entityPlayer));
                }
                return true;
            }
        } else if (itemStack != null && itemStack.func_77973_b() instanceof IFluidContainerItem && iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack = (iFluidContainerItem = (IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack), false) > 0) {
            int n = iTankContainerBucketable.fill(ForgeDirection.UNKNOWN, fluidStack, true);
            ItemStack itemStack2 = itemStack.func_77979_a(1);
            iFluidContainerItem.drain(itemStack2, n, true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                MFRLiquidMover.disposePlayerItem(itemStack, itemStack2, entityPlayer, false);
            } else {
                ++itemStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public static boolean manuallyDrainTank(ITankContainerBucketable iTankContainerBucketable, EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        boolean bl = false;
        if (itemStack != null && (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack) || (bl = itemStack.func_77973_b() instanceof IFluidContainerItem))) {
            for (FluidTankInfo fluidTankInfo : iTankContainerBucketable.getTankInfo(ForgeDirection.UNKNOWN)) {
                FluidStack fluidStack = fluidTankInfo.fluid;
                if (fluidStack == null || fluidStack.amount == 0) continue;
                ItemStack itemStack2 = null;
                FluidStack fluidStack2 = null;
                if (bl) {
                    IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)itemStack.func_77973_b();
                    itemStack2 = itemStack.func_77946_l();
                    itemStack2.field_77994_a = 1;
                    if (iFluidContainerItem.fill(itemStack2, fluidStack, false) > 0) {
                        int n = iFluidContainerItem.fill(itemStack2, fluidStack, true);
                        fluidStack2 = new FluidStack(fluidStack.fluidID, n);
                        FluidStack fluidStack3 = iTankContainerBucketable.drain(ForgeDirection.UNKNOWN, fluidStack2, false);
                        if (fluidStack3 == null || fluidStack3.amount < n) {
                            itemStack2 = null;
                        }
                    } else {
                        itemStack2 = null;
                    }
                } else {
                    itemStack2 = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack);
                    if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack2)) {
                        fluidStack2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack2);
                        FluidStack fluidStack4 = iTankContainerBucketable.drain(ForgeDirection.UNKNOWN, fluidStack2, false);
                        if (fluidStack4 == null || fluidStack4.amount < fluidStack2.amount) {
                            itemStack2 = null;
                        }
                    } else {
                        itemStack2 = null;
                    }
                }
                if (itemStack2 == null || !MFRLiquidMover.disposePlayerItem(itemStack, itemStack2, entityPlayer, MFRConfig.dropFilledContainers.getBoolean(true))) continue;
                iTankContainerBucketable.drain(ForgeDirection.UNKNOWN, fluidStack2, true);
                return true;
            }
        }
        return false;
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl) {
        return MFRLiquidMover.disposePlayerItem(itemStack, itemStack2, entityPlayer, bl, true);
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl, boolean bl2) {
        if (entityPlayer == null || entityPlayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (bl2 && itemStack.field_77994_a <= 1) {
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, itemStack2);
            return true;
        }
        if (bl) {
            --itemStack.field_77994_a;
            if (!entityPlayer.field_71071_by.func_70441_a(itemStack2)) {
                entityPlayer.func_71021_b(itemStack2);
            }
            return true;
        }
        return false;
    }

    public static void pumpLiquid(IFluidTank iFluidTank, TileEntityFactory tileEntityFactory) {
        if (iFluidTank != null && iFluidTank.getFluid() != null && iFluidTank.getFluid().amount > 0) {
            FluidStack fluidStack = iFluidTank.getFluid().copy();
            fluidStack.amount = Math.min(fluidStack.amount, 1000);
            for (BlockPosition blockPosition : new BlockPosition((TileEntity)tileEntityFactory).getAdjacent(true)) {
                TileEntity tileEntity = tileEntityFactory.field_70331_k.func_72796_p(blockPosition.x, blockPosition.y, blockPosition.z);
                if (!(tileEntity instanceof IFluidHandler)) continue;
                int n = ((IFluidHandler)tileEntity).fill(blockPosition.orientation.getOpposite(), fluidStack, true);
                iFluidTank.drain(n, true);
                fluidStack.amount -= n;
                if (fluidStack.amount > 0) continue;
                break;
            }
        }
    }
}

