/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.thaumcraft;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCocoa;
import powercrystals.minefactoryreloaded.farmables.fruits.FruitCocoa;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableCocoa;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.FertilizableTCSapling;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.HarvestableThaumcraftLeaves;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.HarvestableThaumcraftPlant;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.PlantableThaumcraftTree;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;

@Mod(modid="MineFactoryReloaded|CompatThaumcraft", name="MFR Compat: Thaumcraft", version="1.6.2R2.7.5", dependencies="after:MineFactoryReloaded;after:Thaumcraft")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Thaumcraft {
    private static LinkedHashMap<String, ? extends Object> aspects = null;
    private static Method registerItem = null;
    private static Method registerEntity = null;
    private static Class<?> AspectList = null;
    private static Constructor<?> newAspectList = null;
    private static Method addAspect = null;

    @Mod.EventHandler
    public static void load(FMLPostInitializationEvent fMLPostInitializationEvent) {
        if (!Loader.isModLoaded((String)"Thaumcraft")) {
            FMLLog.warning((String)"Thaumcraft missing - MFR Thaumcraft Compat not loading", (Object[])new Object[0]);
            return;
        }
        try {
            Block block = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockCustomPlant");
            Block block2 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLog");
            Block block3 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLeaves");
            Block block4 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockTaintFibres");
            Block block5 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockManaPod");
            Item item = GameRegistry.findItem((String)"Thaumcraft", (String)"ItemManaBean");
            Class<?> clazz = Class.forName("thaumcraft.common.entities.golems.EntityGolemBase");
            Class<?> clazz2 = Class.forName("thaumcraft.common.entities.golems.EntityTravelingTrunk");
            MFRRegistry.registerAutoSpawnerBlacklistClass(clazz);
            MFRRegistry.registerAutoSpawnerBlacklistClass(clazz2);
            MFRRegistry.registerGrinderBlacklist(clazz);
            MFRRegistry.registerGrinderBlacklist(clazz2);
            if (MFRConfig.conveyorNeverCapturesTCGolems.getBoolean(false)) {
                MFRRegistry.registerConveyerBlacklist(clazz);
                MFRRegistry.registerConveyerBlacklist(clazz2);
            }
            MFRRegistry.registerHarvestable(new HarvestableStandard(block2.field_71990_ca, HarvestType.Tree));
            MFRRegistry.registerHarvestable(new HarvestableStandard(block4.field_71990_ca, HarvestType.Normal));
            MFRRegistry.registerHarvestable(new HarvestableThaumcraftLeaves(block3.field_71990_ca, block.field_71990_ca));
            MFRRegistry.registerHarvestable(new HarvestableThaumcraftPlant(block.field_71990_ca));
            MFRRegistry.registerHarvestable(new HarvestableCocoa(block5.field_71990_ca));
            MFRRegistry.registerPlantable(new PlantableThaumcraftTree(block.field_71990_ca, block.field_71990_ca));
            MFRRegistry.registerPlantable(new PlantableStandard(item.field_77779_bT, block5.field_71990_ca));
            MFRRegistry.registerFruitLogBlockId(block2.field_71990_ca);
            MFRRegistry.registerFruit(new FruitCocoa(block5.field_71990_ca));
            MFRRegistry.registerFertilizable(new FertilizableCocoa(block5.field_71990_ca, FertilizerType.GrowMagicalCrop));
            MFRRegistry.registerFertilizable(new FertilizableTCSapling(block));
            Class<?> clazz3 = Class.forName("thaumcraft.api.aspects.Aspect");
            aspects = (LinkedHashMap)clazz3.getDeclaredField("aspects").get(null);
            Class<?> clazz4 = Class.forName("thaumcraft.api.ThaumcraftApi");
            AspectList = Class.forName("thaumcraft.api.aspects.AspectList");
            registerItem = clazz4.getDeclaredMethod("registerObjectTag", Integer.TYPE, Integer.TYPE, AspectList);
            registerEntity = clazz4.getDeclaredMethod("registerEntityTag", String.class, AspectList, NBTBase[].class);
            addAspect = AspectList.getDeclaredMethod("add", clazz3, Integer.TYPE);
            newAspectList = AspectList.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            Thaumcraft.doAspects();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void parseAspects(ItemStack itemStack, String string, boolean bl) throws Throwable {
        String[] stringArray = string.split(",");
        Object obj = bl ? newAspectList.newInstance(itemStack.field_77993_c, itemStack.func_77960_j()) : AspectList.newInstance();
        int n = stringArray.length;
        while (n-- > 0) {
            String[] stringArray2 = stringArray[n].trim().split(" ");
            stringArray2[1] = stringArray2[1].toLowerCase();
            if (aspects.containsKey(stringArray2[1])) {
                addAspect.invoke(obj, aspects.get(stringArray2[1]), Integer.parseInt(stringArray2[0], 10));
                continue;
            }
            FMLLog.severe((String)"%s aspect missing.", (Object[])new Object[]{stringArray2[1]});
        }
        registerItem.invoke(null, itemStack.field_77993_c, itemStack.func_77960_j(), obj);
    }

    private static void parseAspects(String string, String string2) throws Throwable {
        String[] stringArray = string2.split(",");
        Object obj = AspectList.newInstance();
        int n = stringArray.length;
        while (n-- > 0) {
            String[] stringArray2 = stringArray[n].trim().split(" ");
            stringArray2[1] = stringArray2[1].toLowerCase();
            if (!aspects.containsKey(stringArray2[1])) continue;
            addAspect.invoke(obj, aspects.get(stringArray2[1]), Integer.parseInt(stringArray2[0], 10));
        }
        registerEntity.invoke(null, string, obj, null);
    }

    private static void parseAspects(Item item, String string) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(item, 1, 0), string, false);
    }

    private static void parseAspects(Block block, int n, String string) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(block, 1, n), string, false);
    }

    private static void parseAspects(Block block, String string) throws Throwable {
        Thaumcraft.parseAspects(block, 0, string);
    }

    private static void parseAspects(Block block, int n, String string, boolean bl) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(block, 1, n), string, bl);
    }

    private static void parseAspects(Block block, String string, boolean bl) throws Throwable {
        Thaumcraft.parseAspects(block, 0, string, bl);
    }

    private static void parseAspects(Machine machine, String string) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(machine.getBlockId(), 1, machine.getMeta()), string, false);
    }

    private static void doAspects() throws Throwable {
        Thaumcraft.parseAspects(Machine.AutoAnvil, "3 Permutatio, 5 Fabrico, 10 Metallum, 5 Machina");
        Thaumcraft.parseAspects(Machine.AutoBrewer, "4 ignis, 2 Fabrico, 2 Aqua, 2 praecantatio, 5 Machina");
        Thaumcraft.parseAspects(Machine.AutoDisenchanter, "4 praecantatio, 4 Permutatio, 5 Machina");
        Thaumcraft.parseAspects(Machine.AutoEnchanter, "8 praecantatio, 4 Cognitio, 4 fabrico, 5 Machina");
        Thaumcraft.parseAspects(Machine.AutoJukebox, "4 Sensus, 4 Aer, 5 Machina");
        Thaumcraft.parseAspects(Machine.AutoSpawner, "4 bestia, 4 exanimis, 7 praecantatio, 4 alienis, 5 Machina, 10 permutatio");
        Thaumcraft.parseAspects(Machine.BioFuelGenerator, "5 Potentia, 3 Herba, 5 Machina, 3 permutatio");
        Thaumcraft.parseAspects(Machine.BioReactor, "4 Herba, 2 Potentia, 5 Machina, 5 permutatio");
        Thaumcraft.parseAspects(Machine.BlockBreaker, "15 Perfodio, 5 Machina, 5 metallum, 3 Lucrum");
        Thaumcraft.parseAspects(Machine.BlockPlacer, "1 motus, 1 ordo, 5 Machina, 5 metallum, 3 Lucrum");
        Thaumcraft.parseAspects(Machine.BlockSmasher, "5 Perditio, 5 Machina, 3 permutatio, 3 praecantatio");
        Thaumcraft.parseAspects(Machine.Breeder, "2 bestia, 2 fames, 5 Machina");
        Thaumcraft.parseAspects(Machine.Chronotyper, "3 Tempus, 3 bestia, 5 Machina, 3 Sensus");
        Thaumcraft.parseAspects(Machine.Composter, "2 bestia, 2 Aqua, 5 Machina");
        Thaumcraft.parseAspects(Machine.DeepStorageUnit, "4971027 vacuos, 5 Machina, 5 Alienis");
        Thaumcraft.parseAspects(Machine.Ejector, "4 Motus, 5 Machina");
        Thaumcraft.parseAspects(Machine.EnchantmentRouter, "1 Motus, 4 iter, 2 Sensus, 5 Machina, 1 praecantatio");
        Thaumcraft.parseAspects(Machine.Fertilizer, "6 Herba, 5 Machina, 1 Vitreus, 3 Victus");
        Thaumcraft.parseAspects(Machine.Fisher, "3 Aqua, 5 Machina, 4 metallum, 2 Instrumentum");
        Thaumcraft.parseAspects(Machine.FruitPicker, "2 Herba, 4 meto, 5 Machina");
        Thaumcraft.parseAspects(Machine.Grinder, "10 Telum, 6 mortuus, 7 Meto, 5 Machina, 4 metallum, 2 Lucrum");
        Thaumcraft.parseAspects(Machine.ItemCollector, "4 vacuos, 5 Machina, 2 Arbor, 4 Motus");
        Thaumcraft.parseAspects(Machine.ItemRouter, "2 Motus, 4 iter, 2 Sensus,  5 Machina");
        Thaumcraft.parseAspects(Machine.LaserDrill, "5 Perfodio, 15 Lux, 5 Machina, 4 Victus");
        Thaumcraft.parseAspects(Machine.LaserDrillPrecharger, "4 Lux, 5 Machina, 15 Potentia, 2 victus");
        Thaumcraft.parseAspects(Machine.LavaFabricator, "4 ignis, 4 Saxum, 4 Fabrico, 5 Machina");
        Thaumcraft.parseAspects(Machine.LiquiCrafter, "5 Aqua, 5 Fabrico, 5 Machina");
        Thaumcraft.parseAspects(Machine.LiquidRouter, "1 Motus, 4 iter, 2 Sensus, 5 Machina, 1 Aqua");
        Thaumcraft.parseAspects(Machine.MeatPacker, "2 Ordo, 2 Corpus, 2 fames, 5 Machina");
        Thaumcraft.parseAspects(Machine.Planter, "4 Herba, 2 Granum, 4 messis, 5 Machina");
        Thaumcraft.parseAspects(Machine.Rancher, "6 Meto, 5 Machina, 4 metallum, 2 Instrumentum");
        Thaumcraft.parseAspects(Machine.RedNote, "4 Aer, 4 Sensus, 5 Machina");
        Thaumcraft.parseAspects(Machine.Sewer, "1 Venenum, 3 Aqua 5 Machina, 4 bestia");
        Thaumcraft.parseAspects(Machine.Slaughterhouse, "12 Telum, 10 mortuus, 5 Machina, 12 metallum, 6 Lucrum");
        Thaumcraft.parseAspects(Machine.SludgeBoiler, "3 Venenum, 3 Terra, 2 Aqua, 5 Machina, 2 ignis");
        Thaumcraft.parseAspects(Machine.Unifier, "5 Ordo, 2 Alienis, 5 Machina");
        Thaumcraft.parseAspects(Machine.Vet, "4 Sano, 5 Machina, 4 bestia");
        Thaumcraft.parseAspects(Machine.WeatherCollector, " 4 vacuos, 5 Machina, 5 metallum, 4 Tempestas");
        Thaumcraft.parseAspects("mfrEntityPinkSlime", "1 Aqua, 2 Limus, 1 Corpus, 1 Bestia");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.bioFuelBucketItem, "2 Herba, 1 Potentia, 1 Aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.biofuelLiquid, "4 Herba, 2 Potentia, 2 Aqua");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.blankRecordItem, "4 Sensus, 4 Aer, 4 Lucrum, 4 vacuos");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.ceramicDyeItem, "1 Terra, 1 Aqua, 1 Sensus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.chocolateMilkBucketItem, "2 Fames, 1 Motus, 1 Potentia, 2 Aqua, 8 Metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.chocolateMilkLiquid, "4 Fames, 2 Motus, 2 Potentia, 4 Aqua");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.conveyorBlock, "3 Motus, 1 iter, 1 Machina");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.essenceLiquid, "4 praecantatio, 2 cognitio, 2 Aqua");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryGlassBlock, "1 Vitreus, 1 Sensus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryHammerItem, "1 Instrumentum, 2 Fabrico, 2 ignis, 3 Ordo");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.fertilizerItem, "1 Granum, 1 Herba, 1 Messis");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.laserFocusItem, "1 Ordo, 1 Vitreus, 4 Lucrum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.machineBaseItem, "2 Fabrico, 2 Machina, 1 Saxum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.meatBucketItem, "3 Corpus, 1 bestia, 1 Aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.meatIngotCookedItem, "3 Corpus, 2 fames, 1 Ignis");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.meatIngotRawItem, "3 Corpus, 2 fames, 1 bestia");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.meatLiquid, "6 Corpus, 2 Aqua, 2 bestia");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.meatNuggetCookedItem, "1 fames");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.meatNuggetRawItem, "1 Corpus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.milkBottleItem, "1 Fames, 1 Sano, 1 Victus, 1 Vitreus");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.milkLiquid, "4 Fames, 4 Sano, 4 Aqua, 2 Victus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.mobEssenceBucketItem, "2 praecantatio, 1 cognitio, 1 Aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.mushroomSoupBucketItem, "2 fames, 2 Herba, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.mushroomSoupLiquid, "4 fames, 4 Herba, 1 Aqua");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.pinkSlimeballItem, "1 Limus, 1 Corpus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.pinkSlimeBucketItem, "2 Limus, 2 Corpus, 1 Aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.pinkSlimeLiquid, "4 Limus, 4 Corpus, 2 Aqua");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.plasticSheetItem, "1 Fabrico, 1 ignis, 2 Ordo");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.portaSpawnerItem, "8 Alienis, 4 bestia, 4 exanimis, 4 iter, 8 praecantatio, 8 Permutatio");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rawPlasticItem, "1 Fabrico, 1 ignis, 1 Ordo, 1 Perditio");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rawRubberItem, "1 Limus, 2 Arbor");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.rednetCableBlock, "1 cognitio, 1 Machina", true);
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.rednetLogicBlock, "15 cognitio, 5 Machina", true);
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rednetMemoryCardItem, "3 cognitio, 1 Machina");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rednetMeterItem, "1 Instrumentum, 1 Sensus, 1 Machina");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.rednetPanelBlock, "2 Sensus, 2 cognitio, 2 Machina");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rubberBarItem, "1 Motus, 1 Arbor, 1 ignis");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rubberLeavesBlock, "1 Herba");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rubberSaplingBlock, "1 Arbor, 1 Herba, 1 Granum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rubberWoodBlock, "3 Arbor, 1 Limus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.rulerItem, "1 Instrumentum, 1 Sensus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.safariNetItem, "4 Spiritus, 8 Alienis, 8 iter, 4 praecantatio, 8 Vinculum, 4 Fabrico");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.safariNetJailerItem, "10 Vinculum, 1 praecantatio, 4 spiritus, 2 metallum, 1 Fabrico");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.safariNetLauncherItem, "2 Volatus, 2 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.safariNetSingleItem, "4 Vinculum, 4 spiritus, 2 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.sewageBucketItem, "2 Venenum, 1 bestia, 1 Aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.sewageLiquid, "4 Venenum, 2 bestia, 2 Aqua");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.sludgeBucketItem, "2 Venenum, 1 Terra, 1 Aqua, 1 Vitium, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MineFactoryReloadedCore.sludgeLiquid, "4 Venenum, 2 Terra, 2 Aqua, 1 Vitium");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.spyglassItem, "2 Victus, 6 Sensus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.strawItem, "1 vacuos, 4 Aqua, 4 fames, 1 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.sugarCharcoalItem, "2 Potentia, 2 ignis");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.syringeCureItem, "2 Sano, 1 Exanimis, 1 Humanus, 1 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.syringeEmptyItem, "1 vacuos, 1 Sano, 1 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.syringeGrowthItem, "1 tempus, 2 Sano, 1 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.syringeHealthItem, "2 Sano, 1 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.syringeSlimeItem, "1 Sano, 1 Limus, 1 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.syringeZombieItem, "1 tempus, 1 Sano, 1 Exanimis, 1 Instrumentum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.vineScaffoldBlock, "1 Herba, 1 Fabrico");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.xpExtractorItem, "1 praecantatio, 1 Permutatio, 1 vacuos, 1 Instrumentum, 1 Meto");
        Item item = MineFactoryReloadedCore.upgradeItem;
        int n = 10;
        for (int i = 0; i <= n; ++i) {
            Thaumcraft.parseAspects(new ItemStack(item, 1, i), "2 cognitio", true);
        }
        Thaumcraft.parseAspects(new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 0), "4 Cognitio", true);
        Thaumcraft.parseAspects(new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 2), "7 Cognitio", true);
        Thaumcraft.parseAspects(new ItemStack(MineFactoryReloadedCore.logicCardItem, 1, 3), "10 Cognitio", true);
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, "3 Lux, 2 Sensus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 6, "1 Terra, 3 Lux, 2 Sensus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 3, "1 Terra, 3 ignis, 1 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 9, "3 ignis, 2 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 4, "2 Terra, 1 Saxum");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 0, "2 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 1, "2 Saxum, 1 Victus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 2, "1 perditio, 1 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 3, "1 perditio, 1 Saxum, 1 Victus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 4, "2 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 5, "2 Saxum, 1 Victus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 6, "2 Terra, 1 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 7, "2 Terra, 1 Saxum, 1 Victus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 8, "1 Terra, 1 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 9, "1 Terra, 1 Saxum, 1 Victus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 10, "3 Saxum, 1 tenebrae");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryDecorativeStoneBlock, 11, "3 Saxum, 1 Victus");
        Thaumcraft.parseAspects(new ItemStack(MineFactoryReloadedCore.factoryDecorativeBrickBlock, 1, 11), "1 cognitio, 3 Machina", true);
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryRoadBlock, 0, "1 iter, 1 Saxum, 1 sensus");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryRoadBlock, 1, "1 iter, 1 Saxum, 1 sensus, 3 Lux");
        Thaumcraft.parseAspects(MineFactoryReloadedCore.factoryRoadBlock, 4, "1 iter, 1 Saxum, 1 sensus, 3 Lux");
    }
}

