/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.net;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.LinkedList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet51MapChunk;
import net.minecraft.server.management.PlayerInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.TextureStitchEvent;
import powercrystals.minefactoryreloaded.net.IMFRProxy;

public class CommonProxy
implements IMFRProxy,
IScheduledTickHandler {
    private long lastTime = 0L;
    private LinkedList<Chunk> chunksToRelight = new LinkedList();

    @Override
    public void init() {
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)this, (Side)Side.SERVER);
    }

    @Override
    public void movePlayerToCoordinates(EntityLivingBase entityLivingBase, double d, double d2, double d3) {
        if (entityLivingBase instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityLivingBase;
            entityPlayerMP.field_71135_a.func_72569_a(d, d2, d3, entityPlayerMP.field_71109_bG, entityPlayerMP.field_70726_aT);
        }
        entityLivingBase.func_70634_a(d, d2, d3);
    }

    @Override
    public void onPostTextureStitch(TextureStitchEvent.Post post) {
    }

    @Override
    public void addRelightChunk(Chunk chunk) {
        if (chunk != null) {
            PlayerInstance playerInstance;
            this.chunksToRelight.add(chunk);
            chunk.func_76613_n();
            chunk.field_76643_l = true;
            World world = chunk.field_76637_e;
            if (world instanceof WorldServer && (playerInstance = ((WorldServer)world).func_73040_p().func_72690_a(chunk.field_76635_g, chunk.field_76647_h, false)) != null) {
                playerInstance.func_73256_a((Packet)new Packet51MapChunk(chunk, false, -1));
            }
        }
    }

    public void tickStart(EnumSet<TickType> enumSet, Object ... objectArray) {
        this.lastTime = System.nanoTime();
    }

    public void tickEnd(EnumSet<TickType> enumSet, Object ... objectArray) {
        if (this.chunksToRelight.size() > 0) {
            Chunk chunk;
            while ((chunk = this.chunksToRelight.pollFirst()) != null) {
                chunk.func_76603_b();
                chunk.func_76586_k();
                chunk.func_76594_o();
                long l = System.nanoTime() - this.lastTime;
                if (l < 50L) continue;
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "MFR server chunk relight";
    }

    public int nextTickSpacing() {
        return 1;
    }
}

