/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup;

import java.io.File;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import powercrystals.minefactoryreloaded.setup.Machine;

public class MFRConfig {
    public static Property spyglassRange;
    public static Property dropFilledContainers;
    public static Property machineBlock0Id;
    public static Property machineBlock1Id;
    public static Property machineBlock2Id;
    public static Property conveyorBlockId;
    public static Property factoryGlassBlockId;
    public static Property factoryGlassPaneBlockId;
    public static Property factoryRoadBlockId;
    public static Property factoryDecorativeBrickBlockId;
    public static Property factoryDecorativeStoneBlockId;
    public static Property rubberWoodBlockId;
    public static Property rubberLeavesBlockId;
    public static Property rubberSaplingBlockId;
    public static Property railPickupCargoBlockId;
    public static Property railDropoffCargoBlockId;
    public static Property railPickupPassengerBlockId;
    public static Property railDropoffPassengerBlockId;
    public static Property rednetCableBlockId;
    public static Property rednetLogicBlockId;
    public static Property rednetPanelBlockId;
    public static Property fakeLaserBlockId;
    public static Property vineScaffoldBlockId;
    public static Property detCordBlockId;
    public static Property milkStillBlockId;
    public static Property sludgeStillBlockId;
    public static Property sewageStillBlockId;
    public static Property essenceStillBlockId;
    public static Property biofuelStillBlockId;
    public static Property meatStillBlockId;
    public static Property pinkslimeStillBlockId;
    public static Property chocolateMilkStillBlockId;
    public static Property mushroomSoupStillBlockId;
    public static Property hammerItemId;
    public static Property milkItemId;
    public static Property sludgeItemId;
    public static Property sewageItemId;
    public static Property mobEssenceItemId;
    public static Property fertilizerItemId;
    public static Property plasticSheetItemId;
    public static Property rawPlasticItemId;
    public static Property rubberBarItemId;
    public static Property sewageBucketItemId;
    public static Property sludgeBucketItemId;
    public static Property mobEssenceBucketItemId;
    public static Property syringeEmptyItemId;
    public static Property syringeHealthItemId;
    public static Property syringeGrowthItemId;
    public static Property rawRubberItemId;
    public static Property machineBaseItemId;
    public static Property safariNetItemId;
    public static Property ceramicDyeItemId;
    public static Property blankRecordId;
    public static Property syringeZombieId;
    public static Property safariNetSingleItemId;
    public static Property bioFuelItemId;
    public static Property bioFuelBucketItemId;
    public static Property upgradeItemId;
    public static Property safariNetLauncherItemId;
    public static Property sugarCharcoalItemId;
    public static Property milkBottleItemId;
    public static Property spyglassItemId;
    public static Property portaSpawnerItemId;
    public static Property strawItemId;
    public static Property xpExtractorItemId;
    public static Property syringeSlimeItemId;
    public static Property syringeCureItemId;
    public static Property logicCardItemId;
    public static Property rednetMeterItemId;
    public static Property rednetMemoryCardItemId;
    public static Property rulerItemId;
    public static Property meatIngotRawItemId;
    public static Property meatIngotCookedItemId;
    public static Property meatNuggetRawItemId;
    public static Property meatNuggetCookedItemId;
    public static Property meatBucketItemId;
    public static Property pinkSlimeBucketItemId;
    public static Property pinkSlimeballItemId;
    public static Property safariNetJailerItemId;
    public static Property laserFocusItemId;
    public static Property chocolateMilkBucketItemId;
    public static Property mushroomSoupBucketItemId;
    public static Property needlegunItemId;
    public static Property needlegunAmmoEmptyItemId;
    public static Property needlegunAmmoStandardItemId;
    public static Property needlegunAmmoLavaItemId;
    public static Property needlegunAmmoSludgeItemId;
    public static Property needlegunAmmoSewageItemId;
    public static Property needlegunAmmoFireItemId;
    public static Property needlegunAmmoAnvilItemId;
    public static Property plasticCupItemId;
    public static Property rocketLauncherItemId;
    public static Property rocketItemId;
    public static Property plasticCellItemId;
    public static Property fishingRodItemId;
    public static Property bagItemId;
    public static Property zoolologistEntityId;
    public static Property colorblindMode;
    public static Property treeSearchMaxVertical;
    public static Property treeSearchMaxHorizontal;
    public static Property verticalHarvestSearchMaxVertical;
    public static Property enableBonemealFertilizing;
    public static Property conveyorCaptureNonItems;
    public static Property conveyorNeverCapturesPlayers;
    public static Property conveyorNeverCapturesTCGolems;
    public static Property playSounds;
    public static Property fruitTreeSearchMaxVertical;
    public static Property fruitTreeSearchMaxHorizontal;
    public static Property breederShutdownThreshold;
    public static Property autospawnerCostStandard;
    public static Property autospawnerCostExact;
    public static Property laserdrillCost;
    public static Property meatSaturation;
    public static Property fishingDropRate;
    public static Property vanillaOverrideGlassPane;
    public static Property vanillaOverrideIce;
    public static Property vanillaOverrideMilkBucket;
    public static Property enableSlipperyRoads;
    public static Property enableCheapDSU;
    public static Property craftSingleDSU;
    public static Property enableMossyCobbleRecipe;
    public static Property enablePortaSpawner;
    public static Property enableSyringes;
    public static Property enableLiquidSyringe;
    public static Property enableGuns;
    public static Property enableNetLauncher;
    public static Property enableSPAMRExploding;
    public static Property enableFuelExploding;
    public static Property enableSpawnerCarts;
    public static Property enableMassiveTree;
    public static Property redNetConnectionBlacklist;
    public static Property redNetDebug;
    public static Property rubberTreeWorldGen;
    public static Property mfrLakeWorldGen;
    public static Property mfrLakeSewageRarity;
    public static Property mfrLakeSludgeRarity;
    public static Property rubberTreeBiomeWhitelist;
    public static Property rubberTreeBiomeBlacklist;
    public static Property worldGenDimensionBlacklist;
    public static Property unifierBlacklist;
    public static Property spawnerBlacklist;
    public static Property passengerRailSearchMaxHorizontal;
    public static Property passengerRailSearchMaxVertical;
    public static Property vanillaRecipes;
    public static Property thermalExpansionRecipes;
    public static Property gregTechRecipes;
    private static Configuration config;

    public static void loadClientConfig(File file) {
        Configuration configuration = new Configuration(file);
        spyglassRange = configuration.get("general", "SpyglassRange", 200);
        MFRConfig.spyglassRange.comment = "The maximum number of blocks the spyglass and ruler can look to find something. This calculation is performed only on the client side.";
        configuration.save();
    }

    public static void loadCommonConfig(File file) {
        Configuration configuration = new Configuration(file);
        configuration.load();
        config = configuration;
        machineBlock0Id = configuration.getBlock("ID.MachineBlock", 3120);
        conveyorBlockId = configuration.getBlock("ID.ConveyorBlock", 3121);
        rubberWoodBlockId = configuration.getBlock("ID.RubberWood", 3122);
        rubberLeavesBlockId = configuration.getBlock("ID.RubberLeaves", 3123);
        rubberSaplingBlockId = configuration.getBlock("ID.RubberSapling", 3124);
        railDropoffCargoBlockId = configuration.getBlock("ID.CargoRailDropoffBlock", 3125);
        railPickupCargoBlockId = configuration.getBlock("ID.CargoRailPickupBlock", 3126);
        railDropoffPassengerBlockId = configuration.getBlock("ID.PassengerRailDropoffBlock", 3127);
        railPickupPassengerBlockId = configuration.getBlock("ID.PassengerRailPickupBlock", 3128);
        factoryGlassBlockId = configuration.getBlock("ID.StainedGlass", 3129);
        factoryGlassPaneBlockId = configuration.getBlock("ID.StainedGlassPane", 3130);
        machineBlock1Id = configuration.getBlock("ID.MachineBlock1", 3131);
        factoryRoadBlockId = configuration.getBlock("ID.Road", 3132);
        factoryDecorativeBrickBlockId = configuration.getBlock("ID.Bricks", 3133);
        factoryDecorativeStoneBlockId = configuration.getBlock("ID.Stone", 3134);
        milkStillBlockId = configuration.getBlock("ID.Milk.Still", 3135);
        meatStillBlockId = configuration.getBlock("ID.Meat.Still", 3136);
        sludgeStillBlockId = configuration.getBlock("ID.Sludge.Still", 3137);
        pinkslimeStillBlockId = configuration.getBlock("ID.PinkSlime.Still", 3138);
        sewageStillBlockId = configuration.getBlock("ID.Sewage.Still", 3139);
        chocolateMilkStillBlockId = configuration.getBlock("ID.ChocolateMilk.Still", 3140);
        essenceStillBlockId = configuration.getBlock("ID.MobEssence.Still", 3141);
        mushroomSoupStillBlockId = configuration.getBlock("ID.MushroomSoup.Still", 3142);
        biofuelStillBlockId = configuration.getBlock("ID.BioFuel.Still", 3143);
        rednetCableBlockId = configuration.getBlock("ID.RedNet.Cable", 3144);
        rednetLogicBlockId = configuration.getBlock("ID.RedNet.Logic", 3145);
        machineBlock2Id = configuration.getBlock("ID.MachineBlock2", 3146);
        fakeLaserBlockId = configuration.getBlock("ID.FakeLaser", 3147);
        vineScaffoldBlockId = configuration.getBlock("ID.VineScaffold", 3148);
        rednetPanelBlockId = configuration.getBlock("ID.RedNet.Panel", 3149);
        detCordBlockId = configuration.getBlock("ID.DetCord", 3150);
        hammerItemId = configuration.getItem("item", "ID.Hammer", 11987);
        milkItemId = configuration.getItem("item", "ID.Milk", 11988);
        sludgeItemId = configuration.getItem("item", "ID.Sludge", 11989);
        sewageItemId = configuration.getItem("item", "ID.Sewage", 11990);
        mobEssenceItemId = configuration.getItem("item", "ID.MobEssence", 11991);
        fertilizerItemId = configuration.getItem("item", "ID.FertilizerItem", 11992);
        plasticSheetItemId = configuration.getItem("item", "ID.PlasticSheet", 11993);
        rawPlasticItemId = configuration.getItem("item", "ID.RawPlastic", 11994);
        rubberBarItemId = configuration.getItem("item", "ID.RubberBar", 11995);
        sewageBucketItemId = configuration.getItem("item", "ID.SewageBucket", 11996);
        sludgeBucketItemId = configuration.getItem("item", "ID.SludgeBucket", 11997);
        mobEssenceBucketItemId = configuration.getItem("item", "ID.MobEssenceBucket", 11998);
        syringeEmptyItemId = configuration.getItem("item", "ID.SyringeEmpty", 11999);
        syringeHealthItemId = configuration.getItem("item", "ID.SyringeHealth", 12000);
        syringeGrowthItemId = configuration.getItem("item", "ID.SyringeGrowth", 12001);
        rawRubberItemId = configuration.getItem("item", "ID.RawRubber", 12002);
        machineBaseItemId = configuration.getItem("item", "ID.MachineBlock", 12003);
        safariNetItemId = configuration.getItem("item", "ID.SafariNet", 12004);
        ceramicDyeItemId = configuration.getItem("item", "ID.CeramicDye", 12005);
        blankRecordId = configuration.getItem("item", "ID.BlankRecord", 12006);
        syringeZombieId = configuration.getItem("item", "ID.SyringeZombie", 12007);
        safariNetSingleItemId = configuration.getItem("item", "ID.SafariNetSingleUse", 12008);
        bioFuelItemId = configuration.getItem("item", "ID.BioFuel", 12009);
        bioFuelBucketItemId = configuration.getItem("item", "ID.BioFuelBucket", 12010);
        upgradeItemId = configuration.getItem("item", "ID.Upgrade", 12011);
        safariNetLauncherItemId = configuration.getItem("item", "ID.SafariNetLauncher", 12012);
        sugarCharcoalItemId = configuration.getItem("item", "ID.SugarCharcoal", 12013);
        milkBottleItemId = configuration.getItem("item", "ID.MilkBottle", 12014);
        spyglassItemId = configuration.getItem("item", "ID.Spyglass", 12015);
        portaSpawnerItemId = configuration.getItem("item", "ID.PortaSpawner", 12016);
        strawItemId = configuration.getItem("item", "ID.Straw", 12017);
        xpExtractorItemId = configuration.getItem("item", "ID.XPExtractor", 12018);
        syringeSlimeItemId = configuration.getItem("item", "ID.SyringeSlime", 12019);
        syringeCureItemId = configuration.getItem("item", "ID.SyringeCure", 12020);
        logicCardItemId = configuration.getItem("item", "ID.Upgrade.PRC", 12021);
        rednetMeterItemId = configuration.getItem("item", "ID.RedNet.Meter", 12022);
        rednetMemoryCardItemId = configuration.getItem("item", "ID.RedNet.MemoryCard", 12023);
        rulerItemId = configuration.getItem("item", "ID.Ruler", 12024);
        meatIngotRawItemId = configuration.getItem("item", "ID.MeatIngotRaw", 12025);
        meatIngotCookedItemId = configuration.getItem("item", "ID.MeatIngotCooked", 12026);
        meatNuggetRawItemId = configuration.getItem("item", "ID.MeatNuggetRaw", 12027);
        meatNuggetCookedItemId = configuration.getItem("item", "ID.MeatNuggetCooked", 12028);
        meatBucketItemId = configuration.getItem("item", "ID.MeatBucket", 12029);
        pinkSlimeBucketItemId = configuration.getItem("item", "ID.PinkSlimeBucket", 12030);
        pinkSlimeballItemId = configuration.getItem("item", "ID.PinkSlimeball", 12031);
        safariNetJailerItemId = configuration.getItem("item", "ID.SafariNetJailer", 12032);
        laserFocusItemId = configuration.getItem("item", "ID.LaserFocus", 12033);
        chocolateMilkBucketItemId = configuration.getItem("item", "ID.ChocolateMilkBucket", 12034);
        mushroomSoupBucketItemId = configuration.getItem("item", "ID.MushroomSoupBucket", 12035);
        needlegunItemId = configuration.getItem("item", "ID.NeedleGun", 12036);
        needlegunAmmoEmptyItemId = configuration.getItem("item", "ID.NeedleGun.Ammo.Empty", 12037);
        needlegunAmmoStandardItemId = configuration.getItem("item", "ID.NeedleGun.Ammo.Standard", 12038);
        needlegunAmmoLavaItemId = configuration.getItem("item", "ID.NeedleGun.Ammo.Lava", 12039);
        needlegunAmmoSludgeItemId = configuration.getItem("item", "ID.NeedleGun.Ammo.Sludge", 12040);
        needlegunAmmoSewageItemId = configuration.getItem("item", "ID.NeedleGun.Ammo.Sewage", 12041);
        needlegunAmmoFireItemId = configuration.getItem("item", "ID.NeedleGun.Ammo.Fire", 12042);
        needlegunAmmoAnvilItemId = configuration.getItem("item", "ID.NeedleGun.Ammo.Anvil", 12043);
        plasticCupItemId = configuration.getItem("item", "ID.PlasticCup", 12044);
        rocketLauncherItemId = configuration.getItem("item", "ID.RocketLauncher", 12045);
        rocketItemId = configuration.getItem("item", "ID.Rocket", 12046);
        plasticCellItemId = configuration.getItem("item", "ID.PlasticCell", 12047);
        fishingRodItemId = configuration.getItem("item", "ID.FishingRod", 12048);
        bagItemId = configuration.getItem("item", "ID.PlasticBag", 12049);
        zoolologistEntityId = configuration.get("Entity", "ID.Zoologist", 330);
        enableSpawnerCarts = configuration.get("Entity", "EnableSpawnerCarts", true);
        MFRConfig.enableSpawnerCarts.comment = "If true, using a portaspawner on an empty minecart will make it into a spawner cart";
        colorblindMode = configuration.get("general", "RedNet.EnableColorblindMode", false);
        MFRConfig.colorblindMode.comment = "Set to true to enable the RedNet GUI's colorblind mode.";
        MFRConfig.deleteEntry("general", "SearchDistance.TreeMaxHoriztonal");
        treeSearchMaxHorizontal = configuration.get("general", "SearchLimit.TreeMaxHorizontal", 200);
        MFRConfig.treeSearchMaxHorizontal.comment = "When searching for parts of a tree, how far out to the sides (radius) to search";
        MFRConfig.deleteEntry("general", "SearchDistance.TreeMaxVertical");
        treeSearchMaxVertical = configuration.get("general", "SearchLimit.TreeMaxVertical", 256);
        MFRConfig.treeSearchMaxVertical.comment = "When searching for parts of a tree, how far up to search";
        verticalHarvestSearchMaxVertical = configuration.get("general", "SearchDistance.StackingBlockMaxVertical", 5);
        MFRConfig.verticalHarvestSearchMaxVertical.comment = "How far upward to search for members of \"stacking\" blocks, like cactus and sugarcane";
        passengerRailSearchMaxVertical = configuration.get("general", "SearchDistance.PassengerRailMaxVertical", 2);
        MFRConfig.passengerRailSearchMaxVertical.comment = "When searching for players or dropoff locations, how far up to search";
        passengerRailSearchMaxHorizontal = configuration.get("general", "SearchDistance.PassengerRailMaxHorizontal", 3);
        MFRConfig.passengerRailSearchMaxHorizontal.comment = "When searching for players or dropoff locations, how far out to the sides (radius) to search";
        rubberTreeWorldGen = configuration.get("general", "WorldGen.RubberTree", true);
        MFRConfig.rubberTreeWorldGen.comment = "Whether or not to generate rubber trees during map generation";
        mfrLakeWorldGen = configuration.get("general", "WorldGen.MFRLakes", true);
        MFRConfig.mfrLakeWorldGen.comment = "Whether or not to generate MFR lakes during map generation";
        enableBonemealFertilizing = configuration.get("general", "Fertilizer.EnableBonemeal", false);
        MFRConfig.enableBonemealFertilizing.comment = "If true, the fertilizer will use bonemeal as well as MFR fertilizer. Provided for those who want a less work-intensive farm.";
        conveyorCaptureNonItems = configuration.get("general", "Conveyor.CaptureNonItems", true);
        MFRConfig.conveyorCaptureNonItems.comment = "If false, conveyors will not grab non-item entities. Breaks conveyor mob grinders but makes them safe for golems, etc.";
        conveyorNeverCapturesPlayers = configuration.get("general", "Conveyor.NeverCapturePlayers", false);
        MFRConfig.conveyorNeverCapturesPlayers.comment = "If true, conveyors will NEVER capture players regardless of other settings.";
        conveyorNeverCapturesTCGolems = configuration.get("general", "Conveyor.NeverCaptureTCGolems", false);
        MFRConfig.conveyorNeverCapturesTCGolems.comment = "If true, conveyors will NEVER capture Thaumcraft golems regardless of other settings.";
        playSounds = configuration.get("general", "PlaySounds", true);
        MFRConfig.playSounds.comment = "Set to false to disable the harvester's sound when a block is harvested.";
        enableSlipperyRoads = configuration.get("general", "Road.Slippery", true);
        MFRConfig.enableSlipperyRoads.comment = "If true, roads will be slippery like ice.";
        fruitTreeSearchMaxHorizontal = configuration.get("general", "SearchDistance.FruitTreeMaxHoriztonal", 5);
        MFRConfig.fruitTreeSearchMaxHorizontal.comment = "When searching for parts of a fruit tree, how far out to the sides (radius) to search";
        fruitTreeSearchMaxVertical = configuration.get("general", "SearchDistance.FruitTreeMaxVertical", 20);
        MFRConfig.fruitTreeSearchMaxVertical.comment = "When searching for parts of a fruit tree, how far up to search";
        breederShutdownThreshold = configuration.get("general", "Breeder.ShutdownThreshold", 50);
        MFRConfig.breederShutdownThreshold.comment = "If the number of entities in the breeder's target area exceeds this value, the breeder will cease operating. This is provided to control server lag.";
        autospawnerCostExact = configuration.get("general", "AutoSpawner.Cost.Exact", 50);
        MFRConfig.autospawnerCostExact.comment = "The work required to generate a mob in exact mode.";
        autospawnerCostStandard = configuration.get("general", "AutoSpawner.Cost.Standard", 15);
        MFRConfig.autospawnerCostStandard.comment = "The work required to generate a mob in standard (non-exact) mode.";
        laserdrillCost = configuration.get("general", "LaserDrill.Cost", 300);
        MFRConfig.laserdrillCost.comment = "The work required by the drill to generate a single ore.";
        meatSaturation = configuration.get("general", "Meat.IncreasedSaturation", false);
        MFRConfig.meatSaturation.comment = "If true, meat will be worth steak saturation instead of cookie saturation.";
        fishingDropRate = configuration.get("general", "FishDropRate", 5);
        MFRConfig.fishingDropRate.comment = "The rate at which fish are dropped from the fishing rod. The drop rate is 1 / this number. Must be greater than 0.";
        vanillaOverrideGlassPane = configuration.get("general", "VanillaOverride.GlassPanes", true);
        MFRConfig.vanillaOverrideGlassPane.comment = "If true, allows vanilla glass panes to connect to MFR stained glass panes.";
        vanillaOverrideIce = configuration.get("general", "VanillaOverride.Ice", true);
        MFRConfig.vanillaOverrideIce.comment = "If true, enables MFR unmelting ice as well as vanilla ice.";
        vanillaOverrideMilkBucket = configuration.get("general", "VanillaOverride.MilkBucket", true);
        MFRConfig.vanillaOverrideMilkBucket.comment = "If true, replaces the vanilla milk bucket so milk can be placed in the world.";
        redNetDebug = configuration.get("general", "RedNet.Debug", false);
        MFRConfig.redNetDebug.comment = "If true, RedNet cables will dump a massive amount of data to the log file. You should probably only use this if PC tells you to.";
        rubberTreeBiomeWhitelist = configuration.get("general", "WorldGen.RubberTreeBiomeWhitelist", "");
        MFRConfig.rubberTreeBiomeWhitelist.comment = "A comma-separated list of biomes to allow rubber trees to spawn in. Does nothing if rubber tree worldgen is disabled.";
        rubberTreeBiomeBlacklist = configuration.get("general", "WorldGen.RubberTreeBiomeBlacklist", "");
        MFRConfig.rubberTreeBiomeBlacklist.comment = "A comma-separated list of biomes to disallow rubber trees to spawn in. Overrides any other biomes added.";
        redNetConnectionBlacklist = configuration.get("general", "RedNet.ConnectionBlackList", "");
        MFRConfig.redNetConnectionBlacklist.comment = "A comma-separated list of block IDs to prevent RedNet cables from connecting to.";
        worldGenDimensionBlacklist = configuration.get("general", "WorldGen.DimensionBlacklist", "");
        MFRConfig.worldGenDimensionBlacklist.comment = "A comma-separated list of dimension IDs to disable MFR worldgen in. By default, MFR will not attempt worldgen in dimensions where the player cannot respawn.";
        mfrLakeSludgeRarity = configuration.get("general", "WorldGen.LakeRarity.Sludge", 32);
        MFRConfig.mfrLakeSludgeRarity.comment = "Higher numbers make sludge lakes rarer. A value of one will be approximately one per chunk.";
        mfrLakeSewageRarity = configuration.get("general", "WorldGen.LakeRarity.Sewage", 32);
        MFRConfig.mfrLakeSewageRarity.comment = "Higher numbers make sewage lakes rarer. A value of one will be approximately one per chunk.";
        unifierBlacklist = configuration.get("general", "Unifier.Blacklist", "dyeBlue,dyeWhite,dyeBrown");
        MFRConfig.unifierBlacklist.comment = "A comma-separated list of ore dictionary entrys to disable unifying for. By default, MFR will not attempt to unify anything with more than one oredict name.";
        enableLiquidSyringe = configuration.get("general", "LiquidSyringes", true);
        MFRConfig.enableLiquidSyringe.comment = "If true, Empty Syringes will be able to contain liquids and inject players.";
        enableSPAMRExploding = configuration.get("item", "SPAMR.Exploding", true);
        MFRConfig.enableSPAMRExploding.comment = "If true, SPAMRs will explode when they run out of fuel.";
        enableFuelExploding = configuration.get("general", "Biofuel.Exploding", true);
        MFRConfig.enableFuelExploding.comment = "If true, biofuel will explode when in the nether.";
        spawnerBlacklist = configuration.get("general", "AutoSpawner.Blacklist", "");
        MFRConfig.spawnerBlacklist.comment = "A comma-separated list of entity IDs (e.g.: CaveSpider,VillagerGolem,butterflyGE) to blacklist from the AutoSpawner.";
        enableMassiveTree = configuration.get("general", "WorldGen.SacredRubberSapling", true);
        MFRConfig.enableMassiveTree.comment = "If true, enable adding Sacred Rubber Sapling to jungle temple loot.";
        vanillaRecipes = configuration.get("RecipeSets", "EnableVanillaRecipes", true);
        MFRConfig.vanillaRecipes.comment = "If true, MFR will register its standard (vanilla-item-only) recipes.";
        thermalExpansionRecipes = configuration.get("RecipeSets", "EnableThermalExpansionRecipes", false);
        MFRConfig.thermalExpansionRecipes.comment = "If true, MFR will register its Thermal Expansion-based recipes.";
        gregTechRecipes = configuration.get("RecipeSets", "EnableGregTechRecipes", false);
        MFRConfig.gregTechRecipes.comment = "If true, MFR will register its GregTech-based recipes.";
        enableCheapDSU = MFRConfig.loadLegacy("item", "Recipe.CheaperDSU", "general", "DSU.EnableCheaperRecipe", false);
        MFRConfig.enableCheapDSU.comment = "If true, DSU can be built out of chests instead of ender pearls. Does nothing if the DSU recipe is disabled.";
        craftSingleDSU = MFRConfig.loadLegacy("item", "Recipe.SingleDSU", "general", "DSU.CraftSingle", false);
        MFRConfig.craftSingleDSU.comment = "DSU recipes will always craft one DSU. Does nothing for recipes that already only craft one DSU (cheap mode, GT recipes, etc).";
        enableMossyCobbleRecipe = MFRConfig.loadLegacy("item", "Recipe.MossyCobble", "general", "EnableMossyCobbleRecipe", false);
        MFRConfig.enableMossyCobbleRecipe.comment = "If true, mossy cobble can be crafted.";
        enablePortaSpawner = configuration.get("item", "Recipe.PortaSpawner", true);
        MFRConfig.enablePortaSpawner.comment = "If true, the PortaSpawner will be craftable.";
        enableSyringes = configuration.get("item", "Recipe.Syringes", true);
        MFRConfig.enableSyringes.comment = "If true, the Syringes will be craftable.";
        enableGuns = configuration.get("item", "Recipe.Guns", true);
        MFRConfig.enableGuns.comment = "If true, the Guns will be craftable.";
        enableNetLauncher = configuration.get("item", "Recipe.NetLauncher", true);
        MFRConfig.enableNetLauncher.comment = "If true, the safarinet launcher will be craftable.";
        for (Machine machine : Machine.values()) {
            machine.load(configuration);
        }
        dropFilledContainers = configuration.get("general", "Tanks.FillWithoutEmptySlots", true);
        MFRConfig.dropFilledContainers.comment = "If true, when you have no empty slots in your inventory, you will continue filling buckets from tanks and drop them on the ground.";
        configuration.save();
    }

    private static Property loadLegacy(String string, String string2, String string3, String string4, boolean bl) {
        Property property = null;
        String string5 = null;
        if (config.hasKey(string3, string4)) {
            property = config.get(string3, string4, bl);
            string5 = property.getString();
            MFRConfig.deleteEntry(string3, string4);
        }
        property = config.get(string, string2, bl);
        if (string5 != null) {
            property.set(string5);
        }
        return property;
    }

    private static void deleteEntry(String string, String string2) {
        config.getCategory(string).remove((Object)string2);
    }
}

