/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.IEnergyInfo;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public abstract class TileEntityFactoryPowered
extends TileEntityFactoryInventory
implements IPowerReceptor,
IEnergySink,
IEnergyHandler,
IEnergyInfo {
    public static final int energyPerEU = 4;
    public static final int energyPerMJ = 10;
    private int _energyStored;
    private int _maxEnergyStored;
    private int _maxEnergyTick;
    private int _energyRequiredThisTick = 0;
    private int _energyActivation;
    private int _workDone;
    private int _idleTicks;
    protected PowerHandler _powerProvider;
    private boolean _isAddedToIC2EnergyNet;
    private boolean _addToNetOnNextTick;

    protected TileEntityFactoryPowered(Machine machine) {
        this(machine, machine.getActivationEnergy());
    }

    protected TileEntityFactoryPowered(Machine machine, int n) {
        super(machine);
        this._maxEnergyStored = machine.getMaxEnergyStorage();
        this._energyActivation = n;
        this._maxEnergyTick = Math.min(n * 5, 1000);
        this._powerProvider = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.configurePowerProvider();
        this.setIsActive(false);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this._energyStored = Math.min(this._energyStored, this.getEnergyStoredMax());
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this._addToNetOnNextTick) {
            if (!this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this._addToNetOnNextTick = false;
            this._isAddedToIC2EnergyNet = true;
        }
        int n = Math.min(this.getEnergyStoredMax() - this.getEnergyStored(), this.getActivationEnergy());
        this._energyRequiredThisTick = Math.max(this._energyRequiredThisTick + n, this.getMaxEnergyPerTick());
        this.setIsActive(this._energyStored >= this._energyActivation * 2);
        if (this.failedDrops != null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return;
        }
        if (Util.isRedstonePowered((TileEntity)this)) {
            this.setIdleTicks(this.getIdleTicksMax());
        } else if (this._idleTicks > 0) {
            --this._idleTicks;
        } else if (this._energyStored >= this._energyActivation && this.activateMachine()) {
            this._energyStored -= this._energyActivation;
        }
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        if (!this._isAddedToIC2EnergyNet) {
            this._addToNetOnNextTick = true;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this._isAddedToIC2EnergyNet) {
            if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this._isAddedToIC2EnergyNet = false;
        }
    }

    protected abstract boolean activateMachine();

    @Override
    public void onDisassembled() {
        super.onDisassembled();
        if (this._isAddedToIC2EnergyNet) {
            if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this._isAddedToIC2EnergyNet = false;
        }
    }

    public int getActivationEnergy() {
        return this._energyActivation;
    }

    @Override
    public int getMaxEnergyPerTick() {
        return this._maxEnergyTick;
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public int getEnergyStoredMax() {
        return this._maxEnergyStored;
    }

    public void setEnergyStored(int n) {
        this._energyStored = n;
    }

    public void drainEnergy(int n) {
        this._energyStored -= n;
    }

    public int getWorkDone() {
        return this._workDone;
    }

    public abstract int getWorkMax();

    public void setWorkDone(int n) {
        this._workDone = n;
    }

    public int getIdleTicks() {
        return this._idleTicks;
    }

    public abstract int getIdleTicksMax();

    public void setIdleTicks(int n) {
        this._idleTicks = n;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("energyStored", this._energyStored);
        nBTTagCompound.func_74768_a("workDone", this._workDone);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        this._powerProvider.writeToNBT(nBTTagCompound2);
        nBTTagCompound.func_74766_a("powerProvider", nBTTagCompound2);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._energyStored = Math.min(nBTTagCompound.func_74762_e("energyStored"), this.getEnergyStoredMax());
        this._workDone = Math.min(nBTTagCompound.func_74762_e("workDone"), this.getWorkMax());
        if (nBTTagCompound.func_74764_b("powerProvider")) {
            this._powerProvider.readFromNBT(nBTTagCompound.func_74775_l("powerProvider"));
        }
        this.configurePowerProvider();
    }

    public int getEnergyRequired() {
        return Math.min(this.getEnergyStoredMax() - this.getEnergyStored(), this._energyRequiredThisTick);
    }

    public int storeEnergy(int n, boolean bl) {
        int n2 = Math.max(Math.min(n, this.getEnergyRequired()), 0);
        if (bl) {
            this._energyStored += n2;
            this._energyRequiredThisTick -= n2;
        }
        return n2;
    }

    public int storeEnergy(int n) {
        return this.storeEnergy(n, true);
    }

    @Override
    public int getEnergyPerTick() {
        return this.getEnergyRequired();
    }

    @Override
    public int getEnergy() {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergy() {
        return this.getEnergyStoredMax();
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.storeEnergy(n, !bl);
    }

    @Override
    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.getEnergyStoredMax();
    }

    protected void configurePowerProvider() {
        int n = this.getMaxEnergyPerTick() / 10;
        this._powerProvider.configure(this.getMinMJ(), n, 0.1f, 1000.0f);
        this._powerProvider.configurePowerPerdition(0, 0);
    }

    protected float getMinMJ() {
        return this.getActivationEnergy() < 100 ? 0.1f : 10.0f;
    }

    @Override
    public final PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection forgeDirection) {
        if (this.getEnergyRequired() > 0) {
            this._powerProvider.configure(this.getMinMJ(), this.getEnergyRequired() / 10, 0.1f, 1000.0f);
            return this._powerProvider.getPowerReceiver();
        }
        this._powerProvider.configure(0.0f, 0.0f, 1.0f, 1000.0f);
        return null;
    }

    @Override
    public final void doWork(PowerHandler powerHandler) {
        float f;
        if (powerHandler != null && !((f = (float)this.getEnergyRequired() / 10.0f) <= 0.0f)) {
            float f2 = 0.002f;
            if (powerHandler.useEnergy(0.0f, f, false) > 0.0f) {
                int n = (int)(((double)powerHandler.useEnergy(0.0f, f, true) + 0.009) * 10.0);
                this.storeEnergy(n);
                f2 += 0.001f;
            }
            powerHandler.addEnergy(f2);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.POWER && this.getActivationEnergy() > 0) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return super.overridePipeConnection(pipeType, forgeDirection);
    }

    @Override
    public double demandedEnergyUnits() {
        return Math.max(Math.ceil((double)this.getEnergyRequired() / 4.0), 0.0);
    }

    @Override
    public double injectEnergyUnits(ForgeDirection forgeDirection, double d) {
        double d2 = Math.max(d, 0.0);
        d2 -= (double)this.storeEnergy((int)(d2 * 4.0)) / 4.0;
        return d2;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return 128;
    }

    public int demandsEnergy() {
        return Math.max(this.getEnergyRequired() / 4, 0);
    }

    public int injectEnergy(Direction direction, int n) {
        int n2 = Math.max(n, 0);
        n2 -= this.storeEnergy(n2 * 4) / 4;
        return n2;
    }

    public boolean acceptsEnergyFrom(TileEntity tileEntity, Direction direction) {
        return true;
    }
}

