/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.util.UtilInventory;
import powercrystals.minefactoryreloaded.core.IEntityCollidable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityCollector
extends TileEntityFactoryInventory
implements IEntityCollidable {
    protected boolean canStuff;

    public TileEntityCollector() {
        super(Machine.ItemCollector);
        this.setManageSolids(true);
        this.canStuff = false;
    }

    @Override
    public void onEntityCollided(Entity entity) {
        if (this.failedDrops == null && entity instanceof EntityItem) {
            this.addToChests((EntityItem)entity);
        }
    }

    protected void addToChests(EntityItem entityItem) {
        if (entityItem.field_70128_L) {
            return;
        }
        ItemStack itemStack = this.addToChests(entityItem.func_92059_d());
        if (itemStack == null) {
            entityItem.func_70106_y();
            return;
        }
        entityItem.func_92058_a(itemStack);
    }

    protected ItemStack addToChests(ItemStack itemStack) {
        if (this.canStuff & this.failedDrops == null & (itemStack = UtilInventory.dropStack((TileEntity)this, (ItemStack)itemStack, (ForgeDirection[])MFRUtil.directionsWithoutConveyors(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n), (ForgeDirection)ForgeDirection.UNKNOWN)) != null) {
            this.doDrop(itemStack);
            itemStack = null;
        }
        return itemStack;
    }

    public boolean func_70309_m() {
        return this.field_70331_k != null & this.failedDrops != null;
    }

    @Override
    public int getComparatorOutput(int n) {
        return this.failedDrops != null ? 15 : 0;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public ForgeDirection[] getDropDirections() {
        return MFRUtil.directionsWithoutConveyors(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    protected void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this.canStuff) {
            nBTTagCompound.func_74757_a("hasTinkerStuff", true);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this.canStuff = nBTTagCompound.func_74767_n("hasTinkerStuff");
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("hasTinkerStuff", this.canStuff);
    }
}

