/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.net.PacketWrapper;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.position.INeighboorUpdateTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetDecorative;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNoConnection;
import powercrystals.minefactoryreloaded.api.rednet.RedNetConnectionType;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;

public class TileEntityRedNetCable
extends TileEntity
implements INeighboorUpdateTile {
    private int[] _sideColors = new int[6];
    private byte _mode;
    private RedstoneNetwork _network;
    private boolean _needsNetworkUpdate;
    private static final int _maxVanillaBlockId = 158;
    private static List<Integer> _connectionWhitelist = Arrays.asList(23, 25, 27, 28, 29, 33, 46, 55, 64, 69, 70, 71, 72, 75, 76, 77, 93, 94, 96, 107, 123, 124, 131, 143, 147, 148, 149, 150, 151, 152, 154, 157, 158);
    private static List<Integer> _connectionBlackList;

    public TileEntityRedNetCable() {
        if (_connectionBlackList == null) {
            _connectionBlackList = new LinkedList<Integer>();
            for (String string : MFRConfig.redNetConnectionBlacklist.getString().replace("\"", "").split(",")) {
                try {
                    int n = Integer.parseInt(string.trim());
                    _connectionBlackList.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Empty or invalid rednet blacklist entry found. Not adding to rednet blacklist.");
                }
            }
        }
    }

    public void setSideColor(ForgeDirection forgeDirection, int n) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return;
        }
        this._sideColors[forgeDirection.ordinal()] = n;
        this.updateNetwork();
    }

    public int getSideColor(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return this._sideColors[forgeDirection.ordinal()];
    }

    public byte getMode() {
        return this._mode;
    }

    public void setMode(byte by) {
        boolean bl = by != this._mode;
        this._mode = by;
        if (bl) {
            this._needsNetworkUpdate = true;
        }
    }

    public RedNetConnectionType getConnectionState(ForgeDirection forgeDirection) {
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        blockPosition.orientation = forgeDirection;
        blockPosition.moveForwards(1);
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        Block block = Block.field_71973_m[n];
        if (block == null) {
            return RedNetConnectionType.None;
        }
        if (n == MineFactoryReloadedCore.rednetCableBlock.field_71990_ca) {
            return RedNetConnectionType.CableAll;
        }
        if (this._mode == 3) {
            return RedNetConnectionType.None;
        }
        if (block instanceof IConnectableRedNet) {
            RedNetConnectionType redNetConnectionType = ((IConnectableRedNet)block).getConnectionType(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirection.getOpposite());
            return redNetConnectionType.isConnectionForced && !(this._mode == 1 | this._mode == 2) ? RedNetConnectionType.None : redNetConnectionType;
        }
        if (block instanceof IRedNetNoConnection || block.isAirBlock(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z)) {
            return RedNetConnectionType.None;
        }
        if (this._mode == 2 && block.isBlockSolidOnSide(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirection.getOpposite())) {
            return RedNetConnectionType.ForcedCableSingle;
        }
        if (this._mode == 1) {
            return RedNetConnectionType.ForcedPlateSingle;
        }
        if (n <= 158 && !_connectionWhitelist.contains(n) || _connectionBlackList.contains(n) || block instanceof IRedNetDecorative) {
            return RedNetConnectionType.None;
        }
        if (block.isBlockSolidOnSide(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirection.getOpposite())) {
            return RedNetConnectionType.CableSingle;
        }
        return RedNetConnectionType.PlateSingle;
    }

    public Packet func_70319_e() {
        return PacketWrapper.createPacket((String)"MFReloaded", (int)11, (Object[])new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, this._sideColors[0], this._sideColors[1], this._sideColors[2], this._sideColors[3], this._sideColors[4], this._sideColors[5], this._mode});
    }

    public void func_70312_q() {
        super.func_70312_q();
        this._needsNetworkUpdate = true;
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this._network != null && this._network.isInvalid()) {
            this._network = null;
            this._needsNetworkUpdate = true;
        }
        if (this._needsNetworkUpdate) {
            this._needsNetworkUpdate = false;
            this.updateNetwork();
        }
        this._network.tick();
    }

    public void onNeighboorChanged() {
        this._needsNetworkUpdate = true;
    }

    public RedstoneNetwork getNetwork() {
        return this._network;
    }

    public void setNetwork(RedstoneNetwork redstoneNetwork) {
        this._network = redstoneNetwork;
        this._network.addCable(new BlockPosition((TileEntity)this));
    }

    private void updateNetwork() {
        TileEntityRedNetCable tileEntityRedNetCable;
        TileEntity tileEntity;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        RedstoneNetwork.log("Cable at %s updating network", blockPosition.toString());
        if (this._network == null) {
            for (BlockPosition blockPosition2 : blockPosition.getAdjacent(true)) {
                tileEntity = blockPosition2.getTileEntity(this.field_70331_k);
                if (!(tileEntity instanceof TileEntityRedNetCable) || (tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity).getNetwork() == null || tileEntityRedNetCable.getNetwork().isInvalid()) continue;
                this._network = tileEntityRedNetCable.getNetwork();
                break;
            }
        }
        if (this._network == null) {
            RedstoneNetwork.log("Initializing new network at %s", blockPosition.toString());
            this.setNetwork(new RedstoneNetwork(this.field_70331_k));
        }
        for (BlockPosition blockPosition2 : blockPosition.getAdjacent(true)) {
            tileEntity = blockPosition2.getTileEntity(this.field_70331_k);
            if (tileEntity instanceof TileEntityRedNetCable) {
                tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
                if (tileEntityRedNetCable.getNetwork() == null) {
                    tileEntityRedNetCable.setNetwork(this._network);
                    continue;
                }
                if (tileEntityRedNetCable.getNetwork() == this._network || tileEntityRedNetCable.getNetwork() == null || tileEntityRedNetCable.getNetwork().isInvalid()) continue;
                this._network.mergeNetwork(tileEntityRedNetCable.getNetwork());
                continue;
            }
            this.updateNearbyNode(blockPosition2);
        }
    }

    public void updateNodes() {
        for (BlockPosition blockPosition : new BlockPosition((TileEntity)this).getAdjacent(true)) {
            this.updateNearbyNode(blockPosition);
        }
    }

    private void updateNearbyNode(BlockPosition blockPosition) {
        int n = this.getSideColor(blockPosition.orientation);
        RedNetConnectionType redNetConnectionType = this.getConnectionState(blockPosition.orientation);
        if (!this.field_70331_k.func_72799_c(blockPosition.x, blockPosition.y, blockPosition.z)) {
            if (redNetConnectionType.isAllSubnets) {
                this._network.addOrUpdateNode(blockPosition);
            } else if (redNetConnectionType.isCable) {
                this._network.addOrUpdateNode(blockPosition, n, false);
            } else if (redNetConnectionType.isPlate) {
                this._network.addOrUpdateNode(blockPosition, n, true);
            } else {
                this._network.removeNode(blockPosition);
            }
        } else {
            this._network.removeNode(blockPosition);
        }
    }

    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74783_a("sideSubnets", this._sideColors);
        nBTTagCompound.func_74774_a("mode", this._mode);
        nBTTagCompound.func_74774_a("v", (byte)1);
    }

    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._sideColors = nBTTagCompound.func_74759_k("sideSubnets");
        if (this._sideColors.length == 0) {
            this._sideColors = new int[6];
        }
        this._mode = nBTTagCompound.func_74771_c("mode");
        switch (nBTTagCompound.func_74771_c("v")) {
            case 0: {
                if (this._mode != 2) break;
                this._mode = (byte)3;
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_82115_m() {
        return 4096.0;
    }
}

