/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.world.WorldGenLakesMeta;
import powercrystals.minefactoryreloaded.world.WorldGenRubberTree;

public class MineFactoryReloadedWorldGen
implements IWorldGenerator {
    private static List<Integer> _blacklistedDimensions;

    public void generate(Random random, int n, int n2, World world, IChunkProvider iChunkProvider, IChunkProvider iChunkProvider2) {
        if (_blacklistedDimensions == null) {
            _blacklistedDimensions = MineFactoryReloadedWorldGen.buildBlacklistedDimensions();
        }
        if (_blacklistedDimensions.contains(world.field_73011_w.field_76574_g)) {
            return;
        }
        int n3 = n * 16 + random.nextInt(16);
        int n4 = n2 * 16 + random.nextInt(16);
        BiomeGenBase biomeGenBase = world.func_72807_a(n3, n4);
        if (MFRConfig.rubberTreeWorldGen.getBoolean(true) && MFRRegistry.getRubberTreeBiomes().contains(biomeGenBase.field_76791_y) && random.nextInt(100) < 40) {
            new WorldGenRubberTree().func_76484_a(world, random, n3, random.nextInt(3) + 4, n4);
        }
        if (MFRConfig.mfrLakeWorldGen.getBoolean(true) && world.field_73011_w.func_76567_e()) {
            int n5;
            int n6;
            int n7;
            int n8 = MFRConfig.mfrLakeSludgeRarity.getInt();
            if (n8 > 0 && random.nextInt(n8) == 0) {
                n7 = n3 - 8 + random.nextInt(16);
                n6 = random.nextInt(128);
                n5 = n4 - 8 + random.nextInt(16);
                new WorldGenLakesMeta(MineFactoryReloadedCore.sludgeLiquid.field_71990_ca, 0).func_76484_a(world, random, n7, n6, n5);
            }
            if ((n8 = MFRConfig.mfrLakeSewageRarity.getInt()) > 0 && random.nextInt(n8) == 0) {
                n7 = n3 - 8 + random.nextInt(16);
                n6 = random.nextInt(128);
                n5 = n4 - 8 + random.nextInt(16);
                if (biomeGenBase.field_76791_y.toLowerCase().contains("mushroom")) {
                    new WorldGenLakesMeta(MineFactoryReloadedCore.mushroomSoupLiquid.field_71990_ca, 0).func_76484_a(world, random, n7, n6, n5);
                } else {
                    new WorldGenLakesMeta(MineFactoryReloadedCore.sewageLiquid.field_71990_ca, 0).func_76484_a(world, random, n7, n6, n5);
                }
            }
        }
    }

    private static List<Integer> buildBlacklistedDimensions() {
        String string = MFRConfig.worldGenDimensionBlacklist.getString();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string == null) {
            return arrayList;
        }
        string = string.trim();
        for (String string2 : string.split(",")) {
            try {
                Integer n = Integer.parseInt(string2);
                arrayList.add(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }
}

