/*
 * Decompiled with CFR 0.152.
 */
package worldcore.asm;

import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import worldcore.interfaces.IWCLighting;

public class WCDimensionLight
implements IClassTransformer {
    public byte[] transform(String name, String newname, byte[] bytes) {
        if (name.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return WCDimensionLight.patchEntityRenderer(newname, bytes, false);
        }
        if (name.equals("bfe")) {
            return WCDimensionLight.patchEntityRenderer(newname, bytes, true);
        }
        return bytes;
    }

    public static byte[] patchEntityRenderer(String name, byte[] bytes, boolean obfuscated) {
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean found = false;
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.name.equals("updateLightmap") || methodNode.name.equals("h")) {
                for (AbstractInsnNode insnNode : methodNode.instructions) {
                    FieldInsnNode fieldInsnNode2;
                    FieldInsnNode fieldInsnNode;
                    VarInsnNode varInsnNode;
                    if (!(insnNode instanceof VarInsnNode) || (varInsnNode = (VarInsnNode)insnNode).getOpcode() != 25 || varInsnNode.var != 2 || !(varInsnNode.getNext() instanceof FieldInsnNode) || (fieldInsnNode = (FieldInsnNode)varInsnNode.getNext()).getOpcode() != 180 || !fieldInsnNode.name.equals("provider") && !fieldInsnNode.name.equals("t") || !(fieldInsnNode.getNext() instanceof FieldInsnNode) || (fieldInsnNode2 = (FieldInsnNode)fieldInsnNode.getNext()).getOpcode() != 180 || !fieldInsnNode2.name.equals("dimensionId") && !fieldInsnNode2.name.equals("i")) continue;
                    InsnList toInject = new InsnList();
                    toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    toInject.add((AbstractInsnNode)new VarInsnNode(23, 6));
                    toInject.add((AbstractInsnNode)new VarInsnNode(23, 9));
                    toInject.add((AbstractInsnNode)new VarInsnNode(23, 10));
                    toInject.add((AbstractInsnNode)new VarInsnNode(23, 11));
                    toInject.add((AbstractInsnNode)new VarInsnNode(23, 12));
                    toInject.add((AbstractInsnNode)new VarInsnNode(23, 13));
                    if (obfuscated) {
                        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "worldcore/asm/WCDimensionLight", "getAmbientLightingValues", "(Lbdd;FFFFFF)[Ljava/lang/Object;"));
                    } else {
                        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "worldcore/asm/WCDimensionLight", "getAmbientLightingValues", "(Lnet/minecraft/client/multiplayer/WorldClient;FFFFFF)[Ljava/lang/Object;"));
                    }
                    toInject.add((AbstractInsnNode)new VarInsnNode(58, 15));
                    toInject.add((AbstractInsnNode)new VarInsnNode(25, 15));
                    toInject.add((AbstractInsnNode)new InsnNode(3));
                    toInject.add((AbstractInsnNode)new InsnNode(50));
                    toInject.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Float"));
                    toInject.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F"));
                    toInject.add((AbstractInsnNode)new VarInsnNode(56, 11));
                    toInject.add((AbstractInsnNode)new VarInsnNode(25, 15));
                    toInject.add((AbstractInsnNode)new InsnNode(4));
                    toInject.add((AbstractInsnNode)new InsnNode(50));
                    toInject.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Float"));
                    toInject.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F"));
                    toInject.add((AbstractInsnNode)new VarInsnNode(56, 12));
                    toInject.add((AbstractInsnNode)new VarInsnNode(25, 15));
                    toInject.add((AbstractInsnNode)new InsnNode(5));
                    toInject.add((AbstractInsnNode)new InsnNode(50));
                    toInject.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Float"));
                    toInject.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F"));
                    toInject.add((AbstractInsnNode)new VarInsnNode(56, 13));
                    methodNode.instructions.insert(insnNode, toInject);
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            throw new RuntimeException("updateLightmap transformer failed");
        }
        ClassWriter classWriter = new ClassWriter(3);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static Object[] getAmbientLightingValues(WorldClient worldclient, float f3, float f6, float f7, float f8, float f9, float f10) {
        IWCLighting provider;
        if (worldclient.field_73011_w instanceof IWCLighting && (provider = (IWCLighting)worldclient.field_73011_w).isLightingDisabled()) {
            Float[] lightingMultipliers = provider.getLightingMultipliers(worldclient);
            float multiplier1 = lightingMultipliers[0].floatValue();
            float multiplier2 = lightingMultipliers[1].floatValue();
            float multiplier3 = lightingMultipliers[2].floatValue();
            return new Object[]{Float.valueOf(multiplier1 + f3 * 0.75f), Float.valueOf(multiplier2 + f6 * 0.75f), Float.valueOf(multiplier3 + f7 * 0.75f)};
        }
        return new Object[]{Float.valueOf(f8), Float.valueOf(f9), Float.valueOf(f10)};
    }
}

