/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mrtjp.projectred.core.fx.ParticleIconRegistry;
import mrtjp.projectred.core.fx.ParticleLogic;

public class ParticleLogicIconShift
extends ParticleLogic {
    private List<ms> icons = new ArrayList<ms>();
    private int tickDelay = 0;
    private int ticksRemaining = 0;
    private int iconIndex = 0;

    public static ParticleLogicIconShift fluttering() {
        ParticleLogicIconShift logic = new ParticleLogicIconShift().addIcon("flutter1").addIcon("flutter2").addIcon("flutter3").addIcon("flutter4");
        logic.setTicksBetweenChange(3);
        return logic;
    }

    public ParticleLogicIconShift addIcon(String icon) {
        this.icons.add(ParticleIconRegistry.instance.getIcon(icon));
        return this;
    }

    public ParticleLogicIconShift setTicksBetweenChange(int ticks) {
        this.tickDelay = this.ticksRemaining = ticks;
        return this;
    }

    @Override
    public void doUpdate() {
        if (--this.ticksRemaining > 0) {
            return;
        }
        this.ticksRemaining = this.tickDelay;
        if (this.icons.isEmpty()) {
            return;
        }
        this.shiftIconIndex();
        this.shiftDelay();
        this.particle.a(this.icons.get(this.iconIndex));
    }

    private void shiftIconIndex() {
        this.iconIndex = (this.iconIndex + 1) % this.icons.size();
    }

    private void shiftDelay() {
        int newDelay = this.tickDelay + ls.a((Random)this.rand, (int)-1, (int)1);
        this.setTicksBetweenChange(newDelay);
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicIconShift clone = new ParticleLogicIconShift();
        clone.setTicksBetweenChange(this.tickDelay);
        for (ms icon : this.icons) {
            clone.icons.add(icon);
        }
        return clone.setFinal(this.finalLogic).setPriority(this.priority);
    }
}

